/*
 * Decompiled with CFR 0.152.
 */
package javax.tools;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import javax.tools.DocumentationTool;
import javax.tools.JavaCompiler;

public class ToolProvider {
    private static final String systemJavaCompilerModule = "jdk.compiler";
    private static final String systemJavaCompilerName = "com.sun.tools.javac.api.JavacTool";
    private static final String systemDocumentationToolModule = "jdk.javadoc";
    private static final String systemDocumentationToolName = "jdk.javadoc.internal.api.JavadocTool";
    private static final boolean useLegacy;

    public static JavaCompiler getSystemJavaCompiler() {
        return ToolProvider.getSystemTool(JavaCompiler.class, systemJavaCompilerModule, systemJavaCompilerName);
    }

    public static DocumentationTool getSystemDocumentationTool() {
        return ToolProvider.getSystemTool(DocumentationTool.class, systemDocumentationToolModule, systemDocumentationToolName);
    }

    @Deprecated
    public static ClassLoader getSystemToolClassLoader() {
        return null;
    }

    private static <T> T getSystemTool(Class<T> clazz, String string, String string2) {
        if (useLegacy) {
            try {
                return Class.forName(string2, true, ClassLoader.getSystemClassLoader()).asSubclass(clazz).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                throw new Error(reflectiveOperationException);
            }
        }
        try {
            ServiceLoader<T> serviceLoader = ServiceLoader.load(clazz, ClassLoader.getSystemClassLoader());
            for (T t2 : serviceLoader) {
                if (!ToolProvider.matches(t2, string)) continue;
                return t2;
            }
        }
        catch (ServiceConfigurationError serviceConfigurationError) {
            throw new Error(serviceConfigurationError);
        }
        return null;
    }

    private static <T> boolean matches(T t2, String string) {
        PrivilegedAction<Boolean> privilegedAction = () -> {
            try {
                Method method = Class.class.getDeclaredMethod("getModule", new Class[0]);
                Object object2 = method.invoke(t2.getClass(), new Object[0]);
                Method method2 = object2.getClass().getDeclaredMethod("getName", new Class[0]);
                String string2 = (String)method2.invoke(object2, new Object[0]);
                return string.equals(string2);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                return false;
            }
        };
        return AccessController.doPrivileged(privilegedAction);
    }

    static {
        Class<?> clazz = null;
        try {
            clazz = Class.forName("java.lang.Module");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        useLegacy = clazz == null;
    }
}

