/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.v465;

import com.nukkitx.protocol.bedrock.data.LevelEventType;
import com.nukkitx.protocol.bedrock.data.SoundEvent;
import com.nukkitx.protocol.bedrock.data.entity.EntityEventType;
import com.nukkitx.protocol.bedrock.data.skin.AnimationData;
import com.nukkitx.protocol.bedrock.data.skin.ImageData;
import com.nukkitx.protocol.bedrock.data.skin.PersonaPieceData;
import com.nukkitx.protocol.bedrock.data.skin.PersonaPieceTintData;
import com.nukkitx.protocol.bedrock.data.skin.SerializedSkin;
import com.nukkitx.protocol.bedrock.v448.BedrockPacketHelper_v448;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Objects;

public class BedrockPacketHelper_v465
extends BedrockPacketHelper_v448 {
    public static final BedrockPacketHelper_v465 INSTANCE = new BedrockPacketHelper_v465();

    @Override
    protected void registerEntityEvents() {
        super.registerEntityEvents();
        this.addEntityEvent(76, EntityEventType.ENTITY_GROW_UP);
    }

    @Override
    protected void registerLevelEvents() {
        super.registerLevelEvents();
        this.addLevelEvent(2034, LevelEventType.PARTICLE_TURTLE_EGG);
        this.addLevelEvent(2035, LevelEventType.PARTICLE_SCULK_SHRIEK);
        int legacy2 = 16384;
        this.addLevelEvent(82 + legacy2, LevelEventType.PARTICLE_SHRIEK);
    }

    @Override
    protected void registerSoundEvents() {
        super.registerSoundEvents();
        this.addSoundEvent(363, SoundEvent.BLOCK_CLICK);
        this.addSoundEvent(364, SoundEvent.BLOCK_CLICK_FAIL);
        this.addSoundEvent(366, SoundEvent.SCULK_SHRIEKER_SHRIEK);
        this.addSoundEvent(367, SoundEvent.WARDEN_NEARBY_CLOSE);
        this.addSoundEvent(368, SoundEvent.WARDEN_NEARBY_CLOSER);
        this.addSoundEvent(369, SoundEvent.WARDEN_NEARBY_CLOSEST);
        this.addSoundEvent(370, SoundEvent.WARDEN_SLIGHTLY_ANGRY);
        this.addSoundEvent(371, SoundEvent.UNDEFINED);
    }

    @Override
    public SerializedSkin readSkin(ByteBuf buffer) {
        String skinId = this.readString(buffer);
        String playFabId = this.readString(buffer);
        String skinResourcePatch = this.readString(buffer);
        ImageData skinData = this.readImage(buffer);
        int animationCount = buffer.readIntLE();
        ObjectArrayList animations = new ObjectArrayList();
        for (int i = 0; i < animationCount; ++i) {
            animations.add(this.readAnimationData(buffer));
        }
        ImageData capeData = this.readImage(buffer);
        String geometryData = this.readString(buffer);
        String geometryDataEngineVersion = this.readString(buffer);
        String animationData = this.readString(buffer);
        String capeId = this.readString(buffer);
        String fullSkinId = this.readString(buffer);
        String armSize = this.readString(buffer);
        String skinColor = this.readString(buffer);
        ObjectArrayList personaPieces = new ObjectArrayList();
        int piecesLength = buffer.readIntLE();
        for (int i = 0; i < piecesLength; ++i) {
            String pieceId = this.readString(buffer);
            String pieceType = this.readString(buffer);
            String packId = this.readString(buffer);
            boolean isDefault = buffer.readBoolean();
            String productId = this.readString(buffer);
            personaPieces.add(new PersonaPieceData(pieceId, pieceType, packId, isDefault, productId));
        }
        ObjectArrayList tintColors = new ObjectArrayList();
        int tintsLength = buffer.readIntLE();
        for (int i = 0; i < tintsLength; ++i) {
            String pieceType = this.readString(buffer);
            ObjectArrayList colors = new ObjectArrayList();
            int colorsLength = buffer.readIntLE();
            for (int i2 = 0; i2 < colorsLength; ++i2) {
                colors.add(this.readString(buffer));
            }
            tintColors.add(new PersonaPieceTintData(pieceType, (List<String>)colors));
        }
        boolean premium = buffer.readBoolean();
        boolean persona = buffer.readBoolean();
        boolean capeOnClassic = buffer.readBoolean();
        boolean primaryUser = buffer.readBoolean();
        return SerializedSkin.of(skinId, playFabId, skinResourcePatch, skinData, (List<AnimationData>)animations, capeData, geometryData, animationData, geometryDataEngineVersion, premium, persona, capeOnClassic, primaryUser, capeId, fullSkinId, armSize, skinColor, (List<PersonaPieceData>)personaPieces, (List<PersonaPieceTintData>)tintColors);
    }

    @Override
    public void writeSkin(ByteBuf buffer, SerializedSkin skin) {
        Objects.requireNonNull(skin, "Skin is null");
        this.writeString(buffer, skin.getSkinId());
        this.writeString(buffer, skin.getPlayFabId());
        this.writeString(buffer, skin.getSkinResourcePatch());
        this.writeImage(buffer, skin.getSkinData());
        List<AnimationData> animations = skin.getAnimations();
        buffer.writeIntLE(animations.size());
        for (AnimationData animationData : animations) {
            this.writeAnimationData(buffer, animationData);
        }
        this.writeImage(buffer, skin.getCapeData());
        this.writeString(buffer, skin.getGeometryData());
        this.writeString(buffer, skin.getGeometryDataEngineVersion());
        this.writeString(buffer, skin.getAnimationData());
        this.writeString(buffer, skin.getCapeId());
        this.writeString(buffer, skin.getFullSkinId());
        this.writeString(buffer, skin.getArmSize());
        this.writeString(buffer, skin.getSkinColor());
        List<PersonaPieceData> pieces = skin.getPersonaPieces();
        buffer.writeIntLE(pieces.size());
        for (PersonaPieceData piece : pieces) {
            this.writeString(buffer, piece.getId());
            this.writeString(buffer, piece.getType());
            this.writeString(buffer, piece.getPackId());
            buffer.writeBoolean(piece.isDefault());
            this.writeString(buffer, piece.getProductId());
        }
        List<PersonaPieceTintData> list = skin.getTintColors();
        buffer.writeIntLE(list.size());
        for (PersonaPieceTintData tint : list) {
            this.writeString(buffer, tint.getType());
            List<String> colors = tint.getColors();
            buffer.writeIntLE(colors.size());
            for (String color : colors) {
                this.writeString(buffer, color);
            }
        }
        buffer.writeBoolean(skin.isPremium());
        buffer.writeBoolean(skin.isPersona());
        buffer.writeBoolean(skin.isCapeOnClassic());
        buffer.writeBoolean(skin.isPrimaryUser());
    }
}

