/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.v291.serializer;

import com.nukkitx.protocol.bedrock.BedrockPacketHelper;
import com.nukkitx.protocol.bedrock.BedrockPacketSerializer;
import com.nukkitx.protocol.bedrock.packet.TextPacket;
import io.netty.buffer.ByteBuf;

public class TextSerializer_v291
implements BedrockPacketSerializer<TextPacket> {
    public static final TextSerializer_v291 INSTANCE = new TextSerializer_v291();

    @Override
    public void serialize(ByteBuf buffer, BedrockPacketHelper helper, TextPacket packet) {
        TextPacket.Type type = packet.getType();
        buffer.writeByte(type.ordinal());
        buffer.writeBoolean(packet.isNeedsTranslation());
        switch (type) {
            case CHAT: 
            case WHISPER: 
            case ANNOUNCEMENT: {
                helper.writeString(buffer, packet.getSourceName());
            }
            case RAW: 
            case TIP: 
            case SYSTEM: {
                helper.writeString(buffer, packet.getMessage());
                break;
            }
            case TRANSLATION: 
            case POPUP: 
            case JUKEBOX_POPUP: {
                helper.writeString(buffer, packet.getMessage());
                helper.writeArray(buffer, packet.getParameters(), helper::writeString);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported TextType " + (Object)((Object)type));
            }
        }
        helper.writeString(buffer, packet.getXuid());
        helper.writeString(buffer, packet.getPlatformChatId());
    }

    @Override
    public void deserialize(ByteBuf buffer, BedrockPacketHelper helper, TextPacket packet) {
        TextPacket.Type type = TextPacket.Type.values()[buffer.readUnsignedByte()];
        packet.setType(type);
        packet.setNeedsTranslation(buffer.readBoolean());
        switch (type) {
            case CHAT: 
            case WHISPER: 
            case ANNOUNCEMENT: {
                packet.setSourceName(helper.readString(buffer));
            }
            case RAW: 
            case TIP: 
            case SYSTEM: {
                packet.setMessage(helper.readString(buffer));
                break;
            }
            case TRANSLATION: 
            case POPUP: 
            case JUKEBOX_POPUP: {
                packet.setMessage(helper.readString(buffer));
                helper.readArray(buffer, packet.getParameters(), helper::readString);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported TextType " + (Object)((Object)type));
            }
        }
        packet.setXuid(helper.readString(buffer));
        packet.setPlatformChatId(helper.readString(buffer));
    }

    protected TextSerializer_v291() {
    }
}

