/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.packet;

import com.nukkitx.math.vector.Vector3i;
import com.nukkitx.protocol.bedrock.BedrockPacket;
import com.nukkitx.protocol.bedrock.BedrockPacketType;
import com.nukkitx.protocol.bedrock.data.SubChunkData;
import com.nukkitx.protocol.bedrock.handler.BedrockPacketHandler;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;

public class SubChunkPacket
extends BedrockPacket {
    private int dimension;
    private boolean cacheEnabled;
    private Vector3i centerPosition;
    private List<SubChunkData> subChunks = new ObjectArrayList();

    @Override
    public boolean handle(BedrockPacketHandler handler) {
        return handler.handle(this);
    }

    @Override
    public BedrockPacketType getPacketType() {
        return BedrockPacketType.SUB_CHUNK;
    }

    public int getDimension() {
        return this.dimension;
    }

    public boolean isCacheEnabled() {
        return this.cacheEnabled;
    }

    public Vector3i getCenterPosition() {
        return this.centerPosition;
    }

    public List<SubChunkData> getSubChunks() {
        return this.subChunks;
    }

    public void setDimension(int dimension) {
        this.dimension = dimension;
    }

    public void setCacheEnabled(boolean cacheEnabled) {
        this.cacheEnabled = cacheEnabled;
    }

    public void setCenterPosition(Vector3i centerPosition) {
        this.centerPosition = centerPosition;
    }

    public void setSubChunks(List<SubChunkData> subChunks) {
        this.subChunks = subChunks;
    }

    @Override
    public String toString() {
        return "SubChunkPacket(dimension=" + this.getDimension() + ", cacheEnabled=" + this.isCacheEnabled() + ", centerPosition=" + this.getCenterPosition() + ", subChunks=" + this.getSubChunks() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SubChunkPacket)) {
            return false;
        }
        SubChunkPacket other = (SubChunkPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.dimension != other.dimension) {
            return false;
        }
        if (this.cacheEnabled != other.cacheEnabled) {
            return false;
        }
        Vector3i this$centerPosition = this.centerPosition;
        Vector3i other$centerPosition = other.centerPosition;
        if (this$centerPosition == null ? other$centerPosition != null : !((Object)this$centerPosition).equals(other$centerPosition)) {
            return false;
        }
        List<SubChunkData> this$subChunks = this.subChunks;
        List<SubChunkData> other$subChunks = other.subChunks;
        return !(this$subChunks == null ? other$subChunks != null : !((Object)this$subChunks).equals(other$subChunks));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SubChunkPacket;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.dimension;
        result = result * 59 + (this.cacheEnabled ? 79 : 97);
        Vector3i $centerPosition = this.centerPosition;
        result = result * 59 + ($centerPosition == null ? 43 : ((Object)$centerPosition).hashCode());
        List<SubChunkData> $subChunks = this.subChunks;
        result = result * 59 + ($subChunks == null ? 43 : ((Object)$subChunks).hashCode());
        return result;
    }
}

