/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.packet;

import com.nukkitx.math.vector.Vector2f;
import com.nukkitx.math.vector.Vector3f;
import com.nukkitx.math.vector.Vector3i;
import com.nukkitx.nbt.NbtList;
import com.nukkitx.nbt.NbtMap;
import com.nukkitx.protocol.bedrock.BedrockPacket;
import com.nukkitx.protocol.bedrock.BedrockPacketType;
import com.nukkitx.protocol.bedrock.data.AuthoritativeMovementMode;
import com.nukkitx.protocol.bedrock.data.BlockPropertyData;
import com.nukkitx.protocol.bedrock.data.ChatRestrictionLevel;
import com.nukkitx.protocol.bedrock.data.EduSharedUriResource;
import com.nukkitx.protocol.bedrock.data.ExperimentData;
import com.nukkitx.protocol.bedrock.data.GamePublishSetting;
import com.nukkitx.protocol.bedrock.data.GameRuleData;
import com.nukkitx.protocol.bedrock.data.GameType;
import com.nukkitx.protocol.bedrock.data.PlayerPermission;
import com.nukkitx.protocol.bedrock.data.SpawnBiomeType;
import com.nukkitx.protocol.bedrock.data.SyncedPlayerMovementSettings;
import com.nukkitx.protocol.bedrock.handler.BedrockPacketHandler;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.UUID;

public class StartGamePacket
extends BedrockPacket {
    private static final InternalLogger log = InternalLoggerFactory.getInstance(StartGamePacket.class);
    private final List<GameRuleData<?>> gamerules = new ObjectArrayList();
    private long uniqueEntityId;
    private long runtimeEntityId;
    private GameType playerGameType;
    private Vector3f playerPosition;
    private Vector2f rotation;
    private long seed;
    private SpawnBiomeType spawnBiomeType = SpawnBiomeType.DEFAULT;
    private String customBiomeName = "";
    private int dimensionId;
    private int generatorId;
    private GameType levelGameType;
    private int difficulty;
    private Vector3i defaultSpawn;
    private boolean achievementsDisabled;
    private int dayCycleStopTime;
    private int eduEditionOffers;
    private boolean eduFeaturesEnabled;
    private String educationProductionId = "";
    private float rainLevel;
    private float lightningLevel;
    private boolean platformLockedContentConfirmed;
    private boolean multiplayerGame;
    private boolean broadcastingToLan;
    private GamePublishSetting xblBroadcastMode;
    private GamePublishSetting platformBroadcastMode;
    private boolean commandsEnabled;
    private boolean texturePacksRequired;
    private final List<ExperimentData> experiments = new ObjectArrayList();
    private boolean experimentsPreviouslyToggled;
    private boolean bonusChestEnabled;
    private boolean startingWithMap;
    private boolean trustingPlayers;
    private PlayerPermission defaultPlayerPermission;
    private int serverChunkTickRange;
    private boolean behaviorPackLocked;
    private boolean resourcePackLocked;
    private boolean fromLockedWorldTemplate;
    private boolean usingMsaGamertagsOnly;
    private boolean fromWorldTemplate;
    private boolean worldTemplateOptionLocked;
    private boolean onlySpawningV1Villagers;
    private String vanillaVersion;
    private int limitedWorldWidth;
    private int limitedWorldHeight;
    private boolean netherType;
    private EduSharedUriResource eduSharedUriResource = EduSharedUriResource.EMPTY;
    private boolean forceExperimentalGameplay;
    private ChatRestrictionLevel chatRestrictionLevel;
    private boolean disablingPlayerInteractions;
    private boolean disablingPersonas;
    private boolean disablingCustomSkins;
    private String levelId;
    private String levelName;
    private String premiumWorldTemplateId;
    private boolean trial;
    private AuthoritativeMovementMode authoritativeMovementMode;
    private SyncedPlayerMovementSettings playerMovementSettings;
    private long currentTick;
    private int enchantmentSeed;
    private NbtList<NbtMap> blockPalette;
    private final List<BlockPropertyData> blockProperties = new ObjectArrayList();
    private List<ItemEntry> itemEntries = new ObjectArrayList();
    private String multiplayerCorrelationId;
    private boolean inventoriesServerAuthoritative;
    private String serverEngine;
    private long blockRegistryChecksum;
    private Object playerPropertyData;
    private UUID worldTemplateId;
    private boolean worldEditor;
    private boolean clientSideGenerationEnabled;

    @Override
    public final boolean handle(BedrockPacketHandler handler) {
        return handler.handle(this);
    }

    @Override
    public BedrockPacketType getPacketType() {
        return BedrockPacketType.START_GAME;
    }

    @Deprecated
    public void setSeed(int seed) {
        this.seed = seed;
    }

    public void setSeed(long seed) {
        this.seed = seed;
    }

    public List<GameRuleData<?>> getGamerules() {
        return this.gamerules;
    }

    public long getUniqueEntityId() {
        return this.uniqueEntityId;
    }

    public long getRuntimeEntityId() {
        return this.runtimeEntityId;
    }

    public GameType getPlayerGameType() {
        return this.playerGameType;
    }

    public Vector3f getPlayerPosition() {
        return this.playerPosition;
    }

    public Vector2f getRotation() {
        return this.rotation;
    }

    public long getSeed() {
        return this.seed;
    }

    public SpawnBiomeType getSpawnBiomeType() {
        return this.spawnBiomeType;
    }

    public String getCustomBiomeName() {
        return this.customBiomeName;
    }

    public int getDimensionId() {
        return this.dimensionId;
    }

    public int getGeneratorId() {
        return this.generatorId;
    }

    public GameType getLevelGameType() {
        return this.levelGameType;
    }

    public int getDifficulty() {
        return this.difficulty;
    }

    public Vector3i getDefaultSpawn() {
        return this.defaultSpawn;
    }

    public boolean isAchievementsDisabled() {
        return this.achievementsDisabled;
    }

    public int getDayCycleStopTime() {
        return this.dayCycleStopTime;
    }

    public int getEduEditionOffers() {
        return this.eduEditionOffers;
    }

    public boolean isEduFeaturesEnabled() {
        return this.eduFeaturesEnabled;
    }

    public String getEducationProductionId() {
        return this.educationProductionId;
    }

    public float getRainLevel() {
        return this.rainLevel;
    }

    public float getLightningLevel() {
        return this.lightningLevel;
    }

    public boolean isPlatformLockedContentConfirmed() {
        return this.platformLockedContentConfirmed;
    }

    public boolean isMultiplayerGame() {
        return this.multiplayerGame;
    }

    public boolean isBroadcastingToLan() {
        return this.broadcastingToLan;
    }

    public GamePublishSetting getXblBroadcastMode() {
        return this.xblBroadcastMode;
    }

    public GamePublishSetting getPlatformBroadcastMode() {
        return this.platformBroadcastMode;
    }

    public boolean isCommandsEnabled() {
        return this.commandsEnabled;
    }

    public boolean isTexturePacksRequired() {
        return this.texturePacksRequired;
    }

    public List<ExperimentData> getExperiments() {
        return this.experiments;
    }

    public boolean isExperimentsPreviouslyToggled() {
        return this.experimentsPreviouslyToggled;
    }

    public boolean isBonusChestEnabled() {
        return this.bonusChestEnabled;
    }

    public boolean isStartingWithMap() {
        return this.startingWithMap;
    }

    public boolean isTrustingPlayers() {
        return this.trustingPlayers;
    }

    public PlayerPermission getDefaultPlayerPermission() {
        return this.defaultPlayerPermission;
    }

    public int getServerChunkTickRange() {
        return this.serverChunkTickRange;
    }

    public boolean isBehaviorPackLocked() {
        return this.behaviorPackLocked;
    }

    public boolean isResourcePackLocked() {
        return this.resourcePackLocked;
    }

    public boolean isFromLockedWorldTemplate() {
        return this.fromLockedWorldTemplate;
    }

    public boolean isUsingMsaGamertagsOnly() {
        return this.usingMsaGamertagsOnly;
    }

    public boolean isFromWorldTemplate() {
        return this.fromWorldTemplate;
    }

    public boolean isWorldTemplateOptionLocked() {
        return this.worldTemplateOptionLocked;
    }

    public boolean isOnlySpawningV1Villagers() {
        return this.onlySpawningV1Villagers;
    }

    public String getVanillaVersion() {
        return this.vanillaVersion;
    }

    public int getLimitedWorldWidth() {
        return this.limitedWorldWidth;
    }

    public int getLimitedWorldHeight() {
        return this.limitedWorldHeight;
    }

    public boolean isNetherType() {
        return this.netherType;
    }

    public EduSharedUriResource getEduSharedUriResource() {
        return this.eduSharedUriResource;
    }

    public boolean isForceExperimentalGameplay() {
        return this.forceExperimentalGameplay;
    }

    public ChatRestrictionLevel getChatRestrictionLevel() {
        return this.chatRestrictionLevel;
    }

    public boolean isDisablingPlayerInteractions() {
        return this.disablingPlayerInteractions;
    }

    public boolean isDisablingPersonas() {
        return this.disablingPersonas;
    }

    public boolean isDisablingCustomSkins() {
        return this.disablingCustomSkins;
    }

    public String getLevelId() {
        return this.levelId;
    }

    public String getLevelName() {
        return this.levelName;
    }

    public String getPremiumWorldTemplateId() {
        return this.premiumWorldTemplateId;
    }

    public boolean isTrial() {
        return this.trial;
    }

    @Deprecated
    public AuthoritativeMovementMode getAuthoritativeMovementMode() {
        return this.authoritativeMovementMode;
    }

    public SyncedPlayerMovementSettings getPlayerMovementSettings() {
        return this.playerMovementSettings;
    }

    public long getCurrentTick() {
        return this.currentTick;
    }

    public int getEnchantmentSeed() {
        return this.enchantmentSeed;
    }

    public NbtList<NbtMap> getBlockPalette() {
        return this.blockPalette;
    }

    public List<BlockPropertyData> getBlockProperties() {
        return this.blockProperties;
    }

    public List<ItemEntry> getItemEntries() {
        return this.itemEntries;
    }

    public String getMultiplayerCorrelationId() {
        return this.multiplayerCorrelationId;
    }

    public boolean isInventoriesServerAuthoritative() {
        return this.inventoriesServerAuthoritative;
    }

    public String getServerEngine() {
        return this.serverEngine;
    }

    public long getBlockRegistryChecksum() {
        return this.blockRegistryChecksum;
    }

    public Object getPlayerPropertyData() {
        return this.playerPropertyData;
    }

    public UUID getWorldTemplateId() {
        return this.worldTemplateId;
    }

    public boolean isWorldEditor() {
        return this.worldEditor;
    }

    public boolean isClientSideGenerationEnabled() {
        return this.clientSideGenerationEnabled;
    }

    public void setUniqueEntityId(long uniqueEntityId) {
        this.uniqueEntityId = uniqueEntityId;
    }

    public void setRuntimeEntityId(long runtimeEntityId) {
        this.runtimeEntityId = runtimeEntityId;
    }

    public void setPlayerGameType(GameType playerGameType) {
        this.playerGameType = playerGameType;
    }

    public void setPlayerPosition(Vector3f playerPosition) {
        this.playerPosition = playerPosition;
    }

    public void setRotation(Vector2f rotation) {
        this.rotation = rotation;
    }

    public void setSpawnBiomeType(SpawnBiomeType spawnBiomeType) {
        this.spawnBiomeType = spawnBiomeType;
    }

    public void setCustomBiomeName(String customBiomeName) {
        this.customBiomeName = customBiomeName;
    }

    public void setDimensionId(int dimensionId) {
        this.dimensionId = dimensionId;
    }

    public void setGeneratorId(int generatorId) {
        this.generatorId = generatorId;
    }

    public void setLevelGameType(GameType levelGameType) {
        this.levelGameType = levelGameType;
    }

    public void setDifficulty(int difficulty) {
        this.difficulty = difficulty;
    }

    public void setDefaultSpawn(Vector3i defaultSpawn) {
        this.defaultSpawn = defaultSpawn;
    }

    public void setAchievementsDisabled(boolean achievementsDisabled) {
        this.achievementsDisabled = achievementsDisabled;
    }

    public void setDayCycleStopTime(int dayCycleStopTime) {
        this.dayCycleStopTime = dayCycleStopTime;
    }

    public void setEduEditionOffers(int eduEditionOffers) {
        this.eduEditionOffers = eduEditionOffers;
    }

    public void setEduFeaturesEnabled(boolean eduFeaturesEnabled) {
        this.eduFeaturesEnabled = eduFeaturesEnabled;
    }

    public void setEducationProductionId(String educationProductionId) {
        this.educationProductionId = educationProductionId;
    }

    public void setRainLevel(float rainLevel) {
        this.rainLevel = rainLevel;
    }

    public void setLightningLevel(float lightningLevel) {
        this.lightningLevel = lightningLevel;
    }

    public void setPlatformLockedContentConfirmed(boolean platformLockedContentConfirmed) {
        this.platformLockedContentConfirmed = platformLockedContentConfirmed;
    }

    public void setMultiplayerGame(boolean multiplayerGame) {
        this.multiplayerGame = multiplayerGame;
    }

    public void setBroadcastingToLan(boolean broadcastingToLan) {
        this.broadcastingToLan = broadcastingToLan;
    }

    public void setXblBroadcastMode(GamePublishSetting xblBroadcastMode) {
        this.xblBroadcastMode = xblBroadcastMode;
    }

    public void setPlatformBroadcastMode(GamePublishSetting platformBroadcastMode) {
        this.platformBroadcastMode = platformBroadcastMode;
    }

    public void setCommandsEnabled(boolean commandsEnabled) {
        this.commandsEnabled = commandsEnabled;
    }

    public void setTexturePacksRequired(boolean texturePacksRequired) {
        this.texturePacksRequired = texturePacksRequired;
    }

    public void setExperimentsPreviouslyToggled(boolean experimentsPreviouslyToggled) {
        this.experimentsPreviouslyToggled = experimentsPreviouslyToggled;
    }

    public void setBonusChestEnabled(boolean bonusChestEnabled) {
        this.bonusChestEnabled = bonusChestEnabled;
    }

    public void setStartingWithMap(boolean startingWithMap) {
        this.startingWithMap = startingWithMap;
    }

    public void setTrustingPlayers(boolean trustingPlayers) {
        this.trustingPlayers = trustingPlayers;
    }

    public void setDefaultPlayerPermission(PlayerPermission defaultPlayerPermission) {
        this.defaultPlayerPermission = defaultPlayerPermission;
    }

    public void setServerChunkTickRange(int serverChunkTickRange) {
        this.serverChunkTickRange = serverChunkTickRange;
    }

    public void setBehaviorPackLocked(boolean behaviorPackLocked) {
        this.behaviorPackLocked = behaviorPackLocked;
    }

    public void setResourcePackLocked(boolean resourcePackLocked) {
        this.resourcePackLocked = resourcePackLocked;
    }

    public void setFromLockedWorldTemplate(boolean fromLockedWorldTemplate) {
        this.fromLockedWorldTemplate = fromLockedWorldTemplate;
    }

    public void setUsingMsaGamertagsOnly(boolean usingMsaGamertagsOnly) {
        this.usingMsaGamertagsOnly = usingMsaGamertagsOnly;
    }

    public void setFromWorldTemplate(boolean fromWorldTemplate) {
        this.fromWorldTemplate = fromWorldTemplate;
    }

    public void setWorldTemplateOptionLocked(boolean worldTemplateOptionLocked) {
        this.worldTemplateOptionLocked = worldTemplateOptionLocked;
    }

    public void setOnlySpawningV1Villagers(boolean onlySpawningV1Villagers) {
        this.onlySpawningV1Villagers = onlySpawningV1Villagers;
    }

    public void setVanillaVersion(String vanillaVersion) {
        this.vanillaVersion = vanillaVersion;
    }

    public void setLimitedWorldWidth(int limitedWorldWidth) {
        this.limitedWorldWidth = limitedWorldWidth;
    }

    public void setLimitedWorldHeight(int limitedWorldHeight) {
        this.limitedWorldHeight = limitedWorldHeight;
    }

    public void setNetherType(boolean netherType) {
        this.netherType = netherType;
    }

    public void setEduSharedUriResource(EduSharedUriResource eduSharedUriResource) {
        this.eduSharedUriResource = eduSharedUriResource;
    }

    public void setForceExperimentalGameplay(boolean forceExperimentalGameplay) {
        this.forceExperimentalGameplay = forceExperimentalGameplay;
    }

    public void setChatRestrictionLevel(ChatRestrictionLevel chatRestrictionLevel) {
        this.chatRestrictionLevel = chatRestrictionLevel;
    }

    public void setDisablingPlayerInteractions(boolean disablingPlayerInteractions) {
        this.disablingPlayerInteractions = disablingPlayerInteractions;
    }

    public void setDisablingPersonas(boolean disablingPersonas) {
        this.disablingPersonas = disablingPersonas;
    }

    public void setDisablingCustomSkins(boolean disablingCustomSkins) {
        this.disablingCustomSkins = disablingCustomSkins;
    }

    public void setLevelId(String levelId) {
        this.levelId = levelId;
    }

    public void setLevelName(String levelName) {
        this.levelName = levelName;
    }

    public void setPremiumWorldTemplateId(String premiumWorldTemplateId) {
        this.premiumWorldTemplateId = premiumWorldTemplateId;
    }

    public void setTrial(boolean trial) {
        this.trial = trial;
    }

    @Deprecated
    public void setAuthoritativeMovementMode(AuthoritativeMovementMode authoritativeMovementMode) {
        this.authoritativeMovementMode = authoritativeMovementMode;
    }

    public void setPlayerMovementSettings(SyncedPlayerMovementSettings playerMovementSettings) {
        this.playerMovementSettings = playerMovementSettings;
    }

    public void setCurrentTick(long currentTick) {
        this.currentTick = currentTick;
    }

    public void setEnchantmentSeed(int enchantmentSeed) {
        this.enchantmentSeed = enchantmentSeed;
    }

    public void setBlockPalette(NbtList<NbtMap> blockPalette) {
        this.blockPalette = blockPalette;
    }

    public void setItemEntries(List<ItemEntry> itemEntries) {
        this.itemEntries = itemEntries;
    }

    public void setMultiplayerCorrelationId(String multiplayerCorrelationId) {
        this.multiplayerCorrelationId = multiplayerCorrelationId;
    }

    public void setInventoriesServerAuthoritative(boolean inventoriesServerAuthoritative) {
        this.inventoriesServerAuthoritative = inventoriesServerAuthoritative;
    }

    public void setServerEngine(String serverEngine) {
        this.serverEngine = serverEngine;
    }

    public void setBlockRegistryChecksum(long blockRegistryChecksum) {
        this.blockRegistryChecksum = blockRegistryChecksum;
    }

    public void setPlayerPropertyData(Object playerPropertyData) {
        this.playerPropertyData = playerPropertyData;
    }

    public void setWorldTemplateId(UUID worldTemplateId) {
        this.worldTemplateId = worldTemplateId;
    }

    public void setWorldEditor(boolean worldEditor) {
        this.worldEditor = worldEditor;
    }

    public void setClientSideGenerationEnabled(boolean clientSideGenerationEnabled) {
        this.clientSideGenerationEnabled = clientSideGenerationEnabled;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StartGamePacket)) {
            return false;
        }
        StartGamePacket other = (StartGamePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<GameRuleData<?>> this$gamerules = this.gamerules;
        List<GameRuleData<?>> other$gamerules = other.gamerules;
        if (this$gamerules == null ? other$gamerules != null : !((Object)this$gamerules).equals(other$gamerules)) {
            return false;
        }
        if (this.uniqueEntityId != other.uniqueEntityId) {
            return false;
        }
        if (this.runtimeEntityId != other.runtimeEntityId) {
            return false;
        }
        GameType this$playerGameType = this.playerGameType;
        GameType other$playerGameType = other.playerGameType;
        if (this$playerGameType == null ? other$playerGameType != null : !((Object)((Object)this$playerGameType)).equals((Object)other$playerGameType)) {
            return false;
        }
        Vector3f this$playerPosition = this.playerPosition;
        Vector3f other$playerPosition = other.playerPosition;
        if (this$playerPosition == null ? other$playerPosition != null : !((Object)this$playerPosition).equals(other$playerPosition)) {
            return false;
        }
        Vector2f this$rotation = this.rotation;
        Vector2f other$rotation = other.rotation;
        if (this$rotation == null ? other$rotation != null : !((Object)this$rotation).equals(other$rotation)) {
            return false;
        }
        if (this.seed != other.seed) {
            return false;
        }
        SpawnBiomeType this$spawnBiomeType = this.spawnBiomeType;
        SpawnBiomeType other$spawnBiomeType = other.spawnBiomeType;
        if (this$spawnBiomeType == null ? other$spawnBiomeType != null : !((Object)((Object)this$spawnBiomeType)).equals((Object)other$spawnBiomeType)) {
            return false;
        }
        String this$customBiomeName = this.customBiomeName;
        String other$customBiomeName = other.customBiomeName;
        if (this$customBiomeName == null ? other$customBiomeName != null : !this$customBiomeName.equals(other$customBiomeName)) {
            return false;
        }
        if (this.dimensionId != other.dimensionId) {
            return false;
        }
        if (this.generatorId != other.generatorId) {
            return false;
        }
        GameType this$levelGameType = this.levelGameType;
        GameType other$levelGameType = other.levelGameType;
        if (this$levelGameType == null ? other$levelGameType != null : !((Object)((Object)this$levelGameType)).equals((Object)other$levelGameType)) {
            return false;
        }
        if (this.difficulty != other.difficulty) {
            return false;
        }
        Vector3i this$defaultSpawn = this.defaultSpawn;
        Vector3i other$defaultSpawn = other.defaultSpawn;
        if (this$defaultSpawn == null ? other$defaultSpawn != null : !((Object)this$defaultSpawn).equals(other$defaultSpawn)) {
            return false;
        }
        if (this.achievementsDisabled != other.achievementsDisabled) {
            return false;
        }
        if (this.dayCycleStopTime != other.dayCycleStopTime) {
            return false;
        }
        if (this.eduEditionOffers != other.eduEditionOffers) {
            return false;
        }
        if (this.eduFeaturesEnabled != other.eduFeaturesEnabled) {
            return false;
        }
        String this$educationProductionId = this.educationProductionId;
        String other$educationProductionId = other.educationProductionId;
        if (this$educationProductionId == null ? other$educationProductionId != null : !this$educationProductionId.equals(other$educationProductionId)) {
            return false;
        }
        if (Float.compare(this.rainLevel, other.rainLevel) != 0) {
            return false;
        }
        if (Float.compare(this.lightningLevel, other.lightningLevel) != 0) {
            return false;
        }
        if (this.platformLockedContentConfirmed != other.platformLockedContentConfirmed) {
            return false;
        }
        if (this.multiplayerGame != other.multiplayerGame) {
            return false;
        }
        if (this.broadcastingToLan != other.broadcastingToLan) {
            return false;
        }
        GamePublishSetting this$xblBroadcastMode = this.xblBroadcastMode;
        GamePublishSetting other$xblBroadcastMode = other.xblBroadcastMode;
        if (this$xblBroadcastMode == null ? other$xblBroadcastMode != null : !((Object)((Object)this$xblBroadcastMode)).equals((Object)other$xblBroadcastMode)) {
            return false;
        }
        GamePublishSetting this$platformBroadcastMode = this.platformBroadcastMode;
        GamePublishSetting other$platformBroadcastMode = other.platformBroadcastMode;
        if (this$platformBroadcastMode == null ? other$platformBroadcastMode != null : !((Object)((Object)this$platformBroadcastMode)).equals((Object)other$platformBroadcastMode)) {
            return false;
        }
        if (this.commandsEnabled != other.commandsEnabled) {
            return false;
        }
        if (this.texturePacksRequired != other.texturePacksRequired) {
            return false;
        }
        List<ExperimentData> this$experiments = this.experiments;
        List<ExperimentData> other$experiments = other.experiments;
        if (this$experiments == null ? other$experiments != null : !((Object)this$experiments).equals(other$experiments)) {
            return false;
        }
        if (this.experimentsPreviouslyToggled != other.experimentsPreviouslyToggled) {
            return false;
        }
        if (this.bonusChestEnabled != other.bonusChestEnabled) {
            return false;
        }
        if (this.startingWithMap != other.startingWithMap) {
            return false;
        }
        if (this.trustingPlayers != other.trustingPlayers) {
            return false;
        }
        PlayerPermission this$defaultPlayerPermission = this.defaultPlayerPermission;
        PlayerPermission other$defaultPlayerPermission = other.defaultPlayerPermission;
        if (this$defaultPlayerPermission == null ? other$defaultPlayerPermission != null : !((Object)((Object)this$defaultPlayerPermission)).equals((Object)other$defaultPlayerPermission)) {
            return false;
        }
        if (this.serverChunkTickRange != other.serverChunkTickRange) {
            return false;
        }
        if (this.behaviorPackLocked != other.behaviorPackLocked) {
            return false;
        }
        if (this.resourcePackLocked != other.resourcePackLocked) {
            return false;
        }
        if (this.fromLockedWorldTemplate != other.fromLockedWorldTemplate) {
            return false;
        }
        if (this.usingMsaGamertagsOnly != other.usingMsaGamertagsOnly) {
            return false;
        }
        if (this.fromWorldTemplate != other.fromWorldTemplate) {
            return false;
        }
        if (this.worldTemplateOptionLocked != other.worldTemplateOptionLocked) {
            return false;
        }
        if (this.onlySpawningV1Villagers != other.onlySpawningV1Villagers) {
            return false;
        }
        String this$vanillaVersion = this.vanillaVersion;
        String other$vanillaVersion = other.vanillaVersion;
        if (this$vanillaVersion == null ? other$vanillaVersion != null : !this$vanillaVersion.equals(other$vanillaVersion)) {
            return false;
        }
        if (this.limitedWorldWidth != other.limitedWorldWidth) {
            return false;
        }
        if (this.limitedWorldHeight != other.limitedWorldHeight) {
            return false;
        }
        if (this.netherType != other.netherType) {
            return false;
        }
        EduSharedUriResource this$eduSharedUriResource = this.eduSharedUriResource;
        EduSharedUriResource other$eduSharedUriResource = other.eduSharedUriResource;
        if (this$eduSharedUriResource == null ? other$eduSharedUriResource != null : !((Object)this$eduSharedUriResource).equals(other$eduSharedUriResource)) {
            return false;
        }
        if (this.forceExperimentalGameplay != other.forceExperimentalGameplay) {
            return false;
        }
        ChatRestrictionLevel this$chatRestrictionLevel = this.chatRestrictionLevel;
        ChatRestrictionLevel other$chatRestrictionLevel = other.chatRestrictionLevel;
        if (this$chatRestrictionLevel == null ? other$chatRestrictionLevel != null : !((Object)((Object)this$chatRestrictionLevel)).equals((Object)other$chatRestrictionLevel)) {
            return false;
        }
        if (this.disablingPlayerInteractions != other.disablingPlayerInteractions) {
            return false;
        }
        if (this.disablingPersonas != other.disablingPersonas) {
            return false;
        }
        if (this.disablingCustomSkins != other.disablingCustomSkins) {
            return false;
        }
        String this$levelId = this.levelId;
        String other$levelId = other.levelId;
        if (this$levelId == null ? other$levelId != null : !this$levelId.equals(other$levelId)) {
            return false;
        }
        String this$levelName = this.levelName;
        String other$levelName = other.levelName;
        if (this$levelName == null ? other$levelName != null : !this$levelName.equals(other$levelName)) {
            return false;
        }
        String this$premiumWorldTemplateId = this.premiumWorldTemplateId;
        String other$premiumWorldTemplateId = other.premiumWorldTemplateId;
        if (this$premiumWorldTemplateId == null ? other$premiumWorldTemplateId != null : !this$premiumWorldTemplateId.equals(other$premiumWorldTemplateId)) {
            return false;
        }
        if (this.trial != other.trial) {
            return false;
        }
        AuthoritativeMovementMode this$authoritativeMovementMode = this.authoritativeMovementMode;
        AuthoritativeMovementMode other$authoritativeMovementMode = other.authoritativeMovementMode;
        if (this$authoritativeMovementMode == null ? other$authoritativeMovementMode != null : !((Object)((Object)this$authoritativeMovementMode)).equals((Object)other$authoritativeMovementMode)) {
            return false;
        }
        SyncedPlayerMovementSettings this$playerMovementSettings = this.playerMovementSettings;
        SyncedPlayerMovementSettings other$playerMovementSettings = other.playerMovementSettings;
        if (this$playerMovementSettings == null ? other$playerMovementSettings != null : !((Object)this$playerMovementSettings).equals(other$playerMovementSettings)) {
            return false;
        }
        if (this.currentTick != other.currentTick) {
            return false;
        }
        if (this.enchantmentSeed != other.enchantmentSeed) {
            return false;
        }
        NbtList<NbtMap> this$blockPalette = this.blockPalette;
        NbtList<NbtMap> other$blockPalette = other.blockPalette;
        if (this$blockPalette == null ? other$blockPalette != null : !((Object)this$blockPalette).equals(other$blockPalette)) {
            return false;
        }
        List<BlockPropertyData> this$blockProperties = this.blockProperties;
        List<BlockPropertyData> other$blockProperties = other.blockProperties;
        if (this$blockProperties == null ? other$blockProperties != null : !((Object)this$blockProperties).equals(other$blockProperties)) {
            return false;
        }
        List<ItemEntry> this$itemEntries = this.itemEntries;
        List<ItemEntry> other$itemEntries = other.itemEntries;
        if (this$itemEntries == null ? other$itemEntries != null : !((Object)this$itemEntries).equals(other$itemEntries)) {
            return false;
        }
        String this$multiplayerCorrelationId = this.multiplayerCorrelationId;
        String other$multiplayerCorrelationId = other.multiplayerCorrelationId;
        if (this$multiplayerCorrelationId == null ? other$multiplayerCorrelationId != null : !this$multiplayerCorrelationId.equals(other$multiplayerCorrelationId)) {
            return false;
        }
        if (this.inventoriesServerAuthoritative != other.inventoriesServerAuthoritative) {
            return false;
        }
        String this$serverEngine = this.serverEngine;
        String other$serverEngine = other.serverEngine;
        if (this$serverEngine == null ? other$serverEngine != null : !this$serverEngine.equals(other$serverEngine)) {
            return false;
        }
        if (this.blockRegistryChecksum != other.blockRegistryChecksum) {
            return false;
        }
        Object this$playerPropertyData = this.playerPropertyData;
        Object other$playerPropertyData = other.playerPropertyData;
        if (this$playerPropertyData == null ? other$playerPropertyData != null : !this$playerPropertyData.equals(other$playerPropertyData)) {
            return false;
        }
        UUID this$worldTemplateId = this.worldTemplateId;
        UUID other$worldTemplateId = other.worldTemplateId;
        if (this$worldTemplateId == null ? other$worldTemplateId != null : !((Object)this$worldTemplateId).equals(other$worldTemplateId)) {
            return false;
        }
        if (this.worldEditor != other.worldEditor) {
            return false;
        }
        return this.clientSideGenerationEnabled == other.clientSideGenerationEnabled;
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof StartGamePacket;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<GameRuleData<?>> $gamerules = this.gamerules;
        result = result * 59 + ($gamerules == null ? 43 : ((Object)$gamerules).hashCode());
        long $uniqueEntityId = this.uniqueEntityId;
        result = result * 59 + (int)($uniqueEntityId >>> 32 ^ $uniqueEntityId);
        long $runtimeEntityId = this.runtimeEntityId;
        result = result * 59 + (int)($runtimeEntityId >>> 32 ^ $runtimeEntityId);
        GameType $playerGameType = this.playerGameType;
        result = result * 59 + ($playerGameType == null ? 43 : ((Object)((Object)$playerGameType)).hashCode());
        Vector3f $playerPosition = this.playerPosition;
        result = result * 59 + ($playerPosition == null ? 43 : ((Object)$playerPosition).hashCode());
        Vector2f $rotation = this.rotation;
        result = result * 59 + ($rotation == null ? 43 : ((Object)$rotation).hashCode());
        long $seed = this.seed;
        result = result * 59 + (int)($seed >>> 32 ^ $seed);
        SpawnBiomeType $spawnBiomeType = this.spawnBiomeType;
        result = result * 59 + ($spawnBiomeType == null ? 43 : ((Object)((Object)$spawnBiomeType)).hashCode());
        String $customBiomeName = this.customBiomeName;
        result = result * 59 + ($customBiomeName == null ? 43 : $customBiomeName.hashCode());
        result = result * 59 + this.dimensionId;
        result = result * 59 + this.generatorId;
        GameType $levelGameType = this.levelGameType;
        result = result * 59 + ($levelGameType == null ? 43 : ((Object)((Object)$levelGameType)).hashCode());
        result = result * 59 + this.difficulty;
        Vector3i $defaultSpawn = this.defaultSpawn;
        result = result * 59 + ($defaultSpawn == null ? 43 : ((Object)$defaultSpawn).hashCode());
        result = result * 59 + (this.achievementsDisabled ? 79 : 97);
        result = result * 59 + this.dayCycleStopTime;
        result = result * 59 + this.eduEditionOffers;
        result = result * 59 + (this.eduFeaturesEnabled ? 79 : 97);
        String $educationProductionId = this.educationProductionId;
        result = result * 59 + ($educationProductionId == null ? 43 : $educationProductionId.hashCode());
        result = result * 59 + Float.floatToIntBits(this.rainLevel);
        result = result * 59 + Float.floatToIntBits(this.lightningLevel);
        result = result * 59 + (this.platformLockedContentConfirmed ? 79 : 97);
        result = result * 59 + (this.multiplayerGame ? 79 : 97);
        result = result * 59 + (this.broadcastingToLan ? 79 : 97);
        GamePublishSetting $xblBroadcastMode = this.xblBroadcastMode;
        result = result * 59 + ($xblBroadcastMode == null ? 43 : ((Object)((Object)$xblBroadcastMode)).hashCode());
        GamePublishSetting $platformBroadcastMode = this.platformBroadcastMode;
        result = result * 59 + ($platformBroadcastMode == null ? 43 : ((Object)((Object)$platformBroadcastMode)).hashCode());
        result = result * 59 + (this.commandsEnabled ? 79 : 97);
        result = result * 59 + (this.texturePacksRequired ? 79 : 97);
        List<ExperimentData> $experiments = this.experiments;
        result = result * 59 + ($experiments == null ? 43 : ((Object)$experiments).hashCode());
        result = result * 59 + (this.experimentsPreviouslyToggled ? 79 : 97);
        result = result * 59 + (this.bonusChestEnabled ? 79 : 97);
        result = result * 59 + (this.startingWithMap ? 79 : 97);
        result = result * 59 + (this.trustingPlayers ? 79 : 97);
        PlayerPermission $defaultPlayerPermission = this.defaultPlayerPermission;
        result = result * 59 + ($defaultPlayerPermission == null ? 43 : ((Object)((Object)$defaultPlayerPermission)).hashCode());
        result = result * 59 + this.serverChunkTickRange;
        result = result * 59 + (this.behaviorPackLocked ? 79 : 97);
        result = result * 59 + (this.resourcePackLocked ? 79 : 97);
        result = result * 59 + (this.fromLockedWorldTemplate ? 79 : 97);
        result = result * 59 + (this.usingMsaGamertagsOnly ? 79 : 97);
        result = result * 59 + (this.fromWorldTemplate ? 79 : 97);
        result = result * 59 + (this.worldTemplateOptionLocked ? 79 : 97);
        result = result * 59 + (this.onlySpawningV1Villagers ? 79 : 97);
        String $vanillaVersion = this.vanillaVersion;
        result = result * 59 + ($vanillaVersion == null ? 43 : $vanillaVersion.hashCode());
        result = result * 59 + this.limitedWorldWidth;
        result = result * 59 + this.limitedWorldHeight;
        result = result * 59 + (this.netherType ? 79 : 97);
        EduSharedUriResource $eduSharedUriResource = this.eduSharedUriResource;
        result = result * 59 + ($eduSharedUriResource == null ? 43 : ((Object)$eduSharedUriResource).hashCode());
        result = result * 59 + (this.forceExperimentalGameplay ? 79 : 97);
        ChatRestrictionLevel $chatRestrictionLevel = this.chatRestrictionLevel;
        result = result * 59 + ($chatRestrictionLevel == null ? 43 : ((Object)((Object)$chatRestrictionLevel)).hashCode());
        result = result * 59 + (this.disablingPlayerInteractions ? 79 : 97);
        result = result * 59 + (this.disablingPersonas ? 79 : 97);
        result = result * 59 + (this.disablingCustomSkins ? 79 : 97);
        String $levelId = this.levelId;
        result = result * 59 + ($levelId == null ? 43 : $levelId.hashCode());
        String $levelName = this.levelName;
        result = result * 59 + ($levelName == null ? 43 : $levelName.hashCode());
        String $premiumWorldTemplateId = this.premiumWorldTemplateId;
        result = result * 59 + ($premiumWorldTemplateId == null ? 43 : $premiumWorldTemplateId.hashCode());
        result = result * 59 + (this.trial ? 79 : 97);
        AuthoritativeMovementMode $authoritativeMovementMode = this.authoritativeMovementMode;
        result = result * 59 + ($authoritativeMovementMode == null ? 43 : ((Object)((Object)$authoritativeMovementMode)).hashCode());
        SyncedPlayerMovementSettings $playerMovementSettings = this.playerMovementSettings;
        result = result * 59 + ($playerMovementSettings == null ? 43 : ((Object)$playerMovementSettings).hashCode());
        long $currentTick = this.currentTick;
        result = result * 59 + (int)($currentTick >>> 32 ^ $currentTick);
        result = result * 59 + this.enchantmentSeed;
        NbtList<NbtMap> $blockPalette = this.blockPalette;
        result = result * 59 + ($blockPalette == null ? 43 : ((Object)$blockPalette).hashCode());
        List<BlockPropertyData> $blockProperties = this.blockProperties;
        result = result * 59 + ($blockProperties == null ? 43 : ((Object)$blockProperties).hashCode());
        List<ItemEntry> $itemEntries = this.itemEntries;
        result = result * 59 + ($itemEntries == null ? 43 : ((Object)$itemEntries).hashCode());
        String $multiplayerCorrelationId = this.multiplayerCorrelationId;
        result = result * 59 + ($multiplayerCorrelationId == null ? 43 : $multiplayerCorrelationId.hashCode());
        result = result * 59 + (this.inventoriesServerAuthoritative ? 79 : 97);
        String $serverEngine = this.serverEngine;
        result = result * 59 + ($serverEngine == null ? 43 : $serverEngine.hashCode());
        long $blockRegistryChecksum = this.blockRegistryChecksum;
        result = result * 59 + (int)($blockRegistryChecksum >>> 32 ^ $blockRegistryChecksum);
        Object $playerPropertyData = this.playerPropertyData;
        result = result * 59 + ($playerPropertyData == null ? 43 : $playerPropertyData.hashCode());
        UUID $worldTemplateId = this.worldTemplateId;
        result = result * 59 + ($worldTemplateId == null ? 43 : ((Object)$worldTemplateId).hashCode());
        result = result * 59 + (this.worldEditor ? 79 : 97);
        result = result * 59 + (this.clientSideGenerationEnabled ? 79 : 97);
        return result;
    }

    @Override
    public String toString() {
        return "StartGamePacket(gamerules=" + this.getGamerules() + ", uniqueEntityId=" + this.getUniqueEntityId() + ", runtimeEntityId=" + this.getRuntimeEntityId() + ", playerGameType=" + (Object)((Object)this.getPlayerGameType()) + ", playerPosition=" + this.getPlayerPosition() + ", rotation=" + this.getRotation() + ", seed=" + this.getSeed() + ", spawnBiomeType=" + (Object)((Object)this.getSpawnBiomeType()) + ", customBiomeName=" + this.getCustomBiomeName() + ", dimensionId=" + this.getDimensionId() + ", generatorId=" + this.getGeneratorId() + ", levelGameType=" + (Object)((Object)this.getLevelGameType()) + ", difficulty=" + this.getDifficulty() + ", defaultSpawn=" + this.getDefaultSpawn() + ", achievementsDisabled=" + this.isAchievementsDisabled() + ", dayCycleStopTime=" + this.getDayCycleStopTime() + ", eduEditionOffers=" + this.getEduEditionOffers() + ", eduFeaturesEnabled=" + this.isEduFeaturesEnabled() + ", educationProductionId=" + this.getEducationProductionId() + ", rainLevel=" + this.getRainLevel() + ", lightningLevel=" + this.getLightningLevel() + ", platformLockedContentConfirmed=" + this.isPlatformLockedContentConfirmed() + ", multiplayerGame=" + this.isMultiplayerGame() + ", broadcastingToLan=" + this.isBroadcastingToLan() + ", xblBroadcastMode=" + (Object)((Object)this.getXblBroadcastMode()) + ", platformBroadcastMode=" + (Object)((Object)this.getPlatformBroadcastMode()) + ", commandsEnabled=" + this.isCommandsEnabled() + ", texturePacksRequired=" + this.isTexturePacksRequired() + ", experiments=" + this.getExperiments() + ", experimentsPreviouslyToggled=" + this.isExperimentsPreviouslyToggled() + ", bonusChestEnabled=" + this.isBonusChestEnabled() + ", startingWithMap=" + this.isStartingWithMap() + ", trustingPlayers=" + this.isTrustingPlayers() + ", defaultPlayerPermission=" + (Object)((Object)this.getDefaultPlayerPermission()) + ", serverChunkTickRange=" + this.getServerChunkTickRange() + ", behaviorPackLocked=" + this.isBehaviorPackLocked() + ", resourcePackLocked=" + this.isResourcePackLocked() + ", fromLockedWorldTemplate=" + this.isFromLockedWorldTemplate() + ", usingMsaGamertagsOnly=" + this.isUsingMsaGamertagsOnly() + ", fromWorldTemplate=" + this.isFromWorldTemplate() + ", worldTemplateOptionLocked=" + this.isWorldTemplateOptionLocked() + ", onlySpawningV1Villagers=" + this.isOnlySpawningV1Villagers() + ", vanillaVersion=" + this.getVanillaVersion() + ", limitedWorldWidth=" + this.getLimitedWorldWidth() + ", limitedWorldHeight=" + this.getLimitedWorldHeight() + ", netherType=" + this.isNetherType() + ", eduSharedUriResource=" + this.getEduSharedUriResource() + ", forceExperimentalGameplay=" + this.isForceExperimentalGameplay() + ", chatRestrictionLevel=" + (Object)((Object)this.getChatRestrictionLevel()) + ", disablingPlayerInteractions=" + this.isDisablingPlayerInteractions() + ", disablingPersonas=" + this.isDisablingPersonas() + ", disablingCustomSkins=" + this.isDisablingCustomSkins() + ", levelId=" + this.getLevelId() + ", levelName=" + this.getLevelName() + ", premiumWorldTemplateId=" + this.getPremiumWorldTemplateId() + ", trial=" + this.isTrial() + ", authoritativeMovementMode=" + (Object)((Object)this.getAuthoritativeMovementMode()) + ", playerMovementSettings=" + this.getPlayerMovementSettings() + ", currentTick=" + this.getCurrentTick() + ", enchantmentSeed=" + this.getEnchantmentSeed() + ", blockProperties=" + this.getBlockProperties() + ", multiplayerCorrelationId=" + this.getMultiplayerCorrelationId() + ", inventoriesServerAuthoritative=" + this.isInventoriesServerAuthoritative() + ", serverEngine=" + this.getServerEngine() + ", blockRegistryChecksum=" + this.getBlockRegistryChecksum() + ", playerPropertyData=" + this.getPlayerPropertyData() + ", worldTemplateId=" + this.getWorldTemplateId() + ", worldEditor=" + this.isWorldEditor() + ", clientSideGenerationEnabled=" + this.isClientSideGenerationEnabled() + ")";
    }

    public static final class ItemEntry {
        private final String identifier;
        private final short id;
        private final boolean componentBased;

        public ItemEntry(String identifier, short id) {
            this.identifier = identifier;
            this.id = id;
            this.componentBased = false;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public short getId() {
            return this.id;
        }

        public boolean isComponentBased() {
            return this.componentBased;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ItemEntry)) {
                return false;
            }
            ItemEntry other = (ItemEntry)o;
            String this$identifier = this.getIdentifier();
            String other$identifier = other.getIdentifier();
            if (this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier)) {
                return false;
            }
            if (this.getId() != other.getId()) {
                return false;
            }
            return this.isComponentBased() == other.isComponentBased();
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $identifier = this.getIdentifier();
            result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
            result = result * 59 + this.getId();
            result = result * 59 + (this.isComponentBased() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "StartGamePacket.ItemEntry(identifier=" + this.getIdentifier() + ", id=" + this.getId() + ", componentBased=" + this.isComponentBased() + ")";
        }

        public ItemEntry(String identifier, short id, boolean componentBased) {
            this.identifier = identifier;
            this.id = id;
            this.componentBased = componentBased;
        }
    }
}

