/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.packet;

import com.nukkitx.protocol.bedrock.BedrockPacket;
import com.nukkitx.protocol.bedrock.BedrockPacketType;
import com.nukkitx.protocol.bedrock.handler.BedrockPacketHandler;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import java.util.Arrays;

public class LevelChunkPacket
extends BedrockPacket {
    private int chunkX;
    private int chunkZ;
    private int subChunksLength;
    private boolean cachingEnabled;
    private boolean requestSubChunks;
    private int subChunkLimit;
    private final LongList blobIds = new LongArrayList();
    private byte[] data;

    @Override
    public final boolean handle(BedrockPacketHandler handler) {
        return handler.handle(this);
    }

    @Override
    public BedrockPacketType getPacketType() {
        return BedrockPacketType.LEVEL_CHUNK;
    }

    public int getChunkX() {
        return this.chunkX;
    }

    public int getChunkZ() {
        return this.chunkZ;
    }

    public int getSubChunksLength() {
        return this.subChunksLength;
    }

    public boolean isCachingEnabled() {
        return this.cachingEnabled;
    }

    public boolean isRequestSubChunks() {
        return this.requestSubChunks;
    }

    public int getSubChunkLimit() {
        return this.subChunkLimit;
    }

    public LongList getBlobIds() {
        return this.blobIds;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setChunkX(int chunkX) {
        this.chunkX = chunkX;
    }

    public void setChunkZ(int chunkZ) {
        this.chunkZ = chunkZ;
    }

    public void setSubChunksLength(int subChunksLength) {
        this.subChunksLength = subChunksLength;
    }

    public void setCachingEnabled(boolean cachingEnabled) {
        this.cachingEnabled = cachingEnabled;
    }

    public void setRequestSubChunks(boolean requestSubChunks) {
        this.requestSubChunks = requestSubChunks;
    }

    public void setSubChunkLimit(int subChunkLimit) {
        this.subChunkLimit = subChunkLimit;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    @Override
    public String toString() {
        return "LevelChunkPacket(chunkX=" + this.chunkX + ", chunkZ=" + this.chunkZ + ", subChunksLength=" + this.subChunksLength + ", cachingEnabled=" + this.cachingEnabled + ", requestSubChunks=" + this.requestSubChunks + ", subChunkLimit=" + this.subChunkLimit + ", blobIds=" + this.blobIds + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LevelChunkPacket)) {
            return false;
        }
        LevelChunkPacket other = (LevelChunkPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.chunkX != other.chunkX) {
            return false;
        }
        if (this.chunkZ != other.chunkZ) {
            return false;
        }
        if (this.subChunksLength != other.subChunksLength) {
            return false;
        }
        if (this.cachingEnabled != other.cachingEnabled) {
            return false;
        }
        if (this.requestSubChunks != other.requestSubChunks) {
            return false;
        }
        if (this.subChunkLimit != other.subChunkLimit) {
            return false;
        }
        LongList this$blobIds = this.blobIds;
        LongList other$blobIds = other.blobIds;
        if (this$blobIds == null ? other$blobIds != null : !this$blobIds.equals(other$blobIds)) {
            return false;
        }
        return Arrays.equals(this.data, other.data);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof LevelChunkPacket;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.chunkX;
        result = result * 59 + this.chunkZ;
        result = result * 59 + this.subChunksLength;
        result = result * 59 + (this.cachingEnabled ? 79 : 97);
        result = result * 59 + (this.requestSubChunks ? 79 : 97);
        result = result * 59 + this.subChunkLimit;
        LongList $blobIds = this.blobIds;
        result = result * 59 + ($blobIds == null ? 43 : $blobIds.hashCode());
        result = result * 59 + Arrays.hashCode(this.data);
        return result;
    }
}

