/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.data.structure;

import com.nukkitx.math.vector.Vector3f;
import com.nukkitx.math.vector.Vector3i;
import com.nukkitx.protocol.bedrock.data.structure.StructureAnimationMode;
import com.nukkitx.protocol.bedrock.data.structure.StructureMirror;
import com.nukkitx.protocol.bedrock.data.structure.StructureRotation;

public final class StructureSettings {
    private final String paletteName;
    private final boolean ignoringEntities;
    private final boolean ignoringBlocks;
    private final boolean nonTickingPlayersAndTickingAreasEnabled;
    private final Vector3i size;
    private final Vector3i offset;
    private final long lastEditedByEntityId;
    private final StructureRotation rotation;
    private final StructureMirror mirror;
    private final StructureAnimationMode animationMode;
    private final float animationSeconds;
    private final float integrityValue;
    private final int integritySeed;
    private final Vector3f pivot;

    public String getPaletteName() {
        return this.paletteName;
    }

    public boolean isIgnoringEntities() {
        return this.ignoringEntities;
    }

    public boolean isIgnoringBlocks() {
        return this.ignoringBlocks;
    }

    public boolean isNonTickingPlayersAndTickingAreasEnabled() {
        return this.nonTickingPlayersAndTickingAreasEnabled;
    }

    public Vector3i getSize() {
        return this.size;
    }

    public Vector3i getOffset() {
        return this.offset;
    }

    public long getLastEditedByEntityId() {
        return this.lastEditedByEntityId;
    }

    public StructureRotation getRotation() {
        return this.rotation;
    }

    public StructureMirror getMirror() {
        return this.mirror;
    }

    public StructureAnimationMode getAnimationMode() {
        return this.animationMode;
    }

    public float getAnimationSeconds() {
        return this.animationSeconds;
    }

    public float getIntegrityValue() {
        return this.integrityValue;
    }

    public int getIntegritySeed() {
        return this.integritySeed;
    }

    public Vector3f getPivot() {
        return this.pivot;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StructureSettings)) {
            return false;
        }
        StructureSettings other = (StructureSettings)o;
        String this$paletteName = this.getPaletteName();
        String other$paletteName = other.getPaletteName();
        if (this$paletteName == null ? other$paletteName != null : !this$paletteName.equals(other$paletteName)) {
            return false;
        }
        if (this.isIgnoringEntities() != other.isIgnoringEntities()) {
            return false;
        }
        if (this.isIgnoringBlocks() != other.isIgnoringBlocks()) {
            return false;
        }
        if (this.isNonTickingPlayersAndTickingAreasEnabled() != other.isNonTickingPlayersAndTickingAreasEnabled()) {
            return false;
        }
        Vector3i this$size = this.getSize();
        Vector3i other$size = other.getSize();
        if (this$size == null ? other$size != null : !((Object)this$size).equals(other$size)) {
            return false;
        }
        Vector3i this$offset = this.getOffset();
        Vector3i other$offset = other.getOffset();
        if (this$offset == null ? other$offset != null : !((Object)this$offset).equals(other$offset)) {
            return false;
        }
        if (this.getLastEditedByEntityId() != other.getLastEditedByEntityId()) {
            return false;
        }
        StructureRotation this$rotation = this.getRotation();
        StructureRotation other$rotation = other.getRotation();
        if (this$rotation == null ? other$rotation != null : !((Object)((Object)this$rotation)).equals((Object)other$rotation)) {
            return false;
        }
        StructureMirror this$mirror = this.getMirror();
        StructureMirror other$mirror = other.getMirror();
        if (this$mirror == null ? other$mirror != null : !((Object)((Object)this$mirror)).equals((Object)other$mirror)) {
            return false;
        }
        StructureAnimationMode this$animationMode = this.getAnimationMode();
        StructureAnimationMode other$animationMode = other.getAnimationMode();
        if (this$animationMode == null ? other$animationMode != null : !((Object)((Object)this$animationMode)).equals((Object)other$animationMode)) {
            return false;
        }
        if (Float.compare(this.getAnimationSeconds(), other.getAnimationSeconds()) != 0) {
            return false;
        }
        if (Float.compare(this.getIntegrityValue(), other.getIntegrityValue()) != 0) {
            return false;
        }
        if (this.getIntegritySeed() != other.getIntegritySeed()) {
            return false;
        }
        Vector3f this$pivot = this.getPivot();
        Vector3f other$pivot = other.getPivot();
        return !(this$pivot == null ? other$pivot != null : !((Object)this$pivot).equals(other$pivot));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $paletteName = this.getPaletteName();
        result = result * 59 + ($paletteName == null ? 43 : $paletteName.hashCode());
        result = result * 59 + (this.isIgnoringEntities() ? 79 : 97);
        result = result * 59 + (this.isIgnoringBlocks() ? 79 : 97);
        result = result * 59 + (this.isNonTickingPlayersAndTickingAreasEnabled() ? 79 : 97);
        Vector3i $size = this.getSize();
        result = result * 59 + ($size == null ? 43 : ((Object)$size).hashCode());
        Vector3i $offset = this.getOffset();
        result = result * 59 + ($offset == null ? 43 : ((Object)$offset).hashCode());
        long $lastEditedByEntityId = this.getLastEditedByEntityId();
        result = result * 59 + (int)($lastEditedByEntityId >>> 32 ^ $lastEditedByEntityId);
        StructureRotation $rotation = this.getRotation();
        result = result * 59 + ($rotation == null ? 43 : ((Object)((Object)$rotation)).hashCode());
        StructureMirror $mirror = this.getMirror();
        result = result * 59 + ($mirror == null ? 43 : ((Object)((Object)$mirror)).hashCode());
        StructureAnimationMode $animationMode = this.getAnimationMode();
        result = result * 59 + ($animationMode == null ? 43 : ((Object)((Object)$animationMode)).hashCode());
        result = result * 59 + Float.floatToIntBits(this.getAnimationSeconds());
        result = result * 59 + Float.floatToIntBits(this.getIntegrityValue());
        result = result * 59 + this.getIntegritySeed();
        Vector3f $pivot = this.getPivot();
        result = result * 59 + ($pivot == null ? 43 : ((Object)$pivot).hashCode());
        return result;
    }

    public String toString() {
        return "StructureSettings(paletteName=" + this.getPaletteName() + ", ignoringEntities=" + this.isIgnoringEntities() + ", ignoringBlocks=" + this.isIgnoringBlocks() + ", nonTickingPlayersAndTickingAreasEnabled=" + this.isNonTickingPlayersAndTickingAreasEnabled() + ", size=" + this.getSize() + ", offset=" + this.getOffset() + ", lastEditedByEntityId=" + this.getLastEditedByEntityId() + ", rotation=" + (Object)((Object)this.getRotation()) + ", mirror=" + (Object)((Object)this.getMirror()) + ", animationMode=" + (Object)((Object)this.getAnimationMode()) + ", animationSeconds=" + this.getAnimationSeconds() + ", integrityValue=" + this.getIntegrityValue() + ", integritySeed=" + this.getIntegritySeed() + ", pivot=" + this.getPivot() + ")";
    }

    public StructureSettings(String paletteName, boolean ignoringEntities, boolean ignoringBlocks, boolean nonTickingPlayersAndTickingAreasEnabled, Vector3i size, Vector3i offset, long lastEditedByEntityId, StructureRotation rotation, StructureMirror mirror, StructureAnimationMode animationMode, float animationSeconds, float integrityValue, int integritySeed, Vector3f pivot) {
        this.paletteName = paletteName;
        this.ignoringEntities = ignoringEntities;
        this.ignoringBlocks = ignoringBlocks;
        this.nonTickingPlayersAndTickingAreasEnabled = nonTickingPlayersAndTickingAreasEnabled;
        this.size = size;
        this.offset = offset;
        this.lastEditedByEntityId = lastEditedByEntityId;
        this.rotation = rotation;
        this.mirror = mirror;
        this.animationMode = animationMode;
        this.animationSeconds = animationSeconds;
        this.integrityValue = integrityValue;
        this.integritySeed = integritySeed;
        this.pivot = pivot;
    }
}

