/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.data.inventory;

import com.nukkitx.nbt.NbtMap;
import com.nukkitx.network.util.Preconditions;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class ItemData {
    private static final String[] EMPTY = new String[0];
    public static final ItemData AIR = new ItemData(0, 0, 0, null, EMPTY, EMPTY, 0L, 0, false, 0);
    private int id;
    private final int damage;
    private final int count;
    private final NbtMap tag;
    private final String[] canPlace;
    private final String[] canBreak;
    private final long blockingTicks;
    private final int blockRuntimeId;
    private boolean usingNetId;
    private int netId;

    private ItemData(int id, int damage, int count, NbtMap tag, String[] canPlace, String[] canBreak, long blockingTicks, int blockRuntimeId, boolean hasNetId, int netId) {
        Preconditions.checkArgument(count < 256, "count exceeds maximum of 255");
        this.id = id;
        this.damage = damage;
        this.count = count;
        this.tag = tag;
        this.canPlace = canPlace == null ? EMPTY : canPlace;
        this.canBreak = canBreak == null ? EMPTY : canBreak;
        this.blockingTicks = blockingTicks;
        this.blockRuntimeId = blockRuntimeId;
        this.netId = netId;
        this.usingNetId = hasNetId;
    }

    public boolean isValid() {
        return !this.isNull() && this.id != 0;
    }

    public boolean isNull() {
        return this.count <= 0;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.damage, this.count, this.tag, Arrays.hashCode(this.canPlace), Arrays.hashCode(this.canBreak), this.blockingTicks, this.blockRuntimeId);
    }

    public boolean equals(ItemData other, boolean checkAmount, boolean checkMetadata, boolean checkUserdata) {
        return this.id == other.id && (!checkAmount || this.count == other.count) && (!checkMetadata || this.damage == other.damage && this.blockRuntimeId == other.blockRuntimeId) && (!checkUserdata || Objects.equals(this.tag, other.tag) && Arrays.equals(this.canPlace, other.canPlace) && Arrays.equals(this.canBreak, other.canBreak));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ItemData)) {
            return false;
        }
        return this.equals((ItemData)obj, true, true, true);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().id(this.id).damage(this.damage).count(this.count).tag(this.tag).canPlace(this.canPlace).canBreak(this.canBreak).blockingTicks(this.blockingTicks).blockRuntimeId(this.blockRuntimeId).usingNetId(this.usingNetId).netId(this.netId);
    }

    public int getId() {
        return this.id;
    }

    public int getDamage() {
        return this.damage;
    }

    public int getCount() {
        return this.count;
    }

    public NbtMap getTag() {
        return this.tag;
    }

    public String[] getCanPlace() {
        return this.canPlace;
    }

    public String[] getCanBreak() {
        return this.canBreak;
    }

    public long getBlockingTicks() {
        return this.blockingTicks;
    }

    public int getBlockRuntimeId() {
        return this.blockRuntimeId;
    }

    public boolean isUsingNetId() {
        return this.usingNetId;
    }

    public int getNetId() {
        return this.netId;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setUsingNetId(boolean usingNetId) {
        this.usingNetId = usingNetId;
    }

    public void setNetId(int netId) {
        this.netId = netId;
    }

    public String toString() {
        return "ItemData(id=" + this.getId() + ", damage=" + this.getDamage() + ", count=" + this.getCount() + ", tag=" + this.getTag() + ", canPlace=" + Arrays.deepToString(this.getCanPlace()) + ", canBreak=" + Arrays.deepToString(this.getCanBreak()) + ", blockingTicks=" + this.getBlockingTicks() + ", blockRuntimeId=" + this.getBlockRuntimeId() + ", usingNetId=" + this.isUsingNetId() + ", netId=" + this.getNetId() + ")";
    }

    public static class Builder {
        private int id;
        private int damage;
        private int count;
        private NbtMap tag;
        private String[] canPlace;
        private String[] canBreak;
        private long blockingTicks;
        private int blockRuntimeId;
        private boolean usingNetId;
        private int netId;

        Builder() {
        }

        public Builder id(int id) {
            this.id = id;
            return this;
        }

        public Builder damage(int damage) {
            this.damage = damage;
            return this;
        }

        public Builder count(int count) {
            this.count = count;
            return this;
        }

        public Builder tag(NbtMap tag) {
            this.tag = tag;
            return this;
        }

        public Builder canPlace(String[] canPlace) {
            this.canPlace = canPlace;
            return this;
        }

        public Builder canBreak(String[] canBreak) {
            this.canBreak = canBreak;
            return this;
        }

        public Builder blockingTicks(long blockingTicks) {
            this.blockingTicks = blockingTicks;
            return this;
        }

        public Builder blockRuntimeId(int blockRuntimeId) {
            this.blockRuntimeId = blockRuntimeId;
            return this;
        }

        public Builder usingNetId(boolean usingNetId) {
            this.usingNetId = usingNetId;
            return this;
        }

        public Builder netId(int netId) {
            this.netId = netId;
            return this;
        }

        public ItemData build() {
            return new ItemData(this.id, this.damage, this.count, this.tag, this.canPlace, this.canBreak, this.blockingTicks, this.blockRuntimeId, this.usingNetId, this.netId);
        }

        public String toString() {
            return "ItemData.Builder(id=" + this.id + ", damage=" + this.damage + ", count=" + this.count + ", tag=" + this.tag + ", canPlace=" + Arrays.deepToString(this.canPlace) + ", canBreak=" + Arrays.deepToString(this.canBreak) + ", blockingTicks=" + this.blockingTicks + ", blockRuntimeId=" + this.blockRuntimeId + ", usingNetId=" + this.usingNetId + ", netId=" + this.netId + ")";
        }
    }
}

