/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.data.entity;

import com.nukkitx.math.vector.Vector3f;
import com.nukkitx.math.vector.Vector3i;
import com.nukkitx.nbt.NbtMap;
import com.nukkitx.network.util.Preconditions;
import com.nukkitx.protocol.bedrock.data.entity.EntityData;
import com.nukkitx.protocol.bedrock.data.entity.EntityFlags;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class EntityDataMap
implements Map<EntityData, Object> {
    private final Map<EntityData, Object> map = new LinkedHashMap<EntityData, Object>();

    public byte getByte(EntityData key) {
        return this.getByte(key, (byte)0);
    }

    public byte getByte(EntityData key, byte defaultValue) {
        return this.getOrDefault(key, defaultValue);
    }

    public EntityDataMap putByte(EntityData key, int value) {
        this.put(key, (Object)((byte)value));
        return this;
    }

    public short getShort(EntityData key) {
        return this.getShort(key, (short)0);
    }

    public short getShort(EntityData key, short defaultValue) {
        return this.getOrDefault(key, defaultValue);
    }

    public EntityDataMap putShort(EntityData key, int value) {
        this.put(key, (Object)((short)value));
        return this;
    }

    public int getInt(EntityData key) {
        return this.getInt(key, 0);
    }

    public int getInt(EntityData key, int defaultValue) {
        return this.getOrDefault(key, defaultValue);
    }

    public EntityDataMap putInt(EntityData key, int value) {
        this.put(key, (Object)value);
        return this;
    }

    public float getFloat(EntityData key) {
        return this.getFloat(key, 0.0f);
    }

    public float getFloat(EntityData key, float defaultValue) {
        return this.getOrDefault(key, Float.valueOf(defaultValue)).floatValue();
    }

    public EntityDataMap putFloat(EntityData key, float value) {
        this.put(key, (Object)Float.valueOf(value));
        return this;
    }

    public String getString(EntityData key) {
        return this.getString(key, "");
    }

    public String getString(EntityData key, String defaultValue) {
        return this.getOrDefault(key, defaultValue);
    }

    public EntityDataMap putString(EntityData key, String value) {
        this.put(key, (Object)value);
        return this;
    }

    public NbtMap getTag(EntityData key) {
        return this.getTag(key, NbtMap.EMPTY);
    }

    public NbtMap getTag(EntityData key, NbtMap defaultValue) {
        return this.getOrDefault(key, defaultValue);
    }

    public EntityDataMap putTag(EntityData key, NbtMap value) {
        this.put(key, (Object)value);
        return this;
    }

    public Vector3i getPos(EntityData key) {
        return this.getPos(key, Vector3i.ZERO);
    }

    public Vector3i getPos(EntityData key, Vector3i defaultValue) {
        return this.getOrDefault(key, defaultValue);
    }

    public EntityDataMap putPos(EntityData key, Vector3i value) {
        this.put(key, (Object)value);
        return this;
    }

    public long getLong(EntityData key) {
        return this.getLong(key, 0L);
    }

    public long getLong(EntityData key, long defaultValue) {
        return this.getOrDefault(key, defaultValue);
    }

    public EntityDataMap putLong(EntityData key, long value) {
        this.put(key, (Object)value);
        return this;
    }

    public Vector3f getVector3f(EntityData key) {
        return this.getVector3f(key, Vector3f.ZERO);
    }

    public Vector3f getVector3f(EntityData key, Vector3f defaultValue) {
        return this.getOrDefault(key, defaultValue);
    }

    public EntityDataMap putVector3f(EntityData key, Vector3f value) {
        this.put(key, (Object)value);
        return this;
    }

    @Nonnull
    public EntityFlags getOrCreateFlags() {
        EntityFlags flags = this.getFlags();
        if (flags == null) {
            flags = new EntityFlags();
            this.putFlags(flags);
        }
        return flags;
    }

    public EntityFlags getFlags() {
        return (EntityFlags)this.map.get((Object)EntityData.FLAGS);
    }

    public EntityDataMap putFlags(EntityFlags flags) {
        Objects.requireNonNull(flags, "flags");
        this.map.put(EntityData.FLAGS, flags);
        this.map.put(EntityData.FLAGS_2, flags);
        return this;
    }

    @Nullable
    public EntityData.Type getType(EntityData key) {
        Object value = this.map.get((Object)key);
        if (value == null) {
            return null;
        }
        return EntityData.Type.from(value);
    }

    @Nullable
    public <T> T ensureAndGet(Object key) {
        return (T)this.map.get(key);
    }

    @Nonnull
    private <T> T getOrDefault(EntityData key, T defaultValue) {
        Objects.requireNonNull(key, "key");
        Object object = this.map.getOrDefault((Object)key, defaultValue);
        try {
            return (T)object;
        }
        catch (ClassCastException e) {
            return defaultValue;
        }
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        return null;
    }

    @Override
    public Object put(EntityData key, Object value) {
        Objects.requireNonNull(key, "type");
        Objects.requireNonNull(value, "value");
        EntityData.Type.from(value);
        if (key == EntityData.FLAGS || key == EntityData.FLAGS_2) {
            return this.putFlags((EntityFlags)value);
        }
        return this.map.put(key, value);
    }

    @Override
    public Object remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public void putAll(@Nonnull Map<? extends EntityData, ?> map) {
        Preconditions.checkNotNull(map, "map");
        this.map.putAll(map);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    @Nonnull
    public Set<EntityData> keySet() {
        return this.map.keySet();
    }

    @Override
    @Nonnull
    public Collection<Object> values() {
        return this.map.values();
    }

    @Override
    @Nonnull
    public Set<Map.Entry<EntityData, Object>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityDataMap that = (EntityDataMap)o;
        return this.map.equals(that.map);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return this.map.toString();
    }

    private static String mapToString(Map<EntityData, Object> map) {
        Iterator<Map.Entry<EntityData, Object>> i = map.entrySet().iterator();
        if (!i.hasNext()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        while (true) {
            Map.Entry<EntityData, Object> e;
            EntityData key;
            if ((key = (e = i.next()).getKey()) == EntityData.FLAGS_2) {
                continue;
            }
            Object value = e.getValue();
            sb.append(key.toString()).append('=').append(value.toString());
            if (!i.hasNext()) {
                return sb.append('}').toString();
            }
            sb.append(',').append(' ');
        }
    }
}

