/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock;

import com.nukkitx.natives.sha256.Sha256;
import com.nukkitx.natives.util.Natives;
import com.nukkitx.network.SessionConnection;
import com.nukkitx.network.util.DisconnectReason;
import com.nukkitx.protocol.MinecraftSession;
import com.nukkitx.protocol.bedrock.BedrockPacket;
import com.nukkitx.protocol.bedrock.BedrockPacketCodec;
import com.nukkitx.protocol.bedrock.annotation.NoEncryption;
import com.nukkitx.protocol.bedrock.compat.BedrockCompat;
import com.nukkitx.protocol.bedrock.exception.PacketSerializeException;
import com.nukkitx.protocol.bedrock.handler.BatchHandler;
import com.nukkitx.protocol.bedrock.handler.BedrockPacketHandler;
import com.nukkitx.protocol.bedrock.handler.DefaultBatchHandler;
import com.nukkitx.protocol.bedrock.util.EncryptionUtils;
import com.nukkitx.protocol.bedrock.wrapper.BedrockWrapperSerializer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.EventLoop;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.security.auth.DestroyFailedException;

public abstract class BedrockSession
implements MinecraftSession<BedrockPacket> {
    private static final InternalLogger log = InternalLoggerFactory.getInstance(BedrockSession.class);
    private static final ThreadLocal<Sha256> HASH_LOCAL = new ThreadLocal<Sha256>(){

        @Override
        protected Sha256 initialValue() {
            return Natives.SHA_256.get();
        }
    };
    private final Set<Consumer<DisconnectReason>> disconnectHandlers = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Queue<BedrockPacket> queuedPackets = PlatformDependent.newMpscQueue();
    private final AtomicLong sentEncryptedPacketCount = new AtomicLong();
    private final BedrockWrapperSerializer wrapperSerializer;
    private final EventLoop eventLoop;
    final SessionConnection<ByteBuf> connection;
    private BedrockPacketCodec packetCodec = BedrockCompat.COMPAT_CODEC;
    private BedrockPacketHandler packetHandler;
    private BatchHandler batchHandler = DefaultBatchHandler.INSTANCE;
    private Cipher encryptionCipher = null;
    private Cipher decryptionCipher = null;
    private SecretKey agreedKey;
    private int compressionLevel = -1;
    private volatile boolean closed = false;
    private volatile boolean logging = true;
    private final AtomicInteger hardcodedBlockingId = new AtomicInteger(-1);

    BedrockSession(SessionConnection<ByteBuf> connection, EventLoop eventLoop, BedrockWrapperSerializer serializer) {
        this.connection = connection;
        this.eventLoop = eventLoop;
        this.wrapperSerializer = serializer;
    }

    public void setPacketHandler(@Nonnull BedrockPacketHandler packetHandler) {
        this.packetHandler = packetHandler;
    }

    public void setPacketCodec(BedrockPacketCodec packetCodec) {
        this.packetCodec = Objects.requireNonNull(packetCodec, "packetCodec");
    }

    void checkForClosed() {
        if (this.closed) {
            throw new IllegalStateException("Connection has been closed");
        }
    }

    @Override
    public void sendPacket(@Nonnull BedrockPacket packet) {
        this.checkPacket(packet);
        this.queuedPackets.add(packet);
    }

    @Override
    public void sendPacketImmediately(@Nonnull BedrockPacket packet) {
        this.checkPacket(packet);
        this.sendWrapped(Collections.singletonList(packet), !packet.getClass().isAnnotationPresent(NoEncryption.class), true);
    }

    private void checkPacket(BedrockPacket packet) {
        this.checkForClosed();
        Objects.requireNonNull(packet, "packet");
        if (log.isTraceEnabled() && this.logging) {
            String to = this.connection.getAddress().toString();
            log.trace("Outbound {}: {}", (Object)to, (Object)packet);
        }
        this.packetCodec.getId(packet);
    }

    public void sendWrapped(Collection<BedrockPacket> packets, boolean encrypt) {
        this.sendWrapped(packets, encrypt, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendWrapped(Collection<BedrockPacket> packets, boolean encrypt, boolean immediate) {
        ByteBuf compressed = ByteBufAllocator.DEFAULT.ioBuffer();
        try {
            this.wrapperSerializer.serialize(compressed, this.packetCodec, packets, this.compressionLevel, this);
            this.sendWrapped(compressed, encrypt, immediate);
        }
        catch (Exception e) {
            log.error("Unable to compress packets", e);
        }
        finally {
            if (compressed != null) {
                compressed.release();
            }
        }
    }

    public void sendWrapped(ByteBuf compressed, boolean encrypt) {
        this.sendWrapped(compressed, encrypt, false);
    }

    public synchronized void sendWrapped(ByteBuf compressed, boolean encrypt, boolean immediate) {
        Objects.requireNonNull(compressed, "compressed");
        try {
            ByteBuf finalPayload = ByteBufAllocator.DEFAULT.ioBuffer(1 + compressed.readableBytes() + 8);
            finalPayload.writeByte(254);
            if (this.encryptionCipher != null && encrypt) {
                ByteBuffer trailer = ByteBuffer.wrap(this.generateTrailer(compressed));
                ByteBuffer outBuffer = finalPayload.internalNioBuffer(1, compressed.readableBytes() + 8);
                ByteBuffer inBuffer = compressed.internalNioBuffer(compressed.readerIndex(), compressed.readableBytes());
                this.encryptionCipher.update(inBuffer, outBuffer);
                this.encryptionCipher.update(trailer, outBuffer);
                finalPayload.writerIndex(finalPayload.writerIndex() + compressed.readableBytes() + 8);
            } else {
                finalPayload.writeBytes(compressed);
            }
            if (immediate) {
                this.connection.sendImmediate(finalPayload);
            } else {
                this.connection.send(finalPayload);
            }
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("Unable to encrypt package", e);
        }
    }

    public void tick() {
        this.eventLoop.execute(this::onTick);
    }

    private void onTick() {
        if (this.closed) {
            return;
        }
        this.sendQueued();
    }

    private void sendQueued() {
        BedrockPacket packet;
        ObjectArrayList toBatch = new ObjectArrayList();
        while ((packet = this.queuedPackets.poll()) != null) {
            if (packet.getClass().isAnnotationPresent(NoEncryption.class)) {
                if (!toBatch.isEmpty()) {
                    this.sendWrapped((Collection<BedrockPacket>)toBatch, true);
                    toBatch = new ObjectArrayList();
                }
                this.sendPacketImmediately(packet);
                continue;
            }
            toBatch.add(packet);
        }
        if (!toBatch.isEmpty()) {
            this.sendWrapped((Collection<BedrockPacket>)toBatch, true);
        }
    }

    public synchronized void enableEncryption(@Nonnull SecretKey secretKey) {
        this.checkForClosed();
        log.debug("Encryption enabled.");
        Objects.requireNonNull(secretKey, "secretKey");
        if (!secretKey.getAlgorithm().equals("AES")) {
            throw new IllegalArgumentException("Invalid key algorithm");
        }
        if (this.encryptionCipher != null || this.decryptionCipher != null) {
            throw new IllegalStateException("Encryption has already been enabled");
        }
        this.agreedKey = secretKey;
        boolean useGcm = this.packetCodec.getProtocolVersion() > 428;
        this.encryptionCipher = EncryptionUtils.createCipher(useGcm, true, secretKey);
        this.decryptionCipher = EncryptionUtils.createCipher(useGcm, false, secretKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] generateTrailer(ByteBuf buf) {
        Sha256 hash = HASH_LOCAL.get();
        ByteBuf counterBuf = ByteBufAllocator.DEFAULT.directBuffer(8);
        try {
            counterBuf.writeLongLE(this.sentEncryptedPacketCount.getAndIncrement());
            ByteBuffer keyBuffer = ByteBuffer.wrap(this.agreedKey.getEncoded());
            hash.update(counterBuf.internalNioBuffer(0, 8));
            hash.update(buf.internalNioBuffer(buf.readerIndex(), buf.readableBytes()));
            hash.update(keyBuffer);
            byte[] digested = hash.digest();
            byte[] byArray = Arrays.copyOf(digested, 8);
            return byArray;
        }
        finally {
            counterBuf.release();
            hash.reset();
        }
    }

    public boolean isEncrypted() {
        return this.encryptionCipher != null;
    }

    @Override
    public abstract void disconnect();

    void close(DisconnectReason reason) {
        this.checkForClosed();
        this.closed = true;
        if (this.agreedKey != null && !this.agreedKey.isDestroyed()) {
            try {
                this.agreedKey.destroy();
            }
            catch (DestroyFailedException destroyFailedException) {
                // empty catch block
            }
        }
        for (Consumer<DisconnectReason> disconnectHandler : this.disconnectHandlers) {
            disconnectHandler.accept(reason);
        }
    }

    public void onWrappedPacket(ByteBuf batched) {
        try {
            if (this.isEncrypted()) {
                ByteBuffer inBuffer = batched.internalNioBuffer(batched.readerIndex(), batched.readableBytes());
                ByteBuffer outBuffer = inBuffer.duplicate();
                this.decryptionCipher.update(inBuffer, outBuffer);
                batched.writerIndex(batched.writerIndex() - 8);
            }
            batched.markReaderIndex();
            if (batched.isReadable()) {
                ObjectArrayList packets = new ObjectArrayList();
                this.wrapperSerializer.deserialize(batched, this.packetCodec, (Collection<BedrockPacket>)packets, this);
                this.batchHandler.handle(this, batched, (Collection<BedrockPacket>)packets);
            }
        }
        catch (GeneralSecurityException packets) {
        }
        catch (PacketSerializeException e) {
            log.warn("Error whilst decoding packets", e);
        }
    }

    @Override
    public InetSocketAddress getAddress() {
        return this.connection.getAddress();
    }

    @Override
    public InetSocketAddress getRealAddress() {
        return this.connection.getRealAddress();
    }

    @Override
    public boolean isClosed() {
        return this.connection.isClosed();
    }

    public BedrockPacketCodec getPacketCodec() {
        return this.packetCodec;
    }

    public BedrockPacketHandler getPacketHandler() {
        return this.packetHandler;
    }

    public BatchHandler getBatchHandler() {
        return this.batchHandler;
    }

    public void setBatchHandler(BatchHandler batchHandler) {
        this.batchHandler = Objects.requireNonNull(batchHandler, "batchHandler");
    }

    public void setCompressionLevel(int compressionLevel) {
        this.compressionLevel = compressionLevel;
    }

    public int getCompressionLevel() {
        return this.compressionLevel;
    }

    public boolean isLogging() {
        return this.logging;
    }

    public void setLogging(boolean logging) {
        this.logging = logging;
    }

    public void addDisconnectHandler(Consumer<DisconnectReason> disconnectHandler) {
        Objects.requireNonNull(disconnectHandler, "disconnectHandler");
        this.disconnectHandlers.add(disconnectHandler);
    }

    public AtomicInteger getHardcodedBlockingId() {
        return this.hardcodedBlockingId;
    }

    @Override
    public long getLatency() {
        return this.connection.getPing();
    }

    public EventLoop getEventLoop() {
        return this.eventLoop;
    }

    public SessionConnection<ByteBuf> getConnection() {
        return this.connection;
    }
}

