/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.nbt;

import com.nukkitx.nbt.NBTInputStream;
import com.nukkitx.nbt.NBTOutputStream;
import com.nukkitx.nbt.util.stream.LittleEndianDataInputStream;
import com.nukkitx.nbt.util.stream.LittleEndianDataOutputStream;
import com.nukkitx.nbt.util.stream.NetworkDataInputStream;
import com.nukkitx.nbt.util.stream.NetworkDataOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class NbtUtils {
    public static final int MAX_DEPTH = 16;
    private static final char[] HEX_CODE = "0123456789ABCDEF".toCharArray();

    private NbtUtils() {
    }

    public static NBTInputStream createReader(InputStream stream, boolean internKeys, boolean internValues) {
        Objects.requireNonNull(stream, "stream");
        return new NBTInputStream(new DataInputStream(stream), internKeys, internValues);
    }

    public static NBTInputStream createReaderLE(InputStream stream, boolean internKeys, boolean internValues) {
        Objects.requireNonNull(stream, "stream");
        return new NBTInputStream(new LittleEndianDataInputStream(stream), internKeys, internValues);
    }

    public static NBTInputStream createGZIPReader(InputStream stream, boolean internKeys, boolean internValues) throws IOException {
        return NbtUtils.createReader(new GZIPInputStream(stream), internKeys, internValues);
    }

    public static NBTInputStream createNetworkReader(InputStream stream, boolean internKeys, boolean internValues) {
        Objects.requireNonNull(stream, "stream");
        return new NBTInputStream(new NetworkDataInputStream(stream), internKeys, internValues);
    }

    public static NBTInputStream createReader(InputStream stream) {
        return NbtUtils.createReader(stream, false, false);
    }

    public static NBTInputStream createReaderLE(InputStream stream) {
        return NbtUtils.createReaderLE(stream, false, false);
    }

    public static NBTInputStream createGZIPReader(InputStream stream) throws IOException {
        return NbtUtils.createGZIPReader(stream, false, false);
    }

    public static NBTInputStream createNetworkReader(InputStream stream) {
        return NbtUtils.createNetworkReader(stream, false, false);
    }

    public static NBTOutputStream createWriter(OutputStream stream) {
        Objects.requireNonNull(stream, "stream");
        return new NBTOutputStream(new DataOutputStream(stream));
    }

    public static NBTOutputStream createWriterLE(OutputStream stream) {
        Objects.requireNonNull(stream, "stream");
        return new NBTOutputStream(new LittleEndianDataOutputStream(stream));
    }

    public static NBTOutputStream createGZIPWriter(OutputStream stream) throws IOException {
        return NbtUtils.createWriter(new GZIPOutputStream(stream));
    }

    public static NBTOutputStream createNetworkWriter(OutputStream stream) {
        return new NBTOutputStream(new NetworkDataOutputStream(stream));
    }

    public static String toString(Object o) {
        if (o instanceof Byte) {
            return (Byte)o + "b";
        }
        if (o instanceof Short) {
            return (Short)o + "s";
        }
        if (o instanceof Integer) {
            return (Integer)o + "i";
        }
        if (o instanceof Long) {
            return (Long)o + "l";
        }
        if (o instanceof Float) {
            return ((Float)o).floatValue() + "f";
        }
        if (o instanceof Double) {
            return (Double)o + "d";
        }
        if (o instanceof byte[]) {
            return "0x" + NbtUtils.printHexBinary((byte[])o);
        }
        if (o instanceof String) {
            return "\"" + o + "\"";
        }
        if (o instanceof int[]) {
            StringJoiner joiner = new StringJoiner(", ");
            for (int i : (int[])o) {
                joiner.add(i + "i");
            }
            return "[ " + joiner + " ]";
        }
        if (o instanceof long[]) {
            StringJoiner joiner = new StringJoiner(", ");
            for (long l : (long[])o) {
                joiner.add(l + "l");
            }
            return "[ " + joiner + " ]";
        }
        return o.toString();
    }

    public static <T> T copy(T val) {
        if (val instanceof byte[]) {
            byte[] bytes = (byte[])val;
            return (T)Arrays.copyOf(bytes, bytes.length);
        }
        if (val instanceof int[]) {
            int[] ints = (int[])val;
            return (T)Arrays.copyOf(ints, ints.length);
        }
        if (val instanceof long[]) {
            long[] longs = (long[])val;
            return (T)Arrays.copyOf(longs, longs.length);
        }
        return val;
    }

    public static String indent(String string) {
        StringBuilder builder = new StringBuilder("  " + string);
        for (int i = 2; i < builder.length(); ++i) {
            if (builder.charAt(i) != '\n') continue;
            builder.insert(i + 1, "  ");
            i += 2;
        }
        return builder.toString();
    }

    public static String printHexBinary(byte[] data) {
        StringBuilder r = new StringBuilder(data.length << 1);
        for (byte b : data) {
            r.append(HEX_CODE[b >> 4 & 0xF]);
            r.append(HEX_CODE[b & 0xF]);
        }
        return r.toString();
    }
}

