/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.math.imaginary;

import com.nukkitx.math.GenericMath;
import com.nukkitx.math.TrigMath;
import com.nukkitx.math.imaginary.Complexf;
import com.nukkitx.math.imaginary.Imaginaryf;
import com.nukkitx.math.imaginary.Quaterniond;
import com.nukkitx.math.matrix.Matrix3f;
import com.nukkitx.math.vector.Vector3f;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class Quaternionf
implements Imaginaryf,
Comparable<Quaternionf>,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    public static final Quaternionf ZERO = new Quaternionf(0.0f, 0.0f, 0.0f, 0.0f);
    public static final Quaternionf IDENTITY = new Quaternionf(0.0f, 0.0f, 0.0f, 1.0f);
    private final float x;
    private final float y;
    private final float z;
    private final float w;
    private volatile transient boolean hashed = false;
    private volatile transient int hashCode = 0;

    private Quaternionf(float x, float y, float z, float w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getZ() {
        return this.z;
    }

    public float getW() {
        return this.w;
    }

    @Nonnull
    public Quaternionf add(Quaternionf q) {
        return this.add(q.x, q.y, q.z, q.w);
    }

    @Nonnull
    public Quaternionf add(double x, double y, double z, double w) {
        return this.add((float)x, (float)y, (float)z, (float)w);
    }

    @Nonnull
    public Quaternionf add(float x, float y, float z, float w) {
        return Quaternionf.from(this.x + x, this.y + y, this.z + z, this.w + w);
    }

    @Nonnull
    public Quaternionf sub(Quaternionf q) {
        return this.sub(q.x, q.y, q.z, q.w);
    }

    @Nonnull
    public Quaternionf sub(double x, double y, double z, double w) {
        return this.sub((float)x, (float)y, (float)z, (float)w);
    }

    @Nonnull
    public Quaternionf sub(float x, float y, float z, float w) {
        return Quaternionf.from(this.x - x, this.y - y, this.z - z, this.w - w);
    }

    @Nonnull
    public Quaternionf mul(double a) {
        return this.mul((float)a);
    }

    @Override
    @Nonnull
    public Quaternionf mul(float a) {
        return Quaternionf.from(this.x * a, this.y * a, this.z * a, this.w * a);
    }

    @Nonnull
    public Quaternionf mul(Quaternionf q) {
        return this.mul(q.x, q.y, q.z, q.w);
    }

    @Nonnull
    public Quaternionf mul(double x, double y, double z, double w) {
        return this.mul((float)x, (float)y, (float)z, (float)w);
    }

    @Nonnull
    public Quaternionf mul(float x, float y, float z, float w) {
        return Quaternionf.from(this.w * x + this.x * w + this.y * z - this.z * y, this.w * y + this.y * w + this.z * x - this.x * z, this.w * z + this.z * w + this.x * y - this.y * x, this.w * w - this.x * x - this.y * y - this.z * z);
    }

    @Nonnull
    public Quaternionf div(double a) {
        return this.div((float)a);
    }

    @Override
    @Nonnull
    public Quaternionf div(float a) {
        return Quaternionf.from(this.x / a, this.y / a, this.z / a, this.w / a);
    }

    @Nonnull
    public Quaternionf div(Quaternionf q) {
        return this.div(q.x, q.y, q.z, q.w);
    }

    @Nonnull
    public Quaternionf div(double x, double y, double z, double w) {
        return this.div((float)x, (float)y, (float)z, (float)w);
    }

    @Nonnull
    public Quaternionf div(float x, float y, float z, float w) {
        float d = x * x + y * y + z * z + w * w;
        return Quaternionf.from((this.x * w - this.w * x - this.z * y + this.y * z) / d, (this.y * w + this.z * x - this.w * y - this.x * z) / d, (this.z * w - this.y * x + this.x * y - this.w * z) / d, (this.w * w + this.x * x + this.y * y + this.z * z) / d);
    }

    public float dot(Quaternionf q) {
        return this.dot(q.x, q.y, q.z, q.w);
    }

    public float dot(double x, double y, double z, double w) {
        return this.dot((float)x, (float)y, (float)z, (float)w);
    }

    public float dot(float x, float y, float z, float w) {
        return this.x * x + this.y * y + this.z * z + this.w * w;
    }

    @Nonnull
    public Vector3f rotate(Vector3f v) {
        return this.rotate(v.getX(), v.getY(), v.getZ());
    }

    @Nonnull
    public Vector3f rotate(double x, double y, double z) {
        return this.rotate((float)x, (float)y, (float)z);
    }

    @Nonnull
    public Vector3f rotate(float x, float y, float z) {
        float length = this.length();
        if (Math.abs(length) < GenericMath.FLT_EPSILON) {
            throw new ArithmeticException("Cannot rotate by the zero quaternion");
        }
        float nx = this.x / length;
        float ny = this.y / length;
        float nz = this.z / length;
        float nw = this.w / length;
        float px = nw * x + ny * z - nz * y;
        float py = nw * y + nz * x - nx * z;
        float pz = nw * z + nx * y - ny * x;
        float pw = -nx * x - ny * y - nz * z;
        return Vector3f.from(pw * -nx + px * nw - py * nz + pz * ny, pw * -ny + py * nw - pz * nx + px * nz, pw * -nz + pz * nw - px * ny + py * nx);
    }

    @Nonnull
    public Vector3f getDirection() {
        return this.rotate(Vector3f.FORWARD);
    }

    @Nonnull
    public Vector3f getAxis() {
        float q = (float)Math.sqrt(1.0f - this.w * this.w);
        return Vector3f.from(this.x / q, this.y / q, this.z / q);
    }

    @Nonnull
    public Vector3f getAxesAnglesDeg() {
        return this.getAxesAnglesRad().mul(57.29577951308232);
    }

    @Nonnull
    public Vector3f getAxesAnglesRad() {
        double yaw;
        double pitch;
        double roll;
        double test = this.w * this.x - this.y * this.z;
        if (Math.abs(test) < 0.4999) {
            roll = TrigMath.atan2(2.0f * (this.w * this.z + this.x * this.y), 1.0f - 2.0f * (this.x * this.x + this.z * this.z));
            pitch = TrigMath.asin(2.0 * test);
            yaw = TrigMath.atan2(2.0f * (this.w * this.y + this.z * this.x), 1.0f - 2.0f * (this.x * this.x + this.y * this.y));
        } else {
            int sign = test < 0.0 ? -1 : 1;
            roll = 0.0;
            pitch = (double)sign * Math.PI / 2.0;
            yaw = (double)(-sign * 2) * TrigMath.atan2(this.z, this.w);
        }
        return Vector3f.from(pitch, yaw, roll);
    }

    @Override
    @Nonnull
    public Quaternionf conjugate() {
        return Quaternionf.from(-this.x, -this.y, -this.z, this.w);
    }

    @Override
    @Nonnull
    public Quaternionf invert() {
        float lengthSquared = this.lengthSquared();
        if (Math.abs(lengthSquared) < GenericMath.FLT_EPSILON) {
            throw new ArithmeticException("Cannot invert a quaternion of length zero");
        }
        return this.conjugate().div(lengthSquared);
    }

    @Override
    public float lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
    }

    @Override
    public float length() {
        return (float)Math.sqrt(this.lengthSquared());
    }

    @Override
    @Nonnull
    public Quaternionf normalize() {
        float length = this.length();
        if (Math.abs(length) < GenericMath.FLT_EPSILON) {
            throw new ArithmeticException("Cannot normalize the zero quaternion");
        }
        return Quaternionf.from(this.x / length, this.y / length, this.z / length, this.w / length);
    }

    @Nonnull
    public Complexf toComplex() {
        float w2 = this.w * this.w;
        return Complexf.from(2.0f * w2 - 1.0f, 2.0f * this.w * (float)Math.sqrt(1.0f - w2));
    }

    @Override
    @Nonnull
    public Quaternionf toFloat() {
        return Quaternionf.from(this.x, this.y, this.z, this.w);
    }

    @Override
    @Nonnull
    public Quaterniond toDouble() {
        return Quaterniond.from(this.x, this.y, this.z, this.w);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Quaternionf)) {
            return false;
        }
        Quaternionf quaternion = (Quaternionf)o;
        if (Float.compare(quaternion.w, this.w) != 0) {
            return false;
        }
        if (Float.compare(quaternion.x, this.x) != 0) {
            return false;
        }
        if (Float.compare(quaternion.y, this.y) != 0) {
            return false;
        }
        return Float.compare(quaternion.z, this.z) == 0;
    }

    public int hashCode() {
        if (!this.hashed) {
            int result = this.x != 0.0f ? Float.hashCode(this.x) : 0;
            result = 31 * result + (this.y != 0.0f ? Float.hashCode(this.y) : 0);
            result = 31 * result + (this.z != 0.0f ? Float.hashCode(this.z) : 0);
            this.hashCode = 31 * result + (this.w != 0.0f ? Float.hashCode(this.w) : 0);
            this.hashed = true;
        }
        return this.hashCode;
    }

    @Override
    public int compareTo(Quaternionf q) {
        return (int)Math.signum(this.lengthSquared() - q.lengthSquared());
    }

    @Nonnull
    public Quaternionf clone() {
        return Quaternionf.from(this);
    }

    @Nonnull
    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ", " + this.w + ")";
    }

    @Nonnull
    public static Quaternionf fromReal(float w) {
        return w == 0.0f ? ZERO : Quaternionf.from(0.0f, 0.0f, 0.0f, w);
    }

    @Nonnull
    public static Quaternionf fromImaginary(float x, float y, float z) {
        return x == 0.0f && y == 0.0f && z == 0.0f ? ZERO : new Quaternionf(x, y, z, 0.0f);
    }

    public static Quaternionf from(Quaternionf q) {
        return Quaternionf.from(q.x, q.y, q.z, q.w);
    }

    @Nonnull
    public static Quaternionf from(double x, double y, double z, double w) {
        return Quaternionf.from((float)x, (float)y, (float)z, (float)w);
    }

    @Nonnull
    public static Quaternionf from(float x, float y, float z, float w) {
        return x == 0.0f && y == 0.0f && z == 0.0f && w == 0.0f ? ZERO : new Quaternionf(x, y, z, w);
    }

    @Nonnull
    public static Quaternionf fromAxesAnglesDeg(double pitch, double yaw, double roll) {
        return Quaternionf.fromAxesAnglesDeg((float)pitch, (float)yaw, (float)roll);
    }

    @Nonnull
    public static Quaternionf fromAxesAnglesRad(double pitch, double yaw, double roll) {
        return Quaternionf.fromAxesAnglesRad((float)pitch, (float)yaw, (float)roll);
    }

    @Nonnull
    public static Quaternionf fromAxesAnglesDeg(float pitch, float yaw, float roll) {
        return Quaternionf.fromAngleDegAxis(yaw, Vector3f.UNIT_Y).mul(Quaternionf.fromAngleDegAxis(pitch, Vector3f.UNIT_X)).mul(Quaternionf.fromAngleDegAxis(roll, Vector3f.UNIT_Z));
    }

    @Nonnull
    public static Quaternionf fromAxesAnglesRad(float pitch, float yaw, float roll) {
        return Quaternionf.fromAngleRadAxis(yaw, Vector3f.UNIT_Y).mul(Quaternionf.fromAngleRadAxis(pitch, Vector3f.UNIT_X)).mul(Quaternionf.fromAngleRadAxis(roll, Vector3f.UNIT_Z));
    }

    @Nonnull
    public static Quaternionf fromRotationTo(Vector3f from, Vector3f to) {
        return Quaternionf.fromAngleRadAxis(TrigMath.acos(from.dot(to) / (from.length() * to.length())), from.cross(to));
    }

    @Nonnull
    public static Quaternionf fromAngleDegAxis(double angle, Vector3f axis) {
        return Quaternionf.fromAngleRadAxis(Math.toRadians(angle), axis);
    }

    @Nonnull
    public static Quaternionf fromAngleRadAxis(double angle, Vector3f axis) {
        return Quaternionf.fromAngleRadAxis((float)angle, axis);
    }

    @Nonnull
    public static Quaternionf fromAngleDegAxis(float angle, Vector3f axis) {
        return Quaternionf.fromAngleRadAxis((float)Math.toRadians(angle), axis);
    }

    @Nonnull
    public static Quaternionf fromAngleRadAxis(float angle, Vector3f axis) {
        return Quaternionf.fromAngleRadAxis(angle, axis.getX(), axis.getY(), axis.getZ());
    }

    @Nonnull
    public static Quaternionf fromAngleDegAxis(double angle, double x, double y, double z) {
        return Quaternionf.fromAngleRadAxis(Math.toRadians(angle), x, y, z);
    }

    @Nonnull
    public static Quaternionf fromAngleRadAxis(double angle, double x, double y, double z) {
        return Quaternionf.fromAngleRadAxis((float)angle, (float)x, (float)y, (float)z);
    }

    @Nonnull
    public static Quaternionf fromAngleDegAxis(float angle, float x, float y, float z) {
        return Quaternionf.fromAngleRadAxis((float)Math.toRadians(angle), x, y, z);
    }

    @Nonnull
    public static Quaternionf fromAngleRadAxis(float angle, float x, float y, float z) {
        float halfAngle = angle / 2.0f;
        float q = TrigMath.sin(halfAngle) / (float)Math.sqrt(x * x + y * y + z * z);
        return Quaternionf.from(x * q, y * q, z * q, TrigMath.cos(halfAngle));
    }

    @Nonnull
    public static Quaternionf fromRotationMatrix(Matrix3f matrix) {
        float trace = matrix.trace();
        if (trace < 0.0f) {
            if (matrix.get(1, 1) > matrix.get(0, 0)) {
                if (matrix.get(2, 2) > matrix.get(1, 1)) {
                    float r = (float)Math.sqrt(matrix.get(2, 2) - matrix.get(0, 0) - matrix.get(1, 1) + 1.0f);
                    float s2 = 0.5f / r;
                    return Quaternionf.from((matrix.get(2, 0) + matrix.get(0, 2)) * s2, (matrix.get(1, 2) + matrix.get(2, 1)) * s2, 0.5f * r, (matrix.get(1, 0) - matrix.get(0, 1)) * s2);
                }
                float r = (float)Math.sqrt(matrix.get(1, 1) - matrix.get(2, 2) - matrix.get(0, 0) + 1.0f);
                float s3 = 0.5f / r;
                return Quaternionf.from((matrix.get(0, 1) + matrix.get(1, 0)) * s3, 0.5f * r, (matrix.get(1, 2) + matrix.get(2, 1)) * s3, (matrix.get(0, 2) - matrix.get(2, 0)) * s3);
            }
            if (matrix.get(2, 2) > matrix.get(0, 0)) {
                float r = (float)Math.sqrt(matrix.get(2, 2) - matrix.get(0, 0) - matrix.get(1, 1) + 1.0f);
                float s4 = 0.5f / r;
                return Quaternionf.from((matrix.get(2, 0) + matrix.get(0, 2)) * s4, (matrix.get(1, 2) + matrix.get(2, 1)) * s4, 0.5f * r, (matrix.get(1, 0) - matrix.get(0, 1)) * s4);
            }
            float r = (float)Math.sqrt(matrix.get(0, 0) - matrix.get(1, 1) - matrix.get(2, 2) + 1.0f);
            float s5 = 0.5f / r;
            return Quaternionf.from(0.5f * r, (matrix.get(0, 1) + matrix.get(1, 0)) * s5, (matrix.get(2, 0) - matrix.get(0, 2)) * s5, (matrix.get(2, 1) - matrix.get(1, 2)) * s5);
        }
        float r = (float)Math.sqrt(trace + 1.0f);
        float s6 = 0.5f / r;
        return Quaternionf.from((matrix.get(2, 1) - matrix.get(1, 2)) * s6, (matrix.get(0, 2) - matrix.get(2, 0)) * s6, (matrix.get(1, 0) - matrix.get(0, 1)) * s6, 0.5f * r);
    }
}

