/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.packetlib.tcp;

import com.github.steveice10.packetlib.ProxyInfo;
import com.github.steveice10.packetlib.codec.PacketCodecHelper;
import com.github.steveice10.packetlib.helper.TransportHelper;
import com.github.steveice10.packetlib.packet.PacketProtocol;
import com.github.steveice10.packetlib.tcp.TcpPacketCodec;
import com.github.steveice10.packetlib.tcp.TcpPacketSizer;
import com.github.steveice10.packetlib.tcp.TcpSession;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.AddressedEnvelope;
import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollDatagramChannel;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.kqueue.KQueueDatagramChannel;
import io.netty.channel.kqueue.KQueueEventLoopGroup;
import io.netty.channel.kqueue.KQueueSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.dns.DefaultDnsQuestion;
import io.netty.handler.codec.dns.DefaultDnsRawRecord;
import io.netty.handler.codec.dns.DefaultDnsRecordDecoder;
import io.netty.handler.codec.dns.DnsRecordType;
import io.netty.handler.codec.dns.DnsResponse;
import io.netty.handler.codec.dns.DnsSection;
import io.netty.handler.codec.haproxy.HAProxyCommand;
import io.netty.handler.codec.haproxy.HAProxyMessage;
import io.netty.handler.codec.haproxy.HAProxyMessageEncoder;
import io.netty.handler.codec.haproxy.HAProxyProtocolVersion;
import io.netty.handler.codec.haproxy.HAProxyProxiedProtocol;
import io.netty.handler.proxy.HttpProxyHandler;
import io.netty.handler.proxy.Socks4ProxyHandler;
import io.netty.handler.proxy.Socks5ProxyHandler;
import io.netty.incubator.channel.uring.IOUringDatagramChannel;
import io.netty.incubator.channel.uring.IOUringEventLoopGroup;
import io.netty.incubator.channel.uring.IOUringSocketChannel;
import io.netty.resolver.dns.DnsNameResolverBuilder;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;

public class TcpClientSession
extends TcpSession {
    private static final String IP_REGEX = "\\b\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\b";
    private static Class<? extends Channel> CHANNEL_CLASS;
    private static Class<? extends DatagramChannel> DATAGRAM_CHANNEL_CLASS;
    private static EventLoopGroup EVENT_LOOP_GROUP;
    private final String bindAddress;
    private final int bindPort;
    private final ProxyInfo proxy;
    private final PacketCodecHelper codecHelper;

    public TcpClientSession(String host, int port, PacketProtocol protocol) {
        this(host, port, protocol, null);
    }

    public TcpClientSession(String host, int port, PacketProtocol protocol, ProxyInfo proxy) {
        this(host, port, "0.0.0.0", 0, protocol, proxy);
    }

    public TcpClientSession(String host, int port, String bindAddress, int bindPort, PacketProtocol protocol) {
        this(host, port, bindAddress, bindPort, protocol, null);
    }

    public TcpClientSession(String host, int port, String bindAddress, int bindPort, PacketProtocol protocol, ProxyInfo proxy) {
        super(host, port, protocol);
        this.bindAddress = bindAddress;
        this.bindPort = bindPort;
        this.proxy = proxy;
        this.codecHelper = protocol.createHelper();
    }

    @Override
    public void connect(boolean wait) {
        if (this.disconnected) {
            throw new IllegalStateException("Session has already been disconnected.");
        }
        final boolean debug = this.getFlag("print-packetlib-debug", false);
        if (CHANNEL_CLASS == null) {
            TcpClientSession.createTcpEventLoopGroup();
        }
        try {
            Bootstrap bootstrap = new Bootstrap();
            bootstrap.channel(CHANNEL_CLASS);
            ((Bootstrap)((Bootstrap)bootstrap.handler(new ChannelInitializer<Channel>(){

                @Override
                public void initChannel(Channel channel) {
                    PacketProtocol protocol;
                    block3: {
                        protocol = TcpClientSession.this.getPacketProtocol();
                        protocol.newClientSession(TcpClientSession.this);
                        channel.config().setOption(ChannelOption.IP_TOS, 24);
                        try {
                            channel.config().setOption(ChannelOption.TCP_NODELAY, true);
                        }
                        catch (ChannelException e) {
                            if (!debug) break block3;
                            System.out.println("Exception while trying to set TCP_NODELAY");
                            e.printStackTrace();
                        }
                    }
                    ChannelPipeline pipeline = channel.pipeline();
                    TcpClientSession.this.refreshReadTimeoutHandler(channel);
                    TcpClientSession.this.refreshWriteTimeoutHandler(channel);
                    TcpClientSession.this.addProxy(pipeline);
                    int size = protocol.getPacketHeader().getLengthSize();
                    if (size > 0) {
                        pipeline.addLast("sizer", (ChannelHandler)new TcpPacketSizer(TcpClientSession.this, size));
                    }
                    pipeline.addLast("codec", (ChannelHandler)new TcpPacketCodec(TcpClientSession.this, true));
                    pipeline.addLast("manager", (ChannelHandler)TcpClientSession.this);
                    TcpClientSession.this.addHAProxySupport(pipeline);
                }
            })).group(EVENT_LOOP_GROUP)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, this.getConnectTimeout() * 1000);
            InetSocketAddress remoteAddress = this.resolveAddress();
            bootstrap.remoteAddress(remoteAddress);
            bootstrap.localAddress(this.bindAddress, this.bindPort);
            ChannelFuture future = bootstrap.connect();
            if (wait) {
                future.sync();
            }
            future.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)futureListener -> {
                if (!futureListener.isSuccess()) {
                    this.exceptionCaught(null, futureListener.cause());
                }
            }));
        }
        catch (Throwable t2) {
            this.exceptionCaught(null, t2);
        }
    }

    @Override
    public PacketCodecHelper getCodecHelper() {
        return this.codecHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private InetSocketAddress resolveAddress() {
        debug = this.getFlag("print-packetlib-debug", false);
        name = this.getPacketProtocol().getSRVRecordPrefix() + "._tcp." + this.getHost();
        if (debug) {
            System.out.println("[PacketLib] Attempting SRV lookup for \"" + name + "\".");
        }
        if (this.getFlag("attempt-srv-resolve", true).booleanValue() && !this.host.matches("\\b\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\b") && !this.host.equalsIgnoreCase("localhost")) {
            resolver = null;
            envelope = null;
            try {
                resolver = new DnsNameResolverBuilder(TcpClientSession.EVENT_LOOP_GROUP.next()).channelType(TcpClientSession.DATAGRAM_CHANNEL_CLASS).build();
                envelope = (AddressedEnvelope)resolver.query(new DefaultDnsQuestion(name, DnsRecordType.SRV)).get();
                response = (DnsResponse)envelope.content();
                if (response.count(DnsSection.ANSWER) > 0) {
                    record = (DefaultDnsRawRecord)response.recordAt(DnsSection.ANSWER, 0);
                    if (record.type() == DnsRecordType.SRV) {
                        buf = record.content();
                        buf.skipBytes(4);
                        port = buf.readUnsignedShort();
                        host = DefaultDnsRecordDecoder.decodeName(buf);
                        if (host.endsWith(".")) {
                            host = host.substring(0, host.length() - 1);
                        }
                        if (debug) {
                            System.out.println("[PacketLib] Found SRV record containing \"" + host + ":" + port + "\".");
                        }
                        this.host = host;
                        this.port = port;
                    }
                    if (!debug) ** GOTO lbl47
                    System.out.println("[PacketLib] Received non-SRV record in response.");
                }
                if (!debug) ** GOTO lbl47
                System.out.println("[PacketLib] No SRV record found.");
            }
            catch (Exception e) {
                if (!debug) ** GOTO lbl47
                System.out.println("[PacketLib] Failed to resolve SRV record.");
                e.printStackTrace();
            }
            finally {
                if (envelope != null) {
                    envelope.release();
                }
                if (resolver != null) {
                    resolver.close();
                }
            }
        } else if (debug) {
            System.out.println("[PacketLib] Not resolving SRV record for " + this.host);
        }
lbl47:
        // 10 sources

        try {
            resolved = InetAddress.getByName(this.getHost());
            if (debug) {
                System.out.printf("[PacketLib] Resolved %s -> %s%n", new Object[]{this.getHost(), resolved.getHostAddress()});
            }
            return new InetSocketAddress(resolved, this.getPort());
        }
        catch (UnknownHostException e) {
            if (debug) {
                System.out.println("[PacketLib] Failed to resolve host, letting Netty do it instead.");
                e.printStackTrace();
            }
            return InetSocketAddress.createUnresolved(this.getHost(), this.getPort());
        }
    }

    private void addProxy(ChannelPipeline pipeline) {
        if (this.proxy != null) {
            switch (this.proxy.getType()) {
                case HTTP: {
                    if (this.proxy.isAuthenticated()) {
                        pipeline.addFirst("proxy", (ChannelHandler)new HttpProxyHandler(this.proxy.getAddress(), this.proxy.getUsername(), this.proxy.getPassword()));
                        break;
                    }
                    pipeline.addFirst("proxy", (ChannelHandler)new HttpProxyHandler(this.proxy.getAddress()));
                    break;
                }
                case SOCKS4: {
                    if (this.proxy.isAuthenticated()) {
                        pipeline.addFirst("proxy", (ChannelHandler)new Socks4ProxyHandler(this.proxy.getAddress(), this.proxy.getUsername()));
                        break;
                    }
                    pipeline.addFirst("proxy", (ChannelHandler)new Socks4ProxyHandler(this.proxy.getAddress()));
                    break;
                }
                case SOCKS5: {
                    if (this.proxy.isAuthenticated()) {
                        pipeline.addFirst("proxy", (ChannelHandler)new Socks5ProxyHandler(this.proxy.getAddress(), this.proxy.getUsername(), this.proxy.getPassword()));
                        break;
                    }
                    pipeline.addFirst("proxy", (ChannelHandler)new Socks5ProxyHandler(this.proxy.getAddress()));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported proxy type: " + (Object)((Object)this.proxy.getType()));
                }
            }
        }
    }

    private void addHAProxySupport(ChannelPipeline pipeline) {
        final InetSocketAddress clientAddress = (InetSocketAddress)this.getFlag("client-proxied-address");
        if (this.getFlag("enable-client-proxy-protocol", false).booleanValue() && clientAddress != null) {
            pipeline.addFirst("proxy-protocol-packet-sender", (ChannelHandler)new ChannelInboundHandlerAdapter(){

                @Override
                public void channelActive(ChannelHandlerContext ctx) throws Exception {
                    HAProxyProxiedProtocol proxiedProtocol = clientAddress.getAddress() instanceof Inet4Address ? HAProxyProxiedProtocol.TCP4 : HAProxyProxiedProtocol.TCP6;
                    InetSocketAddress remoteAddress = (InetSocketAddress)ctx.channel().remoteAddress();
                    ctx.channel().writeAndFlush(new HAProxyMessage(HAProxyProtocolVersion.V2, HAProxyCommand.PROXY, proxiedProtocol, clientAddress.getAddress().getHostAddress(), remoteAddress.getAddress().getHostAddress(), clientAddress.getPort(), remoteAddress.getPort()));
                    ctx.pipeline().remove(this);
                    ctx.pipeline().remove("proxy-protocol-encoder");
                    super.channelActive(ctx);
                }
            });
            pipeline.addFirst("proxy-protocol-encoder", (ChannelHandler)HAProxyMessageEncoder.INSTANCE);
        }
    }

    @Override
    public void disconnect(String reason, Throwable cause) {
        super.disconnect(reason, cause);
    }

    private static void createTcpEventLoopGroup() {
        if (CHANNEL_CLASS != null) {
            return;
        }
        switch (TransportHelper.determineTransportMethod()) {
            case IO_URING: {
                EVENT_LOOP_GROUP = new IOUringEventLoopGroup();
                CHANNEL_CLASS = IOUringSocketChannel.class;
                DATAGRAM_CHANNEL_CLASS = IOUringDatagramChannel.class;
                break;
            }
            case EPOLL: {
                EVENT_LOOP_GROUP = new EpollEventLoopGroup();
                CHANNEL_CLASS = EpollSocketChannel.class;
                DATAGRAM_CHANNEL_CLASS = EpollDatagramChannel.class;
                break;
            }
            case KQUEUE: {
                EVENT_LOOP_GROUP = new KQueueEventLoopGroup();
                CHANNEL_CLASS = KQueueSocketChannel.class;
                DATAGRAM_CHANNEL_CLASS = KQueueDatagramChannel.class;
                break;
            }
            case NIO: {
                EVENT_LOOP_GROUP = new NioEventLoopGroup();
                CHANNEL_CLASS = NioSocketChannel.class;
                DATAGRAM_CHANNEL_CLASS = NioDatagramChannel.class;
            }
        }
    }
}

