/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.opennbt.tag.builtin;

import com.github.steveice10.opennbt.SNBTIO;
import com.github.steveice10.opennbt.tag.builtin.Tag;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class StringTag
extends Tag {
    private String value;

    public StringTag(String name) {
        this(name, "");
    }

    public StringTag(String name, String value) {
        super(name);
        this.value = value;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public void read(DataInput in) throws IOException {
        this.value = in.readUTF();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeUTF(this.value);
    }

    @Override
    public void destringify(SNBTIO.StringifiedNBTReader in) throws IOException {
        String s2 = in.readNextSingleValueString();
        this.value = s2.charAt(0) == '\"' ? s2.substring(1, s2.length() - 1).replaceAll("\\\\\"", "\"") : (s2.charAt(0) == '\'' ? s2.substring(1, s2.length() - 1).replaceAll("\\\\'", "'") : s2);
    }

    @Override
    public void stringify(SNBTIO.StringifiedNBTWriter out, boolean linebreak, int depth) throws IOException {
        if (this.value.matches("(?!\\d+)[\\w\\d]*")) {
            out.append(this.value);
            return;
        }
        if (this.value.contains("\"")) {
            if (this.value.contains("'")) {
                StringBuilder sb = new StringBuilder("\"");
                sb.append(this.value.replaceAll("\"", "\\\\\""));
                sb.append("\"");
                out.append(sb.toString());
                return;
            }
            StringBuilder sb = new StringBuilder("'");
            sb.append(this.value);
            sb.append("'");
            out.append(sb.toString());
            return;
        }
        StringBuilder sb = new StringBuilder("\"");
        sb.append(this.value);
        sb.append("\"");
        out.append(sb.toString());
    }

    @Override
    public StringTag clone() {
        return new StringTag(this.getName(), this.getValue());
    }
}

