/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.serverbound.level;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import com.nukkitx.math.vector.Vector3i;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import lombok.NonNull;

public class ServerboundJigsawGeneratePacket
implements MinecraftPacket {
    @NonNull
    private final Vector3i position;
    private final int levels;
    private final boolean keepJigsaws;

    public ServerboundJigsawGeneratePacket(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        this.position = helper.readPosition(in);
        this.levels = helper.readVarInt(in);
        this.keepJigsaws = in.readBoolean();
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        helper.writePosition(out, this.position);
        helper.writeVarInt(out, this.levels);
        out.writeBoolean(this.keepJigsaws);
    }

    @NonNull
    public Vector3i getPosition() {
        return this.position;
    }

    public int getLevels() {
        return this.levels;
    }

    public boolean isKeepJigsaws() {
        return this.keepJigsaws;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundJigsawGeneratePacket)) {
            return false;
        }
        ServerboundJigsawGeneratePacket other = (ServerboundJigsawGeneratePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getLevels() != other.getLevels()) {
            return false;
        }
        if (this.isKeepJigsaws() != other.isKeepJigsaws()) {
            return false;
        }
        Vector3i this$position = this.getPosition();
        Vector3i other$position = other.getPosition();
        return !(this$position == null ? other$position != null : !((Object)this$position).equals(other$position));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerboundJigsawGeneratePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getLevels();
        result = result * 59 + (this.isKeepJigsaws() ? 79 : 97);
        Vector3i $position = this.getPosition();
        result = result * 59 + ($position == null ? 43 : ((Object)$position).hashCode());
        return result;
    }

    public String toString() {
        return "ServerboundJigsawGeneratePacket(position=" + this.getPosition() + ", levels=" + this.getLevels() + ", keepJigsaws=" + this.isKeepJigsaws() + ")";
    }

    public ServerboundJigsawGeneratePacket withPosition(@NonNull Vector3i position) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        return this.position == position ? this : new ServerboundJigsawGeneratePacket(position, this.levels, this.keepJigsaws);
    }

    public ServerboundJigsawGeneratePacket withLevels(int levels) {
        return this.levels == levels ? this : new ServerboundJigsawGeneratePacket(this.position, levels, this.keepJigsaws);
    }

    public ServerboundJigsawGeneratePacket withKeepJigsaws(boolean keepJigsaws) {
        return this.keepJigsaws == keepJigsaws ? this : new ServerboundJigsawGeneratePacket(this.position, this.levels, keepJigsaws);
    }

    public ServerboundJigsawGeneratePacket(@NonNull Vector3i position, int levels, boolean keepJigsaws) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        this.position = position;
        this.levels = levels;
        this.keepJigsaws = keepJigsaws;
    }
}

