/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.serverbound;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import com.github.steveice10.mc.protocol.data.game.LastSeenMessage;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServerboundChatPacket
implements MinecraftPacket {
    @NotNull
    private final String message;
    private final long timeStamp;
    private final long salt;
    private final byte @NotNull [] signature;
    private final boolean signedPreview;
    private final List<LastSeenMessage> lastSeenMessages;
    @Nullable
    private final LastSeenMessage lastReceivedMessage;

    public ServerboundChatPacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.message = helper.readString(in);
        this.timeStamp = in.readLong();
        this.salt = in.readLong();
        this.signature = helper.readByteArray(in);
        this.signedPreview = in.readBoolean();
        this.lastSeenMessages = new ArrayList<LastSeenMessage>();
        int seenMessageCount = Math.min(helper.readVarInt(in), 5);
        for (int i = 0; i < seenMessageCount; ++i) {
            this.lastSeenMessages.add(new LastSeenMessage(helper.readUUID(in), helper.readByteArray(in)));
        }
        this.lastReceivedMessage = in.readBoolean() ? new LastSeenMessage(helper.readUUID(in), helper.readByteArray(in)) : null;
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        helper.writeString(out, this.message);
        out.writeLong(this.timeStamp);
        out.writeLong(this.salt);
        helper.writeVarInt(out, this.signature.length);
        out.writeBytes(this.signature);
        out.writeBoolean(this.signedPreview);
        helper.writeVarInt(out, this.lastSeenMessages.size());
        for (LastSeenMessage entry : this.lastSeenMessages) {
            helper.writeUUID(out, entry.getProfileId());
            helper.writeVarInt(out, entry.getLastSignature().length);
            out.writeBytes(entry.getLastSignature());
        }
        if (this.lastReceivedMessage != null) {
            out.writeBoolean(true);
            helper.writeUUID(out, this.lastReceivedMessage.getProfileId());
            helper.writeVarInt(out, this.lastReceivedMessage.getLastSignature().length);
            out.writeBytes(this.lastReceivedMessage.getLastSignature());
        } else {
            out.writeBoolean(false);
        }
    }

    @NotNull
    public String getMessage() {
        return this.message;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public long getSalt() {
        return this.salt;
    }

    public byte @NotNull [] getSignature() {
        return this.signature;
    }

    public boolean isSignedPreview() {
        return this.signedPreview;
    }

    public List<LastSeenMessage> getLastSeenMessages() {
        return this.lastSeenMessages;
    }

    @Nullable
    public LastSeenMessage getLastReceivedMessage() {
        return this.lastReceivedMessage;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundChatPacket)) {
            return false;
        }
        ServerboundChatPacket other = (ServerboundChatPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTimeStamp() != other.getTimeStamp()) {
            return false;
        }
        if (this.getSalt() != other.getSalt()) {
            return false;
        }
        if (this.isSignedPreview() != other.isSignedPreview()) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        if (!Arrays.equals(this.getSignature(), other.getSignature())) {
            return false;
        }
        List<LastSeenMessage> this$lastSeenMessages = this.getLastSeenMessages();
        List<LastSeenMessage> other$lastSeenMessages = other.getLastSeenMessages();
        if (this$lastSeenMessages == null ? other$lastSeenMessages != null : !((Object)this$lastSeenMessages).equals(other$lastSeenMessages)) {
            return false;
        }
        LastSeenMessage this$lastReceivedMessage = this.getLastReceivedMessage();
        LastSeenMessage other$lastReceivedMessage = other.getLastReceivedMessage();
        return !(this$lastReceivedMessage == null ? other$lastReceivedMessage != null : !((Object)this$lastReceivedMessage).equals(other$lastReceivedMessage));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerboundChatPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $timeStamp = this.getTimeStamp();
        result = result * 59 + (int)($timeStamp >>> 32 ^ $timeStamp);
        long $salt = this.getSalt();
        result = result * 59 + (int)($salt >>> 32 ^ $salt);
        result = result * 59 + (this.isSignedPreview() ? 79 : 97);
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        result = result * 59 + Arrays.hashCode(this.getSignature());
        List<LastSeenMessage> $lastSeenMessages = this.getLastSeenMessages();
        result = result * 59 + ($lastSeenMessages == null ? 43 : ((Object)$lastSeenMessages).hashCode());
        LastSeenMessage $lastReceivedMessage = this.getLastReceivedMessage();
        result = result * 59 + ($lastReceivedMessage == null ? 43 : ((Object)$lastReceivedMessage).hashCode());
        return result;
    }

    public String toString() {
        return "ServerboundChatPacket(message=" + this.getMessage() + ", timeStamp=" + this.getTimeStamp() + ", salt=" + this.getSalt() + ", signature=" + this.getSignature() + ", signedPreview=" + this.isSignedPreview() + ", lastSeenMessages=" + this.getLastSeenMessages() + ", lastReceivedMessage=" + this.getLastReceivedMessage() + ")";
    }

    public ServerboundChatPacket withMessage(@NotNull String message) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        return this.message == message ? this : new ServerboundChatPacket(message, this.timeStamp, this.salt, this.signature, this.signedPreview, this.lastSeenMessages, this.lastReceivedMessage);
    }

    public ServerboundChatPacket withTimeStamp(long timeStamp) {
        return this.timeStamp == timeStamp ? this : new ServerboundChatPacket(this.message, timeStamp, this.salt, this.signature, this.signedPreview, this.lastSeenMessages, this.lastReceivedMessage);
    }

    public ServerboundChatPacket withSalt(long salt) {
        return this.salt == salt ? this : new ServerboundChatPacket(this.message, this.timeStamp, salt, this.signature, this.signedPreview, this.lastSeenMessages, this.lastReceivedMessage);
    }

    public ServerboundChatPacket withSignature(byte @NotNull [] signature) {
        return this.signature == signature ? this : new ServerboundChatPacket(this.message, this.timeStamp, this.salt, signature, this.signedPreview, this.lastSeenMessages, this.lastReceivedMessage);
    }

    public ServerboundChatPacket withSignedPreview(boolean signedPreview) {
        return this.signedPreview == signedPreview ? this : new ServerboundChatPacket(this.message, this.timeStamp, this.salt, this.signature, signedPreview, this.lastSeenMessages, this.lastReceivedMessage);
    }

    public ServerboundChatPacket withLastSeenMessages(List<LastSeenMessage> lastSeenMessages) {
        return this.lastSeenMessages == lastSeenMessages ? this : new ServerboundChatPacket(this.message, this.timeStamp, this.salt, this.signature, this.signedPreview, lastSeenMessages, this.lastReceivedMessage);
    }

    public ServerboundChatPacket withLastReceivedMessage(@Nullable LastSeenMessage lastReceivedMessage) {
        return this.lastReceivedMessage == lastReceivedMessage ? this : new ServerboundChatPacket(this.message, this.timeStamp, this.salt, this.signature, this.signedPreview, this.lastSeenMessages, lastReceivedMessage);
    }

    public ServerboundChatPacket(@NotNull String message, long timeStamp, long salt, byte @NotNull [] signature, boolean signedPreview, List<LastSeenMessage> lastSeenMessages, @Nullable LastSeenMessage lastReceivedMessage) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        this.message = message;
        this.timeStamp = timeStamp;
        this.salt = salt;
        this.signature = signature;
        this.signedPreview = signedPreview;
        this.lastSeenMessages = lastSeenMessages;
        this.lastReceivedMessage = lastReceivedMessage;
    }
}

