/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.serverbound;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import com.github.steveice10.mc.protocol.data.game.LastSeenMessage;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class ServerboundChatAckPacket
implements MinecraftPacket {
    private final List<LastSeenMessage> lastSeenMessages;
    @Nullable
    private final LastSeenMessage lastReceivedMessage;

    public ServerboundChatAckPacket(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        this.lastSeenMessages = new ArrayList<LastSeenMessage>();
        int seenMessageCount = Math.min(helper.readVarInt(in), 5);
        for (int i = 0; i < seenMessageCount; ++i) {
            this.lastSeenMessages.add(new LastSeenMessage(helper.readUUID(in), helper.readByteArray(in)));
        }
        this.lastReceivedMessage = in.readBoolean() ? new LastSeenMessage(helper.readUUID(in), helper.readByteArray(in)) : null;
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        helper.writeVarInt(out, this.lastSeenMessages.size());
        for (LastSeenMessage entry : this.lastSeenMessages) {
            helper.writeUUID(out, entry.getProfileId());
            helper.writeVarInt(out, entry.getLastSignature().length);
            out.writeBytes(entry.getLastSignature());
        }
        if (this.lastReceivedMessage != null) {
            out.writeBoolean(true);
            helper.writeUUID(out, this.lastReceivedMessage.getProfileId());
            helper.writeVarInt(out, this.lastReceivedMessage.getLastSignature().length);
            out.writeBytes(this.lastReceivedMessage.getLastSignature());
        } else {
            out.writeBoolean(false);
        }
    }

    public List<LastSeenMessage> getLastSeenMessages() {
        return this.lastSeenMessages;
    }

    @Nullable
    public LastSeenMessage getLastReceivedMessage() {
        return this.lastReceivedMessage;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundChatAckPacket)) {
            return false;
        }
        ServerboundChatAckPacket other = (ServerboundChatAckPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<LastSeenMessage> this$lastSeenMessages = this.getLastSeenMessages();
        List<LastSeenMessage> other$lastSeenMessages = other.getLastSeenMessages();
        if (this$lastSeenMessages == null ? other$lastSeenMessages != null : !((Object)this$lastSeenMessages).equals(other$lastSeenMessages)) {
            return false;
        }
        LastSeenMessage this$lastReceivedMessage = this.getLastReceivedMessage();
        LastSeenMessage other$lastReceivedMessage = other.getLastReceivedMessage();
        return !(this$lastReceivedMessage == null ? other$lastReceivedMessage != null : !((Object)this$lastReceivedMessage).equals(other$lastReceivedMessage));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerboundChatAckPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<LastSeenMessage> $lastSeenMessages = this.getLastSeenMessages();
        result = result * 59 + ($lastSeenMessages == null ? 43 : ((Object)$lastSeenMessages).hashCode());
        LastSeenMessage $lastReceivedMessage = this.getLastReceivedMessage();
        result = result * 59 + ($lastReceivedMessage == null ? 43 : ((Object)$lastReceivedMessage).hashCode());
        return result;
    }

    public String toString() {
        return "ServerboundChatAckPacket(lastSeenMessages=" + this.getLastSeenMessages() + ", lastReceivedMessage=" + this.getLastReceivedMessage() + ")";
    }

    public ServerboundChatAckPacket withLastSeenMessages(List<LastSeenMessage> lastSeenMessages) {
        return this.lastSeenMessages == lastSeenMessages ? this : new ServerboundChatAckPacket(lastSeenMessages, this.lastReceivedMessage);
    }

    public ServerboundChatAckPacket withLastReceivedMessage(@Nullable LastSeenMessage lastReceivedMessage) {
        return this.lastReceivedMessage == lastReceivedMessage ? this : new ServerboundChatAckPacket(this.lastSeenMessages, lastReceivedMessage);
    }

    public ServerboundChatAckPacket(List<LastSeenMessage> lastSeenMessages, @Nullable LastSeenMessage lastReceivedMessage) {
        this.lastSeenMessages = lastSeenMessages;
        this.lastReceivedMessage = lastReceivedMessage;
    }
}

