/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound.level;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import com.nukkitx.math.vector.Vector3i;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;

public class ClientboundExplodePacket
implements MinecraftPacket {
    private final float x;
    private final float y;
    private final float z;
    private final float radius;
    @NonNull
    private final List<Vector3i> exploded;
    private final float pushX;
    private final float pushY;
    private final float pushZ;

    public ClientboundExplodePacket(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        this.x = in.readFloat();
        this.y = in.readFloat();
        this.z = in.readFloat();
        this.radius = in.readFloat();
        this.exploded = new ArrayList<Vector3i>();
        int length = helper.readVarInt(in);
        for (int count = 0; count < length; ++count) {
            this.exploded.add(Vector3i.from(in.readByte(), in.readByte(), in.readByte()));
        }
        this.pushX = in.readFloat();
        this.pushY = in.readFloat();
        this.pushZ = in.readFloat();
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        out.writeFloat(this.x);
        out.writeFloat(this.y);
        out.writeFloat(this.z);
        out.writeFloat(this.radius);
        helper.writeVarInt(out, this.exploded.size());
        for (Vector3i record : this.exploded) {
            out.writeByte(record.getX());
            out.writeByte(record.getY());
            out.writeByte(record.getZ());
        }
        out.writeFloat(this.pushX);
        out.writeFloat(this.pushY);
        out.writeFloat(this.pushZ);
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getZ() {
        return this.z;
    }

    public float getRadius() {
        return this.radius;
    }

    @NonNull
    public List<Vector3i> getExploded() {
        return this.exploded;
    }

    public float getPushX() {
        return this.pushX;
    }

    public float getPushY() {
        return this.pushY;
    }

    public float getPushZ() {
        return this.pushZ;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundExplodePacket)) {
            return false;
        }
        ClientboundExplodePacket other = (ClientboundExplodePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getX(), other.getX()) != 0) {
            return false;
        }
        if (Float.compare(this.getY(), other.getY()) != 0) {
            return false;
        }
        if (Float.compare(this.getZ(), other.getZ()) != 0) {
            return false;
        }
        if (Float.compare(this.getRadius(), other.getRadius()) != 0) {
            return false;
        }
        if (Float.compare(this.getPushX(), other.getPushX()) != 0) {
            return false;
        }
        if (Float.compare(this.getPushY(), other.getPushY()) != 0) {
            return false;
        }
        if (Float.compare(this.getPushZ(), other.getPushZ()) != 0) {
            return false;
        }
        List<Vector3i> this$exploded = this.getExploded();
        List<Vector3i> other$exploded = other.getExploded();
        return !(this$exploded == null ? other$exploded != null : !((Object)this$exploded).equals(other$exploded));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundExplodePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getX());
        result = result * 59 + Float.floatToIntBits(this.getY());
        result = result * 59 + Float.floatToIntBits(this.getZ());
        result = result * 59 + Float.floatToIntBits(this.getRadius());
        result = result * 59 + Float.floatToIntBits(this.getPushX());
        result = result * 59 + Float.floatToIntBits(this.getPushY());
        result = result * 59 + Float.floatToIntBits(this.getPushZ());
        List<Vector3i> $exploded = this.getExploded();
        result = result * 59 + ($exploded == null ? 43 : ((Object)$exploded).hashCode());
        return result;
    }

    public String toString() {
        return "ClientboundExplodePacket(x=" + this.getX() + ", y=" + this.getY() + ", z=" + this.getZ() + ", radius=" + this.getRadius() + ", exploded=" + this.getExploded() + ", pushX=" + this.getPushX() + ", pushY=" + this.getPushY() + ", pushZ=" + this.getPushZ() + ")";
    }

    public ClientboundExplodePacket withX(float x) {
        return this.x == x ? this : new ClientboundExplodePacket(x, this.y, this.z, this.radius, this.exploded, this.pushX, this.pushY, this.pushZ);
    }

    public ClientboundExplodePacket withY(float y) {
        return this.y == y ? this : new ClientboundExplodePacket(this.x, y, this.z, this.radius, this.exploded, this.pushX, this.pushY, this.pushZ);
    }

    public ClientboundExplodePacket withZ(float z) {
        return this.z == z ? this : new ClientboundExplodePacket(this.x, this.y, z, this.radius, this.exploded, this.pushX, this.pushY, this.pushZ);
    }

    public ClientboundExplodePacket withRadius(float radius) {
        return this.radius == radius ? this : new ClientboundExplodePacket(this.x, this.y, this.z, radius, this.exploded, this.pushX, this.pushY, this.pushZ);
    }

    public ClientboundExplodePacket withExploded(@NonNull List<Vector3i> exploded) {
        if (exploded == null) {
            throw new NullPointerException("exploded is marked non-null but is null");
        }
        return this.exploded == exploded ? this : new ClientboundExplodePacket(this.x, this.y, this.z, this.radius, exploded, this.pushX, this.pushY, this.pushZ);
    }

    public ClientboundExplodePacket withPushX(float pushX) {
        return this.pushX == pushX ? this : new ClientboundExplodePacket(this.x, this.y, this.z, this.radius, this.exploded, pushX, this.pushY, this.pushZ);
    }

    public ClientboundExplodePacket withPushY(float pushY) {
        return this.pushY == pushY ? this : new ClientboundExplodePacket(this.x, this.y, this.z, this.radius, this.exploded, this.pushX, pushY, this.pushZ);
    }

    public ClientboundExplodePacket withPushZ(float pushZ) {
        return this.pushZ == pushZ ? this : new ClientboundExplodePacket(this.x, this.y, this.z, this.radius, this.exploded, this.pushX, this.pushY, pushZ);
    }

    public ClientboundExplodePacket(float x, float y, float z, float radius, @NonNull List<Vector3i> exploded, float pushX, float pushY, float pushZ) {
        if (exploded == null) {
            throw new NullPointerException("exploded is marked non-null but is null");
        }
        this.x = x;
        this.y = y;
        this.z = z;
        this.radius = radius;
        this.exploded = exploded;
        this.pushX = pushX;
        this.pushY = pushY;
        this.pushZ = pushZ;
    }
}

