/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound.level;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import com.github.steveice10.mc.protocol.data.game.level.block.BlockChangeEntry;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import lombok.NonNull;

public class ClientboundBlockUpdatePacket
implements MinecraftPacket {
    @NonNull
    private final BlockChangeEntry entry;

    public ClientboundBlockUpdatePacket(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        this.entry = new BlockChangeEntry(helper.readPosition(in), helper.readVarInt(in));
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        helper.writePosition(out, this.entry.getPosition());
        helper.writeVarInt(out, this.entry.getBlock());
    }

    @NonNull
    public BlockChangeEntry getEntry() {
        return this.entry;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundBlockUpdatePacket)) {
            return false;
        }
        ClientboundBlockUpdatePacket other = (ClientboundBlockUpdatePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BlockChangeEntry this$entry = this.getEntry();
        BlockChangeEntry other$entry = other.getEntry();
        return !(this$entry == null ? other$entry != null : !((Object)this$entry).equals(other$entry));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundBlockUpdatePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BlockChangeEntry $entry = this.getEntry();
        result = result * 59 + ($entry == null ? 43 : ((Object)$entry).hashCode());
        return result;
    }

    public String toString() {
        return "ClientboundBlockUpdatePacket(entry=" + this.getEntry() + ")";
    }

    public ClientboundBlockUpdatePacket withEntry(@NonNull BlockChangeEntry entry) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        return this.entry == entry ? this : new ClientboundBlockUpdatePacket(entry);
    }

    public ClientboundBlockUpdatePacket(@NonNull BlockChangeEntry entry) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        this.entry = entry;
    }
}

