/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound.entity;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import com.github.steveice10.mc.protocol.data.game.entity.Effect;
import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public class ClientboundUpdateMobEffectPacket
implements MinecraftPacket {
    private static final int FLAG_AMBIENT = 1;
    private static final int FLAG_SHOW_PARTICLES = 2;
    private final int entityId;
    @NonNull
    private final Effect effect;
    private final int amplifier;
    private final int duration;
    private final boolean ambient;
    private final boolean showParticles;
    @Nullable
    private final CompoundTag factorData;

    public ClientboundUpdateMobEffectPacket(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        this.entityId = helper.readVarInt(in);
        this.effect = helper.readEffect(in);
        this.amplifier = in.readByte();
        this.duration = helper.readVarInt(in);
        byte flags = in.readByte();
        this.ambient = (flags & 1) != 0;
        this.showParticles = (flags & 2) != 0;
        this.factorData = in.readBoolean() ? helper.readTag(in) : null;
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        helper.writeVarInt(out, this.entityId);
        helper.writeEffect(out, this.effect);
        out.writeByte(this.amplifier);
        helper.writeVarInt(out, this.duration);
        int flags = 0;
        if (this.ambient) {
            flags |= 1;
        }
        if (this.showParticles) {
            flags |= 2;
        }
        out.writeByte(flags);
        out.writeBoolean(this.factorData != null);
        if (this.factorData != null) {
            helper.writeTag(out, this.factorData);
        }
    }

    public int getEntityId() {
        return this.entityId;
    }

    @NonNull
    public Effect getEffect() {
        return this.effect;
    }

    public int getAmplifier() {
        return this.amplifier;
    }

    public int getDuration() {
        return this.duration;
    }

    public boolean isAmbient() {
        return this.ambient;
    }

    public boolean isShowParticles() {
        return this.showParticles;
    }

    @Nullable
    public CompoundTag getFactorData() {
        return this.factorData;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundUpdateMobEffectPacket)) {
            return false;
        }
        ClientboundUpdateMobEffectPacket other = (ClientboundUpdateMobEffectPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEntityId() != other.getEntityId()) {
            return false;
        }
        if (this.getAmplifier() != other.getAmplifier()) {
            return false;
        }
        if (this.getDuration() != other.getDuration()) {
            return false;
        }
        if (this.isAmbient() != other.isAmbient()) {
            return false;
        }
        if (this.isShowParticles() != other.isShowParticles()) {
            return false;
        }
        Effect this$effect = this.getEffect();
        Effect other$effect = other.getEffect();
        if (this$effect == null ? other$effect != null : !((Object)((Object)this$effect)).equals((Object)other$effect)) {
            return false;
        }
        CompoundTag this$factorData = this.getFactorData();
        CompoundTag other$factorData = other.getFactorData();
        return !(this$factorData == null ? other$factorData != null : !((Object)this$factorData).equals(other$factorData));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundUpdateMobEffectPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEntityId();
        result = result * 59 + this.getAmplifier();
        result = result * 59 + this.getDuration();
        result = result * 59 + (this.isAmbient() ? 79 : 97);
        result = result * 59 + (this.isShowParticles() ? 79 : 97);
        Effect $effect = this.getEffect();
        result = result * 59 + ($effect == null ? 43 : ((Object)((Object)$effect)).hashCode());
        CompoundTag $factorData = this.getFactorData();
        result = result * 59 + ($factorData == null ? 43 : $factorData.hashCode());
        return result;
    }

    public String toString() {
        return "ClientboundUpdateMobEffectPacket(entityId=" + this.getEntityId() + ", effect=" + (Object)((Object)this.getEffect()) + ", amplifier=" + this.getAmplifier() + ", duration=" + this.getDuration() + ", ambient=" + this.isAmbient() + ", showParticles=" + this.isShowParticles() + ", factorData=" + this.getFactorData() + ")";
    }

    public ClientboundUpdateMobEffectPacket withEntityId(int entityId) {
        return this.entityId == entityId ? this : new ClientboundUpdateMobEffectPacket(entityId, this.effect, this.amplifier, this.duration, this.ambient, this.showParticles, this.factorData);
    }

    public ClientboundUpdateMobEffectPacket withEffect(@NonNull Effect effect) {
        if (effect == null) {
            throw new NullPointerException("effect is marked non-null but is null");
        }
        return this.effect == effect ? this : new ClientboundUpdateMobEffectPacket(this.entityId, effect, this.amplifier, this.duration, this.ambient, this.showParticles, this.factorData);
    }

    public ClientboundUpdateMobEffectPacket withAmplifier(int amplifier) {
        return this.amplifier == amplifier ? this : new ClientboundUpdateMobEffectPacket(this.entityId, this.effect, amplifier, this.duration, this.ambient, this.showParticles, this.factorData);
    }

    public ClientboundUpdateMobEffectPacket withDuration(int duration) {
        return this.duration == duration ? this : new ClientboundUpdateMobEffectPacket(this.entityId, this.effect, this.amplifier, duration, this.ambient, this.showParticles, this.factorData);
    }

    public ClientboundUpdateMobEffectPacket withAmbient(boolean ambient) {
        return this.ambient == ambient ? this : new ClientboundUpdateMobEffectPacket(this.entityId, this.effect, this.amplifier, this.duration, ambient, this.showParticles, this.factorData);
    }

    public ClientboundUpdateMobEffectPacket withShowParticles(boolean showParticles) {
        return this.showParticles == showParticles ? this : new ClientboundUpdateMobEffectPacket(this.entityId, this.effect, this.amplifier, this.duration, this.ambient, showParticles, this.factorData);
    }

    public ClientboundUpdateMobEffectPacket withFactorData(@Nullable CompoundTag factorData) {
        return this.factorData == factorData ? this : new ClientboundUpdateMobEffectPacket(this.entityId, this.effect, this.amplifier, this.duration, this.ambient, this.showParticles, factorData);
    }

    public ClientboundUpdateMobEffectPacket(int entityId, @NonNull Effect effect, int amplifier, int duration, boolean ambient, boolean showParticles, @Nullable CompoundTag factorData) {
        if (effect == null) {
            throw new NullPointerException("effect is marked non-null but is null");
        }
        this.entityId = entityId;
        this.effect = effect;
        this.amplifier = amplifier;
        this.duration = duration;
        this.ambient = ambient;
        this.showParticles = showParticles;
        this.factorData = factorData;
    }
}

