/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import com.github.steveice10.mc.protocol.data.game.level.sound.BuiltinSound;
import com.github.steveice10.mc.protocol.data.game.level.sound.SoundCategory;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import lombok.NonNull;

public class ClientboundSoundEntityPacket
implements MinecraftPacket {
    @NonNull
    private final BuiltinSound sound;
    @NonNull
    private final SoundCategory category;
    private final int entityId;
    private final float volume;
    private final float pitch;
    private final long seed;

    public ClientboundSoundEntityPacket(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        this.sound = helper.readBuiltinSound(in);
        this.category = helper.readSoundCategory(in);
        this.entityId = helper.readVarInt(in);
        this.volume = in.readFloat();
        this.pitch = in.readFloat();
        this.seed = in.readLong();
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        helper.writeBuiltinSound(out, this.sound);
        helper.writeSoundCategory(out, this.category);
        helper.writeVarInt(out, this.entityId);
        out.writeFloat(this.volume);
        out.writeFloat(this.pitch);
        out.writeLong(this.seed);
    }

    @NonNull
    public BuiltinSound getSound() {
        return this.sound;
    }

    @NonNull
    public SoundCategory getCategory() {
        return this.category;
    }

    public int getEntityId() {
        return this.entityId;
    }

    public float getVolume() {
        return this.volume;
    }

    public float getPitch() {
        return this.pitch;
    }

    public long getSeed() {
        return this.seed;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundSoundEntityPacket)) {
            return false;
        }
        ClientboundSoundEntityPacket other = (ClientboundSoundEntityPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEntityId() != other.getEntityId()) {
            return false;
        }
        if (Float.compare(this.getVolume(), other.getVolume()) != 0) {
            return false;
        }
        if (Float.compare(this.getPitch(), other.getPitch()) != 0) {
            return false;
        }
        if (this.getSeed() != other.getSeed()) {
            return false;
        }
        BuiltinSound this$sound = this.getSound();
        BuiltinSound other$sound = other.getSound();
        if (this$sound == null ? other$sound != null : !this$sound.equals(other$sound)) {
            return false;
        }
        SoundCategory this$category = this.getCategory();
        SoundCategory other$category = other.getCategory();
        return !(this$category == null ? other$category != null : !((Object)((Object)this$category)).equals((Object)other$category));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundSoundEntityPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEntityId();
        result = result * 59 + Float.floatToIntBits(this.getVolume());
        result = result * 59 + Float.floatToIntBits(this.getPitch());
        long $seed = this.getSeed();
        result = result * 59 + (int)($seed >>> 32 ^ $seed);
        BuiltinSound $sound = this.getSound();
        result = result * 59 + ($sound == null ? 43 : $sound.hashCode());
        SoundCategory $category = this.getCategory();
        result = result * 59 + ($category == null ? 43 : ((Object)((Object)$category)).hashCode());
        return result;
    }

    public String toString() {
        return "ClientboundSoundEntityPacket(sound=" + this.getSound() + ", category=" + (Object)((Object)this.getCategory()) + ", entityId=" + this.getEntityId() + ", volume=" + this.getVolume() + ", pitch=" + this.getPitch() + ", seed=" + this.getSeed() + ")";
    }

    public ClientboundSoundEntityPacket withSound(@NonNull BuiltinSound sound) {
        if (sound == null) {
            throw new NullPointerException("sound is marked non-null but is null");
        }
        return this.sound == sound ? this : new ClientboundSoundEntityPacket(sound, this.category, this.entityId, this.volume, this.pitch, this.seed);
    }

    public ClientboundSoundEntityPacket withCategory(@NonNull SoundCategory category) {
        if (category == null) {
            throw new NullPointerException("category is marked non-null but is null");
        }
        return this.category == category ? this : new ClientboundSoundEntityPacket(this.sound, category, this.entityId, this.volume, this.pitch, this.seed);
    }

    public ClientboundSoundEntityPacket withEntityId(int entityId) {
        return this.entityId == entityId ? this : new ClientboundSoundEntityPacket(this.sound, this.category, entityId, this.volume, this.pitch, this.seed);
    }

    public ClientboundSoundEntityPacket withVolume(float volume) {
        return this.volume == volume ? this : new ClientboundSoundEntityPacket(this.sound, this.category, this.entityId, volume, this.pitch, this.seed);
    }

    public ClientboundSoundEntityPacket withPitch(float pitch) {
        return this.pitch == pitch ? this : new ClientboundSoundEntityPacket(this.sound, this.category, this.entityId, this.volume, pitch, this.seed);
    }

    public ClientboundSoundEntityPacket withSeed(long seed) {
        return this.seed == seed ? this : new ClientboundSoundEntityPacket(this.sound, this.category, this.entityId, this.volume, this.pitch, seed);
    }

    public ClientboundSoundEntityPacket(@NonNull BuiltinSound sound, @NonNull SoundCategory category, int entityId, float volume, float pitch, long seed) {
        if (sound == null) {
            throw new NullPointerException("sound is marked non-null but is null");
        }
        if (category == null) {
            throw new NullPointerException("category is marked non-null but is null");
        }
        this.sound = sound;
        this.category = category;
        this.entityId = entityId;
        this.volume = volume;
        this.pitch = pitch;
        this.seed = seed;
    }
}

