/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import com.github.steveice10.mc.protocol.data.game.ChatFilterType;
import com.github.steveice10.mc.protocol.data.game.LastSeenMessage;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.UUID;
import org.geysermc.relocate.kyori.adventure.text.Component;
import org.jetbrains.annotations.Nullable;

public class ClientboundPlayerChatPacket
implements MinecraftPacket {
    private final byte @Nullable [] previousSignature;
    private final UUID sender;
    private final byte[] headerSignature;
    private final String messagePlain;
    private final Component messageDecorated;
    private final long timeStamp;
    private final long salt;
    private final List<LastSeenMessage> lastSeenMessages;
    @Nullable
    private final Component unsignedContent;
    private final BitSet filterMask;
    private final ChatFilterType filterType;
    private final int chatType;
    private final Component name;
    @Nullable
    private final Component targetName;

    public ClientboundPlayerChatPacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.previousSignature = (byte[])(in.readBoolean() ? helper.readByteArray(in) : null);
        this.sender = helper.readUUID(in);
        this.headerSignature = helper.readByteArray(in);
        this.messagePlain = helper.readString(in);
        this.messageDecorated = in.readBoolean() ? helper.readComponent(in) : Component.text(this.messagePlain);
        this.timeStamp = in.readLong();
        this.salt = in.readLong();
        this.lastSeenMessages = new ArrayList<LastSeenMessage>();
        int seenMessageCount = Math.min(helper.readVarInt(in), 5);
        for (int i = 0; i < seenMessageCount; ++i) {
            this.lastSeenMessages.add(new LastSeenMessage(helper.readUUID(in), helper.readByteArray(in)));
        }
        this.unsignedContent = in.readBoolean() ? helper.readComponent(in) : null;
        this.filterType = ChatFilterType.from(helper.readVarInt(in));
        this.filterMask = this.filterType == ChatFilterType.PARTIALLY_FILTERED ? BitSet.valueOf(helper.readLongArray(in)) : new BitSet(0);
        this.chatType = helper.readVarInt(in);
        this.name = helper.readComponent(in);
        this.targetName = in.readBoolean() ? helper.readComponent(in) : null;
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        if (this.previousSignature != null) {
            out.writeBoolean(true);
            helper.writeVarInt(out, this.previousSignature.length);
            out.writeBytes(this.previousSignature);
        } else {
            out.writeBoolean(false);
        }
        helper.writeUUID(out, this.sender);
        helper.writeVarInt(out, this.headerSignature.length);
        out.writeBytes(this.headerSignature);
        helper.writeString(out, this.messagePlain);
        if (!this.messageDecorated.equals(Component.text(this.messagePlain))) {
            out.writeBoolean(true);
            helper.writeComponent(out, this.messageDecorated);
        } else {
            out.writeBoolean(false);
        }
        out.writeLong(this.timeStamp);
        out.writeLong(this.salt);
        helper.writeVarInt(out, this.lastSeenMessages.size());
        for (LastSeenMessage entry : this.lastSeenMessages) {
            helper.writeUUID(out, entry.getProfileId());
            helper.writeVarInt(out, entry.getLastSignature().length);
            out.writeBytes(entry.getLastSignature());
        }
        if (this.unsignedContent != null) {
            out.writeBoolean(true);
            helper.writeComponent(out, this.unsignedContent);
        } else {
            out.writeBoolean(false);
        }
        helper.writeVarInt(out, this.filterType.ordinal());
        if (this.filterType == ChatFilterType.PARTIALLY_FILTERED) {
            helper.writeLongArray(out, this.filterMask.toLongArray());
        }
        helper.writeVarInt(out, this.chatType);
        helper.writeComponent(out, this.name);
        if (this.targetName != null) {
            out.writeBoolean(true);
            helper.writeComponent(out, this.targetName);
        } else {
            out.writeBoolean(false);
        }
    }

    public byte @Nullable [] getPreviousSignature() {
        return this.previousSignature;
    }

    public UUID getSender() {
        return this.sender;
    }

    public byte[] getHeaderSignature() {
        return this.headerSignature;
    }

    public String getMessagePlain() {
        return this.messagePlain;
    }

    public Component getMessageDecorated() {
        return this.messageDecorated;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public long getSalt() {
        return this.salt;
    }

    public List<LastSeenMessage> getLastSeenMessages() {
        return this.lastSeenMessages;
    }

    @Nullable
    public Component getUnsignedContent() {
        return this.unsignedContent;
    }

    public BitSet getFilterMask() {
        return this.filterMask;
    }

    public ChatFilterType getFilterType() {
        return this.filterType;
    }

    public int getChatType() {
        return this.chatType;
    }

    public Component getName() {
        return this.name;
    }

    @Nullable
    public Component getTargetName() {
        return this.targetName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundPlayerChatPacket)) {
            return false;
        }
        ClientboundPlayerChatPacket other = (ClientboundPlayerChatPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTimeStamp() != other.getTimeStamp()) {
            return false;
        }
        if (this.getSalt() != other.getSalt()) {
            return false;
        }
        if (this.getChatType() != other.getChatType()) {
            return false;
        }
        if (!Arrays.equals(this.getPreviousSignature(), other.getPreviousSignature())) {
            return false;
        }
        UUID this$sender = this.getSender();
        UUID other$sender = other.getSender();
        if (this$sender == null ? other$sender != null : !((Object)this$sender).equals(other$sender)) {
            return false;
        }
        if (!Arrays.equals(this.getHeaderSignature(), other.getHeaderSignature())) {
            return false;
        }
        String this$messagePlain = this.getMessagePlain();
        String other$messagePlain = other.getMessagePlain();
        if (this$messagePlain == null ? other$messagePlain != null : !this$messagePlain.equals(other$messagePlain)) {
            return false;
        }
        Component this$messageDecorated = this.getMessageDecorated();
        Component other$messageDecorated = other.getMessageDecorated();
        if (this$messageDecorated == null ? other$messageDecorated != null : !this$messageDecorated.equals(other$messageDecorated)) {
            return false;
        }
        List<LastSeenMessage> this$lastSeenMessages = this.getLastSeenMessages();
        List<LastSeenMessage> other$lastSeenMessages = other.getLastSeenMessages();
        if (this$lastSeenMessages == null ? other$lastSeenMessages != null : !((Object)this$lastSeenMessages).equals(other$lastSeenMessages)) {
            return false;
        }
        Component this$unsignedContent = this.getUnsignedContent();
        Component other$unsignedContent = other.getUnsignedContent();
        if (this$unsignedContent == null ? other$unsignedContent != null : !this$unsignedContent.equals(other$unsignedContent)) {
            return false;
        }
        BitSet this$filterMask = this.getFilterMask();
        BitSet other$filterMask = other.getFilterMask();
        if (this$filterMask == null ? other$filterMask != null : !((Object)this$filterMask).equals(other$filterMask)) {
            return false;
        }
        ChatFilterType this$filterType = this.getFilterType();
        ChatFilterType other$filterType = other.getFilterType();
        if (this$filterType == null ? other$filterType != null : !((Object)((Object)this$filterType)).equals((Object)other$filterType)) {
            return false;
        }
        Component this$name = this.getName();
        Component other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Component this$targetName = this.getTargetName();
        Component other$targetName = other.getTargetName();
        return !(this$targetName == null ? other$targetName != null : !this$targetName.equals(other$targetName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundPlayerChatPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $timeStamp = this.getTimeStamp();
        result = result * 59 + (int)($timeStamp >>> 32 ^ $timeStamp);
        long $salt = this.getSalt();
        result = result * 59 + (int)($salt >>> 32 ^ $salt);
        result = result * 59 + this.getChatType();
        result = result * 59 + Arrays.hashCode(this.getPreviousSignature());
        UUID $sender = this.getSender();
        result = result * 59 + ($sender == null ? 43 : ((Object)$sender).hashCode());
        result = result * 59 + Arrays.hashCode(this.getHeaderSignature());
        String $messagePlain = this.getMessagePlain();
        result = result * 59 + ($messagePlain == null ? 43 : $messagePlain.hashCode());
        Component $messageDecorated = this.getMessageDecorated();
        result = result * 59 + ($messageDecorated == null ? 43 : $messageDecorated.hashCode());
        List<LastSeenMessage> $lastSeenMessages = this.getLastSeenMessages();
        result = result * 59 + ($lastSeenMessages == null ? 43 : ((Object)$lastSeenMessages).hashCode());
        Component $unsignedContent = this.getUnsignedContent();
        result = result * 59 + ($unsignedContent == null ? 43 : $unsignedContent.hashCode());
        BitSet $filterMask = this.getFilterMask();
        result = result * 59 + ($filterMask == null ? 43 : ((Object)$filterMask).hashCode());
        ChatFilterType $filterType = this.getFilterType();
        result = result * 59 + ($filterType == null ? 43 : ((Object)((Object)$filterType)).hashCode());
        Component $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Component $targetName = this.getTargetName();
        result = result * 59 + ($targetName == null ? 43 : $targetName.hashCode());
        return result;
    }

    public String toString() {
        return "ClientboundPlayerChatPacket(previousSignature=" + this.getPreviousSignature() + ", sender=" + this.getSender() + ", headerSignature=" + Arrays.toString(this.getHeaderSignature()) + ", messagePlain=" + this.getMessagePlain() + ", messageDecorated=" + this.getMessageDecorated() + ", timeStamp=" + this.getTimeStamp() + ", salt=" + this.getSalt() + ", lastSeenMessages=" + this.getLastSeenMessages() + ", unsignedContent=" + this.getUnsignedContent() + ", filterMask=" + this.getFilterMask() + ", filterType=" + (Object)((Object)this.getFilterType()) + ", chatType=" + this.getChatType() + ", name=" + this.getName() + ", targetName=" + this.getTargetName() + ")";
    }

    public ClientboundPlayerChatPacket withPreviousSignature(byte @Nullable [] previousSignature) {
        return this.previousSignature == previousSignature ? this : new ClientboundPlayerChatPacket(previousSignature, this.sender, this.headerSignature, this.messagePlain, this.messageDecorated, this.timeStamp, this.salt, this.lastSeenMessages, this.unsignedContent, this.filterMask, this.filterType, this.chatType, this.name, this.targetName);
    }

    public ClientboundPlayerChatPacket withSender(UUID sender) {
        return this.sender == sender ? this : new ClientboundPlayerChatPacket(this.previousSignature, sender, this.headerSignature, this.messagePlain, this.messageDecorated, this.timeStamp, this.salt, this.lastSeenMessages, this.unsignedContent, this.filterMask, this.filterType, this.chatType, this.name, this.targetName);
    }

    public ClientboundPlayerChatPacket withHeaderSignature(byte[] headerSignature) {
        return this.headerSignature == headerSignature ? this : new ClientboundPlayerChatPacket(this.previousSignature, this.sender, headerSignature, this.messagePlain, this.messageDecorated, this.timeStamp, this.salt, this.lastSeenMessages, this.unsignedContent, this.filterMask, this.filterType, this.chatType, this.name, this.targetName);
    }

    public ClientboundPlayerChatPacket withMessagePlain(String messagePlain) {
        return this.messagePlain == messagePlain ? this : new ClientboundPlayerChatPacket(this.previousSignature, this.sender, this.headerSignature, messagePlain, this.messageDecorated, this.timeStamp, this.salt, this.lastSeenMessages, this.unsignedContent, this.filterMask, this.filterType, this.chatType, this.name, this.targetName);
    }

    public ClientboundPlayerChatPacket withMessageDecorated(Component messageDecorated) {
        return this.messageDecorated == messageDecorated ? this : new ClientboundPlayerChatPacket(this.previousSignature, this.sender, this.headerSignature, this.messagePlain, messageDecorated, this.timeStamp, this.salt, this.lastSeenMessages, this.unsignedContent, this.filterMask, this.filterType, this.chatType, this.name, this.targetName);
    }

    public ClientboundPlayerChatPacket withTimeStamp(long timeStamp) {
        return this.timeStamp == timeStamp ? this : new ClientboundPlayerChatPacket(this.previousSignature, this.sender, this.headerSignature, this.messagePlain, this.messageDecorated, timeStamp, this.salt, this.lastSeenMessages, this.unsignedContent, this.filterMask, this.filterType, this.chatType, this.name, this.targetName);
    }

    public ClientboundPlayerChatPacket withSalt(long salt) {
        return this.salt == salt ? this : new ClientboundPlayerChatPacket(this.previousSignature, this.sender, this.headerSignature, this.messagePlain, this.messageDecorated, this.timeStamp, salt, this.lastSeenMessages, this.unsignedContent, this.filterMask, this.filterType, this.chatType, this.name, this.targetName);
    }

    public ClientboundPlayerChatPacket withLastSeenMessages(List<LastSeenMessage> lastSeenMessages) {
        return this.lastSeenMessages == lastSeenMessages ? this : new ClientboundPlayerChatPacket(this.previousSignature, this.sender, this.headerSignature, this.messagePlain, this.messageDecorated, this.timeStamp, this.salt, lastSeenMessages, this.unsignedContent, this.filterMask, this.filterType, this.chatType, this.name, this.targetName);
    }

    public ClientboundPlayerChatPacket withUnsignedContent(@Nullable Component unsignedContent) {
        return this.unsignedContent == unsignedContent ? this : new ClientboundPlayerChatPacket(this.previousSignature, this.sender, this.headerSignature, this.messagePlain, this.messageDecorated, this.timeStamp, this.salt, this.lastSeenMessages, unsignedContent, this.filterMask, this.filterType, this.chatType, this.name, this.targetName);
    }

    public ClientboundPlayerChatPacket withFilterMask(BitSet filterMask) {
        return this.filterMask == filterMask ? this : new ClientboundPlayerChatPacket(this.previousSignature, this.sender, this.headerSignature, this.messagePlain, this.messageDecorated, this.timeStamp, this.salt, this.lastSeenMessages, this.unsignedContent, filterMask, this.filterType, this.chatType, this.name, this.targetName);
    }

    public ClientboundPlayerChatPacket withFilterType(ChatFilterType filterType) {
        return this.filterType == filterType ? this : new ClientboundPlayerChatPacket(this.previousSignature, this.sender, this.headerSignature, this.messagePlain, this.messageDecorated, this.timeStamp, this.salt, this.lastSeenMessages, this.unsignedContent, this.filterMask, filterType, this.chatType, this.name, this.targetName);
    }

    public ClientboundPlayerChatPacket withChatType(int chatType) {
        return this.chatType == chatType ? this : new ClientboundPlayerChatPacket(this.previousSignature, this.sender, this.headerSignature, this.messagePlain, this.messageDecorated, this.timeStamp, this.salt, this.lastSeenMessages, this.unsignedContent, this.filterMask, this.filterType, chatType, this.name, this.targetName);
    }

    public ClientboundPlayerChatPacket withName(Component name) {
        return this.name == name ? this : new ClientboundPlayerChatPacket(this.previousSignature, this.sender, this.headerSignature, this.messagePlain, this.messageDecorated, this.timeStamp, this.salt, this.lastSeenMessages, this.unsignedContent, this.filterMask, this.filterType, this.chatType, name, this.targetName);
    }

    public ClientboundPlayerChatPacket withTargetName(@Nullable Component targetName) {
        return this.targetName == targetName ? this : new ClientboundPlayerChatPacket(this.previousSignature, this.sender, this.headerSignature, this.messagePlain, this.messageDecorated, this.timeStamp, this.salt, this.lastSeenMessages, this.unsignedContent, this.filterMask, this.filterType, this.chatType, this.name, targetName);
    }

    public ClientboundPlayerChatPacket(byte @Nullable [] previousSignature, UUID sender, byte[] headerSignature, String messagePlain, Component messageDecorated, long timeStamp, long salt, List<LastSeenMessage> lastSeenMessages, @Nullable Component unsignedContent, BitSet filterMask, ChatFilterType filterType, int chatType, Component name, @Nullable Component targetName) {
        this.previousSignature = previousSignature;
        this.sender = sender;
        this.headerSignature = headerSignature;
        this.messagePlain = messagePlain;
        this.messageDecorated = messageDecorated;
        this.timeStamp = timeStamp;
        this.salt = salt;
        this.lastSeenMessages = lastSeenMessages;
        this.unsignedContent = unsignedContent;
        this.filterMask = filterMask;
        this.filterType = filterType;
        this.chatType = chatType;
        this.name = name;
        this.targetName = targetName;
    }
}

