/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import com.github.steveice10.mc.protocol.data.game.ChatCompletionAction;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;

public class ClientboundCustomChatCompletionsPacket
implements MinecraftPacket {
    private final ChatCompletionAction action;
    private final String[] entries;

    public ClientboundCustomChatCompletionsPacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.action = ChatCompletionAction.from(helper.readVarInt(in));
        this.entries = new String[helper.readVarInt(in)];
        for (int i = 0; i < this.entries.length; ++i) {
            this.entries[i] = helper.readString(in);
        }
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        helper.writeVarInt(out, this.action.ordinal());
        helper.writeVarInt(out, this.entries.length);
        for (String entry : this.entries) {
            helper.writeString(out, entry);
        }
    }

    public ChatCompletionAction getAction() {
        return this.action;
    }

    public String[] getEntries() {
        return this.entries;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundCustomChatCompletionsPacket)) {
            return false;
        }
        ClientboundCustomChatCompletionsPacket other = (ClientboundCustomChatCompletionsPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ChatCompletionAction this$action = this.getAction();
        ChatCompletionAction other$action = other.getAction();
        if (this$action == null ? other$action != null : !((Object)((Object)this$action)).equals((Object)other$action)) {
            return false;
        }
        return Arrays.deepEquals(this.getEntries(), other.getEntries());
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundCustomChatCompletionsPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ChatCompletionAction $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : ((Object)((Object)$action)).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getEntries());
        return result;
    }

    public String toString() {
        return "ClientboundCustomChatCompletionsPacket(action=" + (Object)((Object)this.getAction()) + ", entries=" + Arrays.deepToString(this.getEntries()) + ")";
    }

    public ClientboundCustomChatCompletionsPacket withAction(ChatCompletionAction action) {
        return this.action == action ? this : new ClientboundCustomChatCompletionsPacket(action, this.entries);
    }

    public ClientboundCustomChatCompletionsPacket withEntries(String[] entries) {
        return this.entries == entries ? this : new ClientboundCustomChatCompletionsPacket(this.action, entries);
    }

    public ClientboundCustomChatCompletionsPacket(ChatCompletionAction action, String[] entries) {
        this.action = action;
        this.entries = entries;
    }
}

