/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import com.github.steveice10.mc.protocol.data.DefaultComponentSerializer;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import org.geysermc.relocate.kyori.adventure.text.Component;
import org.jetbrains.annotations.Nullable;

public class ClientboundChatPreviewPacket
implements MinecraftPacket {
    private final int queryId;
    @Nullable
    private final Component preview;

    public ClientboundChatPreviewPacket(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        this.queryId = in.readInt();
        this.preview = in.readBoolean() ? helper.readComponent(in) : null;
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        out.writeInt(this.queryId);
        out.writeBoolean(this.preview != null);
        if (this.preview != null) {
            helper.writeString(out, (String)DefaultComponentSerializer.get().serialize(this.preview));
        }
    }

    public int getQueryId() {
        return this.queryId;
    }

    @Nullable
    public Component getPreview() {
        return this.preview;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundChatPreviewPacket)) {
            return false;
        }
        ClientboundChatPreviewPacket other = (ClientboundChatPreviewPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getQueryId() != other.getQueryId()) {
            return false;
        }
        Component this$preview = this.getPreview();
        Component other$preview = other.getPreview();
        return !(this$preview == null ? other$preview != null : !this$preview.equals(other$preview));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundChatPreviewPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getQueryId();
        Component $preview = this.getPreview();
        result = result * 59 + ($preview == null ? 43 : $preview.hashCode());
        return result;
    }

    public String toString() {
        return "ClientboundChatPreviewPacket(queryId=" + this.getQueryId() + ", preview=" + this.getPreview() + ")";
    }

    public ClientboundChatPreviewPacket withQueryId(int queryId) {
        return this.queryId == queryId ? this : new ClientboundChatPreviewPacket(queryId, this.preview);
    }

    public ClientboundChatPreviewPacket withPreview(@Nullable Component preview) {
        return this.preview == preview ? this : new ClientboundChatPreviewPacket(this.queryId, preview);
    }

    public ClientboundChatPreviewPacket(int queryId, @Nullable Component preview) {
        this.queryId = queryId;
        this.preview = preview;
    }
}

