/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.data.game.entity.attribute;

import java.util.HashMap;
import java.util.Map;

public interface AttributeType {
    public String getIdentifier();

    public static enum Builtin implements AttributeType
    {
        GENERIC_MAX_HEALTH("minecraft:generic.max_health", 20.0, 0.0, 1024.0),
        GENERIC_FOLLOW_RANGE("minecraft:generic.follow_range", 32.0, 0.0, 2048.0),
        GENERIC_KNOCKBACK_RESISTANCE("minecraft:generic.knockback_resistance", 0.0, 0.0, 1.0),
        GENERIC_MOVEMENT_SPEED("minecraft:generic.movement_speed", (double)0.7f, 0.0, 1024.0),
        GENERIC_ATTACK_DAMAGE("minecraft:generic.attack_damage", 2.0, 0.0, 2048.0),
        GENERIC_ATTACK_SPEED("minecraft:generic.attack_speed", 4.0, 0.0, 1024.0),
        GENERIC_FLYING_SPEED("minecraft:generic.flying_speed", (double)0.4f, 0.0, 1024.0),
        GENERIC_ARMOR("minecraft:generic.armor", 0.0, 0.0, 30.0),
        GENERIC_ARMOR_TOUGHNESS("minecraft:generic.armor_toughness", 0.0, 0.0, 20.0),
        GENERIC_ATTACK_KNOCKBACK("minecraft:generic.attack_knockback", 0.0, 0.0, 5.0),
        GENERIC_LUCK("minecraft:generic.luck", 0.0, -1024.0, 1024.0),
        HORSE_JUMP_STRENGTH("minecraft:horse.jump_strength", 0.7, 0.0, 2.0),
        ZOMBIE_SPAWN_REINFORCEMENTS("minecraft:zombie.spawn_reinforcements", 0.0, 0.0, 1.0);

        private final String identifier;
        private final double def;
        private final double min;
        private final double max;
        public static final Map<String, AttributeType> BUILTIN;

        private static void register(AttributeType attributeType) {
            BUILTIN.put(attributeType.getIdentifier(), attributeType);
        }

        @Override
        public String getIdentifier() {
            return this.identifier;
        }

        public double getDef() {
            return this.def;
        }

        public double getMin() {
            return this.min;
        }

        public double getMax() {
            return this.max;
        }

        private Builtin(String identifier, double def, double min2, double max) {
            this.identifier = identifier;
            this.def = def;
            this.min = min2;
            this.max = max;
        }

        static {
            BUILTIN = new HashMap<String, AttributeType>();
            Builtin.register(GENERIC_MAX_HEALTH);
            Builtin.register(GENERIC_FOLLOW_RANGE);
            Builtin.register(GENERIC_KNOCKBACK_RESISTANCE);
            Builtin.register(GENERIC_MOVEMENT_SPEED);
            Builtin.register(GENERIC_ATTACK_DAMAGE);
            Builtin.register(GENERIC_ATTACK_SPEED);
            Builtin.register(GENERIC_FLYING_SPEED);
            Builtin.register(GENERIC_ARMOR);
            Builtin.register(GENERIC_ARMOR_TOUGHNESS);
            Builtin.register(GENERIC_ATTACK_KNOCKBACK);
            Builtin.register(GENERIC_LUCK);
            Builtin.register(HORSE_JUMP_STRENGTH);
            Builtin.register(ZOMBIE_SPAWN_REINFORCEMENTS);
        }
    }

    public static class Custom
    implements AttributeType {
        private final String identifier;

        public Custom(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public String getIdentifier() {
            return this.identifier;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Custom)) {
                return false;
            }
            Custom other = (Custom)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$identifier = this.getIdentifier();
            String other$identifier = other.getIdentifier();
            return !(this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Custom;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $identifier = this.getIdentifier();
            result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
            return result;
        }
    }
}

