/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.util;

import org.geysermc.floodgate.api.logger.FloodgateLogger;
import org.geysermc.floodgate.config.FloodgateConfig;
import org.geysermc.floodgate.util.Utils;

public final class PrefixCheckTask {
    public static void checkAndExecuteDelayed(FloodgateConfig config, FloodgateLogger logger) {
        if (Utils.isUniquePrefix(config.getUsernamePrefix())) {
            return;
        }
        new Thread(() -> {
            try {
                Thread.sleep(config.isProxy() ? 1000L : 2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (config.getUsernamePrefix().isEmpty()) {
                logger.warn("\n**********************************\n* You specified an empty prefix in your Floodgate config for Bedrock players!\n* Should a Java player join and a Bedrock player join with the same username, unwanted results and conflicts will happen!\n* We strongly recommend using . as the prefix, but other alternatives that will not conflict include: +, - and *\n**********************************", new Object[0]);
                return;
            }
            logger.warn("\n**********************************\n* The prefix you entered in your Floodgate config ({}) could lead to username conflicts!\n* Should a Java player join with the username {}Notch, and a Bedrock player join as Notch (who will be given the name {}Notch), unwanted results will happen!\n* We strongly recommend using . as the prefix, but other alternatives that will not conflict include: +, - and *\n**********************************", config.getUsernamePrefix(), config.getUsernamePrefix(), config.getUsernamePrefix(), config.getUsernamePrefix());
        }).start();
    }
}

