/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.util;

import com.mojang.authlib.GameProfile;
import java.util.Collection;
import java.util.UUID;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3330;
import net.minecraft.class_3340;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.floodgate.MinecraftServerHolder;
import org.geysermc.floodgate.api.FloodgateApi;
import org.geysermc.floodgate.api.logger.FloodgateLogger;
import org.geysermc.floodgate.platform.command.CommandUtil;
import org.geysermc.floodgate.player.UserAudience;
import org.geysermc.floodgate.util.LanguageManager;

public final class FabricCommandUtil
extends CommandUtil {
    private final FloodgateLogger logger;
    private UserAudience console;

    public FabricCommandUtil(LanguageManager manager, FloodgateApi api, FloodgateLogger logger) {
        super(manager, api);
        this.logger = logger;
    }

    @Override
    public UserAudience getUserAudience(@NonNull Object sourceObj) {
        if (!(sourceObj instanceof class_2168)) {
            throw new IllegalArgumentException();
        }
        class_2168 stack = (class_2168)sourceObj;
        if (stack.method_9228() == null) {
            if (this.console != null) {
                return this.console;
            }
            this.console = new UserAudience.ConsoleAudience(stack, this);
            return this.console;
        }
        class_3222 player = stack.method_44023();
        return new UserAudience.PlayerAudience(player.method_5667(), player.method_7334().getName(), "en_US", stack, this, true);
    }

    @Override
    protected String getUsernameFromSource(@NonNull Object source) {
        return ((class_3222)source).method_7334().getName();
    }

    @Override
    protected UUID getUuidFromSource(@NonNull Object source) {
        return ((class_3222)source).method_5667();
    }

    @Override
    public Object getPlayerByUuid(@NonNull UUID uuid) {
        class_3222 player = MinecraftServerHolder.get().method_3760().method_14602(uuid);
        return player != null ? player : uuid;
    }

    @Override
    public Object getPlayerByUsername(@NonNull String username) {
        class_3222 player = MinecraftServerHolder.get().method_3760().method_14566(username);
        return player != null ? player : username;
    }

    @Override
    protected Collection<?> getOnlinePlayers() {
        return MinecraftServerHolder.get().method_3760().method_14571();
    }

    @Override
    public boolean hasPermission(Object player, String permission) {
        return Permissions.check((class_1297)((class_1297)player), (String)permission);
    }

    @Override
    public void sendMessage(Object target, String message) {
        class_2168 commandSource = (class_2168)target;
        if (commandSource.method_9228() instanceof class_3222) {
            MinecraftServerHolder.get().execute(() -> ((class_3222)commandSource.method_9228()).method_7353((class_2561)class_2561.method_43470((String)message), false));
        } else {
            this.logger.info(message, new Object[0]);
        }
    }

    @Override
    public void kickPlayer(Object o, String message) {
        if (o instanceof class_3222) {
            class_3222 player = (class_3222)o;
            player.field_13987.method_14367((class_2561)class_2561.method_43470((String)message));
        }
    }

    @Override
    public boolean whitelistPlayer(UUID uuid, String username) {
        GameProfile profile = new GameProfile(uuid, username);
        MinecraftServerHolder.get().method_3760().method_14590().method_14633((class_3330)new class_3340(profile));
        return true;
    }

    @Override
    public boolean removePlayerFromWhitelist(UUID uuid, String username) {
        GameProfile profile = new GameProfile(uuid, username);
        MinecraftServerHolder.get().method_3760().method_14590().method_14635((Object)profile);
        return true;
    }
}

