/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.pluginmessage.channel;

import com.google.inject.Inject;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.geysermc.floodgate.platform.pluginmessage.PluginMessageUtils;
import org.geysermc.floodgate.pluginmessage.PluginMessageChannel;

public class TransferChannel
implements PluginMessageChannel {
    @Inject
    private PluginMessageUtils pluginMessageUtils;

    @Override
    public String getIdentifier() {
        return "floodgate:transfer";
    }

    @Override
    public PluginMessageChannel.Result handleProxyCall(byte[] data, UUID targetUuid, String targetUsername, PluginMessageChannel.Identity targetIdentity, UUID sourceUuid, String sourceUsername, PluginMessageChannel.Identity sourceIdentity) {
        if (sourceIdentity == PluginMessageChannel.Identity.SERVER) {
            return PluginMessageChannel.Result.forward();
        }
        if (sourceIdentity == PluginMessageChannel.Identity.PLAYER) {
            this.handleServerCall(data, targetUuid, targetUsername);
        }
        return PluginMessageChannel.Result.handled();
    }

    @Override
    public PluginMessageChannel.Result handleServerCall(byte[] data, UUID targetUuid, String targetUsername) {
        return PluginMessageChannel.Result.kick("I'm sorry, I'm unable to transfer a server :(");
    }

    public boolean sendTransfer(UUID player, String address, int port) {
        byte[] addressBytes = address.getBytes(StandardCharsets.UTF_8);
        byte[] data = new byte[addressBytes.length + 4];
        data[0] = (byte)(port >> 24);
        data[1] = (byte)(port >> 16);
        data[2] = (byte)(port >> 8);
        data[3] = (byte)port;
        System.arraycopy(addressBytes, 0, data, 4, addressBytes.length);
        return this.pluginMessageUtils.sendMessage(player, this.getIdentifier(), data);
    }
}

