/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.link;

import java.time.Instant;
import java.util.UUID;
import org.geysermc.floodgate.api.link.LinkRequest;

public final class LinkRequestImpl
implements LinkRequest {
    private final String javaUsername;
    private final UUID javaUniqueId;
    private final String linkCode;
    private final String bedrockUsername;
    private final long requestTime;

    public LinkRequestImpl(String javaUsername, UUID javaUniqueId, String linkCode, String bedrockUsername) {
        this.javaUniqueId = javaUniqueId;
        this.javaUsername = javaUsername;
        this.linkCode = linkCode;
        this.bedrockUsername = bedrockUsername;
        this.requestTime = Instant.now().getEpochSecond();
    }

    public LinkRequestImpl(String javaUsername, UUID javaUniqueId, String linkCode, String bedrockUsername, long requestTime) {
        this.javaUniqueId = javaUniqueId;
        this.javaUsername = javaUsername;
        this.linkCode = linkCode;
        this.bedrockUsername = bedrockUsername;
        this.requestTime = requestTime;
    }

    @Override
    public boolean isExpired(long linkTimeout) {
        long timePassed = Instant.now().getEpochSecond() - this.requestTime;
        return timePassed > linkTimeout;
    }

    @Override
    public String getJavaUsername() {
        return this.javaUsername;
    }

    @Override
    public UUID getJavaUniqueId() {
        return this.javaUniqueId;
    }

    @Override
    public String getLinkCode() {
        return this.linkCode;
    }

    @Override
    public String getBedrockUsername() {
        return this.bedrockUsername;
    }

    @Override
    public long getRequestTime() {
        return this.requestTime;
    }
}

