/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.database.config;

import com.google.gson.JsonObject;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.geysermc.floodgate.database.config.DatabaseConfig;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.CustomClassLoaderConstructor;
import org.yaml.snakeyaml.introspector.BeanAccess;

public class DatabaseConfigLoader {
    private Yaml yaml;
    @Inject
    @Named(value="dataDirectory")
    private Path dataDirectory;
    @Inject
    @Named(value="databaseName")
    private String name;
    @Inject
    @Named(value="databaseClassLoader")
    private ClassLoader classLoader;
    @Inject
    @Named(value="databaseInitData")
    private JsonObject initData;

    @Inject
    public void init() {
        this.yaml = new Yaml(new CustomClassLoaderConstructor(this.classLoader));
        this.yaml.setBeanAccess(BeanAccess.FIELD);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T extends DatabaseConfig> T loadAs(Class<T> configType) {
        if (!this.initData.has("config")) {
            return null;
        }
        String configFile = this.initData.get("config").getAsString();
        Path configPath = this.dataDirectory.resolve(this.name).resolve(configFile);
        if (Files.exists(configPath, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(configPath);){
                DatabaseConfig databaseConfig = (DatabaseConfig)this.yaml.loadAs(reader, configType);
                return (T)databaseConfig;
            }
            catch (IOException exception) {
                exception.printStackTrace();
                return null;
            }
        }
        try {
            Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
        }
        catch (IOException exception) {
            exception.printStackTrace();
            return null;
        }
        try {
            InputStream configStream = this.classLoader.getResourceAsStream(configFile);
            Throwable throwable = null;
            try {
                if (configStream == null) {
                    T t2 = null;
                    return t2;
                }
                if (!configStream.markSupported()) {
                    Files.copy(configStream, configPath, new CopyOption[0]);
                    try (InputStream configStream1 = this.classLoader.getResourceAsStream(configFile);){
                        DatabaseConfig databaseConfig = (DatabaseConfig)this.yaml.loadAs(configStream1, configType);
                        return (T)databaseConfig;
                    }
                }
                configStream.mark(Integer.MAX_VALUE);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            Files.copy(configStream, configPath, new CopyOption[0]);
            configStream.reset();
            DatabaseConfig databaseConfig = (DatabaseConfig)this.yaml.loadAs(configStream, configType);
            return (T)databaseConfig;
            finally {
                if (configStream != null) {
                    if (throwable != null) {
                        try {
                            configStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        configStream.close();
                    }
                }
            }
        }
        catch (IOException exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

