/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.api;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.geysermc.cumulus.form.Form;
import org.geysermc.cumulus.form.util.FormBuilder;
import org.geysermc.floodgate.api.FloodgateApi;
import org.geysermc.floodgate.api.UnsafeFloodgateApi;
import org.geysermc.floodgate.api.logger.FloodgateLogger;
import org.geysermc.floodgate.api.player.FloodgatePlayer;
import org.geysermc.floodgate.api.unsafe.Unsafe;
import org.geysermc.floodgate.config.FloodgateConfigHolder;
import org.geysermc.floodgate.pluginmessage.PluginMessageManager;
import org.geysermc.floodgate.pluginmessage.channel.FormChannel;
import org.geysermc.floodgate.pluginmessage.channel.TransferChannel;
import org.geysermc.floodgate.util.HttpUtils;
import org.geysermc.floodgate.util.Utils;

public class SimpleFloodgateApi
implements FloodgateApi {
    private final Map<UUID, FloodgatePlayer> players = new HashMap<UUID, FloodgatePlayer>();
    private final Cache<UUID, FloodgatePlayer> pendingRemove = CacheBuilder.newBuilder().expireAfterWrite(20L, TimeUnit.SECONDS).build();
    private final PluginMessageManager pluginMessageManager;
    private final FloodgateConfigHolder configHolder;
    private final FloodgateLogger logger;

    @Override
    public String getPlayerPrefix() {
        return this.configHolder.get().getUsernamePrefix();
    }

    @Override
    public Collection<FloodgatePlayer> getPlayers() {
        return ImmutableSet.copyOf(this.players.values());
    }

    @Override
    public int getPlayerCount() {
        return this.players.size();
    }

    @Override
    public boolean isFloodgatePlayer(UUID uuid) {
        return this.getPlayer(uuid) != null;
    }

    @Override
    public FloodgatePlayer getPlayer(UUID uuid) {
        FloodgatePlayer selfPlayer = this.players.get(uuid);
        if (selfPlayer != null) {
            return selfPlayer;
        }
        if (this.isFloodgateId(uuid)) {
            return this.pendingRemove.getIfPresent(uuid);
        }
        for (FloodgatePlayer player : this.players.values()) {
            if (!player.getCorrectUniqueId().equals(uuid)) continue;
            return player;
        }
        return this.getPendingRemovePlayer(uuid);
    }

    @Override
    public UUID createJavaPlayerId(long xuid) {
        return Utils.getJavaUuid(xuid);
    }

    @Override
    public boolean isFloodgateId(UUID uuid) {
        return uuid.getMostSignificantBits() == 0L;
    }

    @Override
    public boolean sendForm(UUID uuid, Form form) {
        return this.pluginMessageManager.getChannel(FormChannel.class).sendForm(uuid, form);
    }

    @Override
    public boolean sendForm(UUID uuid, FormBuilder<?, ?, ?> formBuilder) {
        return this.sendForm(uuid, (Form)formBuilder.build());
    }

    @Override
    public boolean sendForm(UUID uuid, org.geysermc.cumulus.Form<?> form) {
        return this.sendForm(uuid, (Form)form.newForm());
    }

    @Override
    public boolean sendForm(UUID uuid, org.geysermc.cumulus.util.FormBuilder<?, ?> formBuilder) {
        return this.sendForm(uuid, (org.geysermc.cumulus.Form<?>)formBuilder.build());
    }

    @Override
    public boolean transferPlayer(UUID uuid, String address, int port) {
        return this.pluginMessageManager.getChannel(TransferChannel.class).sendTransfer(uuid, address, port);
    }

    @Override
    public CompletableFuture<Long> getXuidFor(String gamertag) {
        if (gamertag == null || gamertag.isEmpty() || gamertag.length() > 16) {
            return Utils.failedFuture(new IllegalStateException("Received an invalid gamertag"));
        }
        return HttpUtils.asyncGet("https://api.geysermc.org/v2/xbox/xuid/" + gamertag).thenApply(result -> {
            JsonObject response = (JsonObject)result.getResponse();
            if (!result.isCodeOk()) {
                throw new IllegalStateException(response.get("message").getAsString());
            }
            JsonElement xuid = response.get("xuid");
            return xuid != null ? Long.valueOf(xuid.getAsLong()) : null;
        });
    }

    @Override
    public CompletableFuture<String> getGamertagFor(long xuid) {
        return HttpUtils.asyncGet("https://api.geysermc.org/v2/xbox/gamertag/" + xuid).thenApply(result -> {
            JsonObject response = (JsonObject)result.getResponse();
            if (!result.isCodeOk()) {
                throw new IllegalStateException(response.get("message").getAsString());
            }
            JsonElement gamertag = response.get("gamertag");
            return gamertag != null ? gamertag.getAsString() : null;
        });
    }

    @Override
    public final Unsafe unsafe() {
        String callerClass = Thread.currentThread().getStackTrace()[2].getClassName();
        this.logger.warn("A plugin is trying to access an unsafe part of the Floodgate api! The use of this api can result in client crashes if used incorrectly. Caller: " + callerClass, new Object[0]);
        return new UnsafeFloodgateApi(this.pluginMessageManager);
    }

    public FloodgatePlayer addPlayer(FloodgatePlayer player) {
        return this.players.put(player.getJavaUniqueId(), player);
    }

    public boolean setPendingRemove(FloodgatePlayer player) {
        this.pendingRemove.put(player.getJavaUniqueId(), player);
        return this.players.remove(player.getJavaUniqueId(), player);
    }

    public void playerRemoved(UUID correctUuid) {
        if (this.isFloodgateId(correctUuid)) {
            this.pendingRemove.invalidate(correctUuid);
            return;
        }
        FloodgatePlayer linkedPlayer = this.getPendingRemovePlayer(correctUuid);
        if (linkedPlayer != null) {
            this.pendingRemove.invalidate(linkedPlayer.getJavaUniqueId());
        }
    }

    private FloodgatePlayer getPendingRemovePlayer(UUID correctUuid) {
        for (FloodgatePlayer player : this.pendingRemove.asMap().values()) {
            if (!player.getCorrectUniqueId().equals(correctUuid)) continue;
            return player;
        }
        return null;
    }

    public SimpleFloodgateApi(PluginMessageManager pluginMessageManager, FloodgateConfigHolder configHolder, FloodgateLogger logger) {
        this.pluginMessageManager = pluginMessageManager;
        this.configHolder = configHolder;
        this.logger = logger;
    }
}

