/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.cumulus.form.util.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.cumulus.component.impl.ButtonComponentImpl;
import org.geysermc.cumulus.form.Form;
import org.geysermc.cumulus.form.impl.FormImpl;
import org.geysermc.cumulus.form.util.FormCodec;
import org.geysermc.cumulus.form.util.FormType;
import org.geysermc.cumulus.response.FormResponse;
import org.geysermc.cumulus.response.result.FormResponseResult;

public abstract class FormCodecImpl<F extends Form, R extends FormResponse>
implements JsonDeserializer<F>,
JsonSerializer<F>,
FormCodec<F, R> {
    protected static final Type LIST_BUTTON_TYPE = new TypeToken<List<ButtonComponentImpl>>(){}.getType();
    protected final Class<F> typeClass;
    protected final FormType formType;
    protected final Gson gson;

    protected FormCodecImpl(Class<F> typeClass, FormType formType) {
        this.typeClass = typeClass;
        this.formType = formType;
        GsonBuilder builder = new GsonBuilder();
        this.initializeGson(builder);
        this.gson = builder.create();
    }

    @Override
    public final F fromJson(@NonNull String json, @Nullable BiConsumer<F, String> rawResponseConsumer) {
        Form form = (Form)this.gson.fromJson(json, this.typeClass);
        this.setRawResponseConsumer(form, rawResponseConsumer);
        return (F)form;
    }

    protected void setRawResponseConsumer(F form, BiConsumer<F, String> rawResponseConsumer) {
        ((FormImpl)form).rawResponseConsumer(response -> rawResponseConsumer.accept(form, (String)response));
    }

    @Override
    public final String jsonData(@NonNull F form) {
        return this.gson.toJson(form, this.typeClass);
    }

    @Override
    public final F deserialize(JsonElement element, Type typeOfF, JsonDeserializationContext context) throws JsonParseException {
        if (!element.isJsonObject()) {
            throw new JsonParseException("Form has to be a JsonObject");
        }
        return this.deserializeForm(element.getAsJsonObject(), context);
    }

    @Override
    public final JsonElement serialize(F src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject result = new JsonObject();
        this.serializeForm(src, context, result);
        result.add("type", context.serialize((Object)this.formType));
        return result;
    }

    @Override
    public final FormResponseResult<R> deserializeFormResponse(@NonNull F form, @Nullable String response) {
        Objects.requireNonNull(form);
        if (response == null || response.isEmpty() || "null".equals(response.trim())) {
            return FormResponseResult.closed();
        }
        return this.deserializeResponse(form, response);
    }

    protected void initializeGson(GsonBuilder builder) {
        builder.registerTypeAdapter(this.typeClass, this);
    }

    protected abstract F deserializeForm(JsonObject var1, JsonDeserializationContext var2);

    protected abstract void serializeForm(F var1, JsonSerializationContext var2, JsonObject var3);

    protected abstract FormResponseResult<R> deserializeResponse(@NonNull F var1, @NonNull String var2);
}

