/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.cumulus.form.impl;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import org.geysermc.cumulus.form.Form;
import org.geysermc.cumulus.form.impl.FormDefinition;
import org.geysermc.cumulus.form.impl.FormImpl;
import org.geysermc.cumulus.form.impl.custom.CustomFormDefinition;
import org.geysermc.cumulus.form.impl.modal.ModalFormDefinition;
import org.geysermc.cumulus.form.impl.simple.SimpleFormDefinition;
import org.geysermc.cumulus.form.util.FormCodec;
import org.geysermc.cumulus.form.util.FormType;

public final class FormDefinitions {
    private static final FormDefinitions definitions = new FormDefinitions();
    private final Map<FormType, FormDefinition<?, ?, ?>> typeDefinitionMap = new HashMap();
    private final Map<Class<? extends FormImpl<?>>, FormDefinition<?, ?, ?>> implClassTypeDefinitionMap = new HashMap();

    private FormDefinitions() {
    }

    public Class<? extends FormImpl<?>> formImplClass(FormType formType) {
        return this.findDefinition(formType).formImplClass();
    }

    public <C extends FormCodec<?, ?>> C codecFor(FormType formType) {
        return (C)this.findDefinition(formType).codec();
    }

    public <C extends FormCodec<F, ?>, F extends Form> C codecFor(F form) {
        return (C)((FormDefinition)this.definitionFor(form)).codec();
    }

    public <C extends FormDefinition<F, ?, ?>, F extends Form> C definitionFor(F form) {
        return (C)this.implClassTypeDefinitionMap.get(form.getClass());
    }

    public FormType typeFromImplClass(Class<? extends Form> formClass) {
        return this.implClassTypeDefinitionMap.get(formClass).formType();
    }

    public boolean addDefinition(FormDefinition<?, ?, ?> definition) {
        FormType type = definition.formType();
        if (this.typeDefinitionMap.putIfAbsent(type, definition) != null) {
            return false;
        }
        Class<?> formImplClass = definition.formImplClass();
        if (this.implClassTypeDefinitionMap.putIfAbsent(formImplClass, definition) != null) {
            this.typeDefinitionMap.remove((Object)type);
            return false;
        }
        return true;
    }

    private void ensureDefinitionAdded(FormDefinition<?, ?, ?> definition) {
        Preconditions.checkArgument(this.addDefinition(definition));
    }

    private FormDefinition<?, ?, ?> findDefinition(FormType formType) {
        FormDefinition<?, ?, ?> definition = this.typeDefinitionMap.get((Object)formType);
        if (definition == null) {
            throw new RuntimeException("Cannot find implementation for FormType " + (Object)((Object)formType));
        }
        return definition;
    }

    public static FormDefinitions instance() {
        return definitions;
    }

    static {
        definitions.ensureDefinitionAdded(SimpleFormDefinition.instance());
        definitions.ensureDefinitionAdded(ModalFormDefinition.instance());
        definitions.ensureDefinitionAdded(CustomFormDefinition.instance());
    }
}

