/*
 * Decompiled with CFR 0.152.
 */
package cloud.commandframework.permission;

import cloud.commandframework.permission.CommandPermission;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class AndPermission
implements CommandPermission {
    private final Set<CommandPermission> permissions;

    AndPermission(@NonNull Set<CommandPermission> permissions) {
        this.permissions = Collections.unmodifiableSet(permissions);
    }

    public static @NonNull CommandPermission of(@NonNull Collection<CommandPermission> permissions) {
        HashSet<CommandPermission> permissionSet = new HashSet<CommandPermission>();
        for (CommandPermission permission : permissions) {
            permissionSet.addAll(permission.getPermissions());
        }
        return new AndPermission(permissionSet);
    }

    @Override
    public @NonNull Collection<@NonNull CommandPermission> getPermissions() {
        return this.permissions;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<CommandPermission> iterator = this.permissions.iterator();
        while (iterator.hasNext()) {
            CommandPermission permission = iterator.next();
            stringBuilder.append('(').append(permission.toString()).append(')');
            if (!iterator.hasNext()) continue;
            stringBuilder.append(" & ");
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AndPermission that = (AndPermission)o;
        return this.permissions.equals(that.permissions);
    }

    public int hashCode() {
        return Objects.hash(this.getPermissions());
    }
}

