/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.category;

import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import xaero.common.category.ObjectCategory;
import xaero.common.category.rule.ExcludeListMode;
import xaero.common.category.rule.ObjectCategoryExcludeList;
import xaero.common.category.rule.ObjectCategoryIncludeList;
import xaero.common.category.rule.ObjectCategoryRule;
import xaero.common.category.serialization.data.FilterObjectCategoryData;
import xaero.common.category.setting.ObjectCategorySetting;
import xaero.common.misc.ListFactory;
import xaero.common.misc.MapFactory;

public abstract class FilterObjectCategory<E, P, S, D extends FilterObjectCategoryData<D>, C extends FilterObjectCategory<E, P, S, D, C>>
extends ObjectCategory<D, C> {
    private final C self = this;
    private ObjectCategoryRule<E, P> baseRule;
    private final ObjectCategoryIncludeList<E, S> includeList;
    private final ObjectCategoryExcludeList<E, S> excludeList;

    protected FilterObjectCategory(@Nonnull String name, @Nonnull C superCategory, @Nonnull ObjectCategoryRule<E, P> baseRule, @Nonnull ObjectCategoryIncludeList<E, S> includeList, @Nonnull ObjectCategoryExcludeList<E, S> excludeList, @Nonnull Map<ObjectCategorySetting<?>, Object> settingOverrides, @Nonnull List<C> subCategories, boolean protection) {
        super(name, superCategory, settingOverrides, subCategories, protection);
        this.baseRule = baseRule;
        this.includeList = includeList;
        this.excludeList = excludeList;
    }

    public ObjectCategoryRule<E, P> getBaseRule() {
        return this.baseRule;
    }

    public ObjectCategoryIncludeList<E, S> getIncludeList() {
        return this.includeList;
    }

    public ObjectCategoryExcludeList<E, S> getExcludeList() {
        return this.excludeList;
    }

    public ExcludeListMode getExcludeMode() {
        return this.excludeList.getExcludeMode();
    }

    public static abstract class Builder<E, P, S, C extends FilterObjectCategory<E, P, S, ?, C>, B extends Builder<E, P, S, C, B>>
    extends ObjectCategory.Builder<C, B> {
        protected ObjectCategoryRule<E, P> baseRule;
        protected final ObjectCategoryIncludeList.Builder<E, S> includeListBuilder;
        protected final ObjectCategoryExcludeList.Builder<E, S> excludeListBuilder;

        public Builder(ListFactory listFactory, MapFactory mapFactory) {
            super(listFactory, mapFactory);
            this.includeListBuilder = ObjectCategoryIncludeList.Builder.getDefault(listFactory);
            this.excludeListBuilder = ObjectCategoryExcludeList.Builder.getDefault(listFactory);
        }

        @Override
        public B setDefault() {
            super.setDefault();
            this.includeListBuilder.setDefault();
            this.excludeListBuilder.setDefault();
            this.setBaseRule(null);
            return (B)((Builder)this.self);
        }

        public ObjectCategoryIncludeList.Builder<E, S> getIncludeListBuilder() {
            return this.includeListBuilder;
        }

        public ObjectCategoryExcludeList.Builder<E, S> getExcludeListBuilder() {
            return this.excludeListBuilder;
        }

        public B setBaseRule(ObjectCategoryRule<E, P> baseRule) {
            this.baseRule = baseRule;
            return (B)((Builder)this.self);
        }

        @Override
        public C build() {
            if (this.baseRule == null) {
                throw new IllegalStateException("required fields not set!");
            }
            return (C)((FilterObjectCategory)super.build());
        }

        @Override
        protected final C buildUnchecked(List<C> subCategories) {
            ObjectCategoryIncludeList<E, S> includeList = this.includeListBuilder.build(subCategories);
            ObjectCategoryExcludeList<E, S> excludeList = this.excludeListBuilder.build(subCategories);
            return this.buildUncheckedFilter(subCategories, includeList, excludeList);
        }

        protected abstract C buildUncheckedFilter(List<C> var1, ObjectCategoryIncludeList<E, S> var2, ObjectCategoryExcludeList<E, S> var3);
    }
}

