/*
 * Decompiled with CFR 0.152.
 */
package org.anti_ad.mc.common.math2d;

import kotlin.Metadata;
import org.anti_ad.mc.common.math2d.Point;
import org.anti_ad.mc.common.math2d.Size;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000e\n\u0002\b\u001f\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\b\u0016\u0012\u0006\u0010\u0014\u001a\u00020\r\u0012\u0006\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0004\b>\u0010?B'\u0012\u0006\u0010\b\u001a\u00020\u0002\u0012\u0006\u0010\t\u001a\u00020\u0002\u0012\u0006\u0010\u0010\u001a\u00020\u0002\u0012\u0006\u0010\u0011\u001a\u00020\u0002\u00a2\u0006\u0004\b>\u0010@J\u0010\u0010\u0003\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0004J\u0010\u0010\u0006\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0007\u0010\u0004J\u001d\u0010\u000b\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0018\u0010\u000b\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\rH\u0086\u0002\u00a2\u0006\u0004\b\u000b\u0010\u000fJ8\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\b\u001a\u00020\u00022\b\b\u0002\u0010\t\u001a\u00020\u00022\b\b\u0002\u0010\u0010\u001a\u00020\u00022\b\b\u0002\u0010\u0011\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\u0012\u0010\u0013J!\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0014\u001a\u00020\r2\b\b\u0002\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0012\u0010\u0017J\u001a\u0010\u0019\u001a\u00020\n2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0010\u0010\u001b\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u001b\u0010\u0004J\u0015\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0017\u0010 \u001a\u00020\n2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0004\b \u0010!J\u0010\u0010#\u001a\u00020\"H\u00d6\u0001\u00a2\u0006\u0004\b#\u0010$R\u0011\u0010&\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0004R\u0011\u0010)\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0011\u0010+\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010(R\u0017\u0010\u0011\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0011\u0010,\u001a\u0004\b-\u0010\u0004R\u0011\u0010/\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b.\u0010\u0004R\u0011\u0010\u0014\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b0\u0010(R\u0011\u00102\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b1\u0010\u0004R\u0011\u0010\u0016\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b3\u00104R\u0011\u00106\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b5\u0010\u0004R\u0011\u00108\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b7\u0010(R\u0011\u0010:\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b9\u0010(R\u0017\u0010\u0010\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0010\u0010,\u001a\u0004\b;\u0010\u0004R\u0017\u0010\b\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\b\u0010,\u001a\u0004\b<\u0010\u0004R\u0017\u0010\t\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\t\u0010,\u001a\u0004\b=\u0010\u0004\u00a8\u0006A"}, d2={"Lorg/anti_ad/mc/common/math2d/Rectangle;", "", "", "component1", "()I", "component2", "component3", "component4", "x", "y", "", "contains", "(II)Z", "Lorg/anti_ad/mc/common/math2d/Point;", "point", "(Lorg/anti_ad/mc/common/math2d/Point;)Z", "width", "height", "copy", "(IIII)Lorg/anti_ad/mc/common/math2d/Rectangle;", "location", "Lorg/anti_ad/mc/common/math2d/Size;", "size", "(Lorg/anti_ad/mc/common/math2d/Point;Lorg/anti_ad/mc/common/math2d/Size;)Lorg/anti_ad/mc/common/math2d/Rectangle;", "other", "equals", "(Ljava/lang/Object;)Z", "hashCode", "amount", "inflated", "(I)Lorg/anti_ad/mc/common/math2d/Rectangle;", "parent", "insideOf", "(Lorg/anti_ad/mc/common/math2d/Rectangle;)Z", "", "toString", "()Ljava/lang/String;", "getBottom", "bottom", "getBottomLeft", "()Lorg/anti_ad/mc/common/math2d/Point;", "bottomLeft", "getBottomRight", "bottomRight", "I", "getHeight", "getLeft", "left", "getLocation", "getRight", "right", "getSize", "()Lorg/anti_ad/mc/common/math2d/Size;", "getTop", "top", "getTopLeft", "topLeft", "getTopRight", "topRight", "getWidth", "getX", "getY", "<init>", "(Lorg/anti_ad/mc/common/math2d/Point;Lorg/anti_ad/mc/common/math2d/Size;)V", "(IIII)V", "common"})
public final class Rectangle {
    private final int x;
    private final int y;
    private final int width;
    private final int height;

    public Rectangle(int n2, int n3, int n4, int n5) {
        this.x = n2;
        this.y = n3;
        this.width = n4;
        this.height = n5;
    }

    public final int getX() {
        return this.x;
    }

    public final int getY() {
        return this.y;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public Rectangle(@NotNull Point point, @NotNull Size size) {
        this(point.getX(), point.getY(), size.getWidth(), size.getHeight());
    }

    public final int getLeft() {
        return this.x;
    }

    public final int getTop() {
        return this.y;
    }

    public final int getRight() {
        return this.x + this.width;
    }

    public final int getBottom() {
        return this.y + this.height;
    }

    @NotNull
    public final Point getTopLeft() {
        return new Point(this.getLeft(), this.getTop());
    }

    @NotNull
    public final Point getTopRight() {
        return new Point(this.getRight(), this.getTop());
    }

    @NotNull
    public final Point getBottomLeft() {
        return new Point(this.getLeft(), this.getBottom());
    }

    @NotNull
    public final Point getBottomRight() {
        return new Point(this.getRight(), this.getBottom());
    }

    @NotNull
    public final Point getLocation() {
        return new Point(this.x, this.y);
    }

    @NotNull
    public final Size getSize() {
        return new Size(this.width, this.height);
    }

    @NotNull
    public final Rectangle copy(@NotNull Point point, @NotNull Size size) {
        return new Rectangle(point, size);
    }

    public static /* synthetic */ Rectangle copy$default(Rectangle rectangle, Point point, Size size, int n2, Object object) {
        if ((n2 & 1) != 0) {
            point = rectangle.getLocation();
        }
        if ((n2 & 2) != 0) {
            size = rectangle.getSize();
        }
        return rectangle.copy(point, size);
    }

    @NotNull
    public final Rectangle inflated(int n2) {
        return new Rectangle(this.x - n2, this.y - n2, this.width + (n2 << 1), this.height + (n2 << 1));
    }

    public final boolean contains(@NotNull Point point) {
        return this.contains(point.getX(), point.getY());
    }

    public final boolean contains(int n2, int n3) {
        int n4 = this.getLeft();
        boolean bl = n2 < this.getRight() ? n4 <= n2 : false;
        if (bl) {
            n4 = this.getTop();
            boolean bl2 = n3 < this.getBottom() ? n4 <= n3 : false;
            if (bl2) {
                return true;
            }
        }
        return false;
    }

    public final boolean insideOf(@Nullable Rectangle rectangle) {
        if (rectangle != null) {
            if (this.x < rectangle.x) {
                return false;
            }
            if (this.y < rectangle.y) {
                return false;
            }
            if (this.x + this.width > rectangle.x + rectangle.width) {
                return false;
            }
            if (this.y + this.height > rectangle.y + rectangle.height) {
                return false;
            }
        }
        return true;
    }

    public final int component1() {
        return this.x;
    }

    public final int component2() {
        return this.y;
    }

    public final int component3() {
        return this.width;
    }

    public final int component4() {
        return this.height;
    }

    @NotNull
    public final Rectangle copy(int n2, int n3, int n4, int n5) {
        return new Rectangle(n2, n3, n4, n5);
    }

    public static /* synthetic */ Rectangle copy$default(Rectangle rectangle, int n2, int n3, int n4, int n5, int n6, Object object) {
        if ((n6 & 1) != 0) {
            n2 = rectangle.x;
        }
        if ((n6 & 2) != 0) {
            n3 = rectangle.y;
        }
        if ((n6 & 4) != 0) {
            n4 = rectangle.width;
        }
        if ((n6 & 8) != 0) {
            n5 = rectangle.height;
        }
        return rectangle.copy(n2, n3, n4, n5);
    }

    @NotNull
    public final String toString() {
        return "Rectangle(x=" + this.x + ", y=" + this.y + ", width=" + this.width + ", height=" + this.height + ')';
    }

    public final int hashCode() {
        return ((Integer.hashCode(this.x) * 31 + Integer.hashCode(this.y)) * 31 + Integer.hashCode(this.width)) * 31 + Integer.hashCode(this.height);
    }

    public final boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Rectangle)) {
            return false;
        }
        object = (Rectangle)object;
        if (this.x != ((Rectangle)object).x) {
            return false;
        }
        if (this.y != ((Rectangle)object).y) {
            return false;
        }
        if (this.width != ((Rectangle)object).width) {
            return false;
        }
        return this.height == ((Rectangle)object).height;
    }
}

