/*
 * Decompiled with CFR 0.152.
 */
package org.anti_ad.mc.common.input;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import org.anti_ad.mc.common.IInputHandler;
import org.anti_ad.mc.common.gui.debug.DebugInfos;
import org.anti_ad.mc.common.input.IKeybind;
import org.anti_ad.mc.common.input.KeybindSettings;
import org.anti_ad.mc.common.vanilla.glue.IVanillaUtilKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010#\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\bG\u0010\u0004J\u000f\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J#\u0010\u000b\u001a\u00020\n2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001d\u0010\u0010\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0010\u0010\u0011J#\u0010\u0012\u001a\u00020\n2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u0012\u0010\fJ\u0015\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0016\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001f\u0010\u0019\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ=\u0010\u0019\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0019\u0010\u001fJ%\u0010\"\u001a\u00020\n2\u0006\u0010 \u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010!\u001a\u00020\u0006\u00a2\u0006\u0004\b\"\u0010#J\u0015\u0010&\u001a\u00020\n2\u0006\u0010%\u001a\u00020$\u00a2\u0006\u0004\b&\u0010'J\u0015\u0010(\u001a\u00020\n2\u0006\u0010%\u001a\u00020$\u00a2\u0006\u0004\b(\u0010'J\u0015\u0010)\u001a\u00020\n2\u0006\u0010%\u001a\u00020$\u00a2\u0006\u0004\b)\u0010'J\u0015\u0010*\u001a\u00020\n2\u0006\u0010%\u001a\u00020$\u00a2\u0006\u0004\b*\u0010'R.\u0010-\u001a\u0004\u0018\u00010+2\b\u0010,\u001a\u0004\u0018\u00010+8\u0006@FX\u0086\u000e\u00a2\u0006\u0012\n\u0004\b-\u0010.\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u0016\u00103\u001a\u00020\n8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b3\u00104R$\u00106\u001a\u00020\u00062\u0006\u00105\u001a\u00020\u00068\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b6\u00107\u001a\u0004\b8\u00109R$\u0010:\u001a\u00020\u00062\u0006\u00105\u001a\u00020\u00068\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b:\u00107\u001a\u0004\b;\u00109R\u0016\u0010<\u001a\u00020\n8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b<\u00104R\u001d\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00060=8\u0006\u00a2\u0006\f\n\u0004\b>\u0010?\u001a\u0004\b@\u0010AR0\u0010C\u001a\b\u0012\u0004\u0012\u00020\u00060B2\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u00060B8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\bC\u0010?\u001a\u0004\bD\u0010AR\u001a\u0010E\u001a\b\u0012\u0004\u0012\u00020$0=8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bE\u0010?R\u001a\u0010F\u001a\b\u0012\u0004\u0012\u00020$0=8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bF\u0010?\u00a8\u0006H"}, d2={"Lorg/anti_ad/mc/common/input/GlobalInputHandler;", "", "", "handleAssignKeybind", "()V", "", "", "keyCodes", "Lorg/anti_ad/mc/common/input/KeybindSettings;", "settings", "", "isActivated", "(Ljava/util/List;Lorg/anti_ad/mc/common/input/KeybindSettings;)Z", "keyCode", "", "window", "isKeyDown", "(IJ)Z", "isPressing", "key", "isWaitingForRelease", "(I)Z", "onInput", "()Z", "action", "onKey", "(II)Z", "scanCode", "modifiers", "checkPressing", "handle", "(IIIIZJ)Z", "button", "mods", "onMouseButton", "(III)Z", "Lorg/anti_ad/mc/common/IInputHandler;", "inputHandler", "register", "(Lorg/anti_ad/mc/common/IInputHandler;)Z", "registerCancellable", "unregister", "unregisterCancellable", "Lorg/anti_ad/mc/common/input/IKeybind;", "value", "currentAssigningKeybind", "Lorg/anti_ad/mc/common/input/IKeybind;", "getCurrentAssigningKeybind", "()Lorg/anti_ad/mc/common/input/IKeybind;", "setCurrentAssigningKeybind", "(Lorg/anti_ad/mc/common/input/IKeybind;)V", "ignoreLeftClick", "Z", "<set-?>", "lastAction", "I", "getLastAction", "()I", "lastKey", "getLastKey", "pressedFirstKey", "", "pressedKeys", "Ljava/util/Set;", "getPressedKeys", "()Ljava/util/Set;", "", "previousPressedKeys", "getPreviousPressedKeys", "registered", "registeredCancellable", "<init>", "common"})
public final class GlobalInputHandler {
    @NotNull
    public static final GlobalInputHandler INSTANCE = new GlobalInputHandler();
    @NotNull
    private static final Set pressedKeys = new LinkedHashSet();
    @NotNull
    private static Set previousPressedKeys = CollectionsKt.toSet((Iterable)pressedKeys);
    private static int lastKey = -1;
    private static int lastAction = -1;
    @Nullable
    private static IKeybind currentAssigningKeybind;
    private static boolean pressedFirstKey;
    private static boolean ignoreLeftClick;
    @NotNull
    private static final Set registered;
    @NotNull
    private static final Set registeredCancellable;

    private GlobalInputHandler() {
    }

    @NotNull
    public final Set getPressedKeys() {
        return pressedKeys;
    }

    @NotNull
    public final Set getPreviousPressedKeys() {
        return previousPressedKeys;
    }

    public final int getLastKey() {
        return lastKey;
    }

    public final int getLastAction() {
        return lastAction;
    }

    public final boolean isWaitingForRelease(int n2) {
        return pressedKeys.contains(n2);
    }

    public final boolean isActivated(@NotNull List list2, @NotNull KeybindSettings keybindSettings) {
        if (list2.isEmpty()) {
            return false;
        }
        if (!keybindSettings.getActivateOn().isValid(lastAction)) {
            return false;
        }
        if (!IVanillaUtilKt.getVanillaUtil().isValidScreen(keybindSettings.getContext())) {
            return false;
        }
        Set set = lastAction == 1 ? pressedKeys : previousPressedKeys;
        return KeybindSettings.validates$default(keybindSettings, set, list2, false, 4, null);
    }

    public final boolean isPressing(@NotNull List list2, @NotNull KeybindSettings keybindSettings) {
        if (list2.isEmpty()) {
            return false;
        }
        if (!IVanillaUtilKt.getVanillaUtil().isValidScreen(keybindSettings.getContext())) {
            return false;
        }
        return keybindSettings.validates(pressedKeys, list2, false);
    }

    private final boolean onKey(int n2, int n3) {
        boolean bl = n3 == 1;
        if (bl && pressedKeys.contains(n2)) {
            return false;
        }
        previousPressedKeys = CollectionsKt.toSet((Iterable)pressedKeys);
        if (bl) {
            pressedKeys.add(n2);
        } else {
            pressedKeys.remove(n2);
        }
        lastKey = n2;
        lastAction = n3;
        return this.onInput();
    }

    private final boolean onInput() {
        boolean bl;
        if (currentAssigningKeybind != null) {
            this.handleAssignKeybind();
            return true;
        }
        Object object = registeredCancellable;
        if (!(object instanceof Collection) || !((Collection)object).isEmpty()) {
            object = object.iterator();
            while (object.hasNext()) {
                if (!((IInputHandler)object.next()).onInput(lastKey, lastAction)) continue;
                bl = true;
                break;
            }
        } else {
            bl = false;
        }
        if (bl) {
            return true;
        }
        object = ((Iterable)registered).iterator();
        while (object.hasNext()) {
            ((IInputHandler)object.next()).onInput(lastKey, lastAction);
        }
        return false;
    }

    @Nullable
    public final IKeybind getCurrentAssigningKeybind() {
        return currentAssigningKeybind;
    }

    public final void setCurrentAssigningKeybind(@Nullable IKeybind iKeybind) {
        pressedFirstKey = false;
        ignoreLeftClick = true;
        currentAssigningKeybind = iKeybind;
    }

    private final void handleAssignKeybind() {
        Object object;
        Object object2 = currentAssigningKeybind;
        if (object2 == null || (object2 = object2.getSettings().getModifierKey().handleKeys(CollectionsKt.toList((Iterable)pressedKeys))) == null) {
            object2 = object = CollectionsKt.toList((Iterable)pressedKeys);
        }
        if (lastAction == 1) {
            if (lastKey == -100 && ignoreLeftClick) {
                return;
            }
            pressedFirstKey = true;
            if (lastKey == 256) {
                IKeybind iKeybind = currentAssigningKeybind;
                if (iKeybind != null) {
                    iKeybind.setKeyCodes(CollectionsKt.emptyList());
                }
                this.setCurrentAssigningKeybind(null);
                return;
            }
            IKeybind iKeybind = currentAssigningKeybind;
            if (iKeybind == null) {
                return;
            }
            iKeybind.setKeyCodes((List)object);
            return;
        }
        if (lastKey == -100) {
            ignoreLeftClick = false;
        }
        if (object.isEmpty() && pressedFirstKey) {
            this.setCurrentAssigningKeybind(null);
        }
    }

    public final boolean isKeyDown(int n2, long l2) {
        int n3 = n2;
        if (n2 >= 0) {
            return GLFW.glfwGetKey((long)l2, (int)n2) == 1;
        }
        return (n3 += 100) >= 0 && GLFW.glfwGetMouseButton((long)l2, (int)n3) == 1;
    }

    public final boolean onKey(int n2, int n3, int n4, int n5, boolean bl, long l2) {
        DebugInfos.INSTANCE.onKey(n2, n3, n4, n5);
        if (l2 != 0L && bl && !((Collection)pressedKeys).isEmpty()) {
            Object object = CollectionsKt.toSet((Iterable)pressedKeys);
            pressedKeys.clear();
            object = ((Iterable)object).iterator();
            while (object.hasNext()) {
                n5 = ((Number)object.next()).intValue();
                if (!INSTANCE.isKeyDown(n5, l2)) continue;
                pressedKeys.add(n5);
            }
        }
        switch (n4) {
            case 1: {
                return this.onKey(n2, n4);
            }
            case 0: {
                return this.onKey(n2, n4);
            }
        }
        return false;
    }

    public final boolean onMouseButton(int n2, int n3, int n4) {
        DebugInfos.INSTANCE.onMouseButton(n2, n3, n4);
        switch (n3) {
            case 0: 
            case 1: {
                return this.onKey(n2 - 100, n3);
            }
        }
        return false;
    }

    public final boolean register(@NotNull IInputHandler iInputHandler) {
        return registered.add(iInputHandler);
    }

    public final boolean unregister(@NotNull IInputHandler iInputHandler) {
        return registered.remove(iInputHandler);
    }

    public final boolean registerCancellable(@NotNull IInputHandler iInputHandler) {
        return registeredCancellable.add(iInputHandler);
    }

    public final boolean unregisterCancellable(@NotNull IInputHandler iInputHandler) {
        return registeredCancellable.remove(iInputHandler);
    }

    static {
        registered = new LinkedHashSet();
        registeredCancellable = new LinkedHashSet();
    }
}

