/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.client;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.debug.CooldownTimer;
import de.maxhenkel.voicechat.voice.client.AudioChannel;
import de.maxhenkel.voicechat.voice.client.AudioRecorder;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.client.ClientVoicechatConnection;
import de.maxhenkel.voicechat.voice.client.InitializationData;
import de.maxhenkel.voicechat.voice.client.MicThread;
import de.maxhenkel.voicechat.voice.client.NativeDependencyException;
import de.maxhenkel.voicechat.voice.client.SoundManager;
import de.maxhenkel.voicechat.voice.client.TalkCache;
import de.maxhenkel.voicechat.voice.client.speaker.SpeakerException;
import de.maxhenkel.voicechat.voice.common.SoundPacket;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_746;

public class ClientVoicechat {
    @Nullable
    private SoundManager soundManager;
    private final Map<UUID, AudioChannel> audioChannels;
    private final TalkCache talkCache = new TalkCache();
    @Nullable
    private MicThread micThread;
    @Nullable
    private ClientVoicechatConnection connection;
    @Nullable
    private AudioRecorder recorder;

    public ClientVoicechat() {
        try {
            this.reloadSoundManager();
        }
        catch (SpeakerException e) {
            Voicechat.LOGGER.error("Failed to start sound manager: {}", (Object)e.getMessage());
            ClientManager.sendPlayerError("message.voicechat.speaker_unavailable", e);
        }
        this.audioChannels = new HashMap<UUID, AudioChannel>();
    }

    public void onVoiceChatConnected(ClientVoicechatConnection connection) {
        this.startMicThread(connection);
    }

    public void onVoiceChatDisconnected() {
        this.closeMicThread();
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
    }

    public void connect(InitializationData data) throws Exception {
        Voicechat.LOGGER.info("Connecting to server: '" + data.getServerIP() + ":" + data.getServerPort() + "'");
        this.connection = new ClientVoicechatConnection(this, data);
        this.connection.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processSoundPacket(SoundPacket packet) {
        if (this.connection == null) {
            return;
        }
        Map<UUID, AudioChannel> map = this.audioChannels;
        synchronized (map) {
            if (!ClientManager.getPlayerStateManager().isDisabled()) {
                AudioChannel sendTo = this.audioChannels.get(packet.getSender());
                if (sendTo == null) {
                    try {
                        AudioChannel ch = new AudioChannel(this, this.connection.getData(), packet.getSender());
                        ch.addToQueue(packet);
                        ch.start();
                        this.audioChannels.put(packet.getSender(), ch);
                    }
                    catch (NativeDependencyException e) {
                        CooldownTimer.run("decoder_unavailable", () -> {
                            Voicechat.LOGGER.error("Failed to create audio channel: {}", (Object)e.getMessage());
                            ClientManager.sendPlayerError("message.voicechat.playback_unavailable", e);
                        });
                    }
                } else {
                    sendTo.addToQueue(packet);
                }
            }
            this.audioChannels.values().stream().filter(AudioChannel::canKill).forEach(AudioChannel::closeAndKill);
            this.audioChannels.entrySet().removeIf(entry -> ((AudioChannel)entry.getValue()).isClosed());
        }
    }

    public void reloadSoundManager() throws SpeakerException {
        if (this.soundManager != null) {
            this.soundManager.close();
        }
        this.soundManager = new SoundManager(VoicechatClient.CLIENT_CONFIG.speaker.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadAudio() {
        Voicechat.LOGGER.info("Reloading audio");
        this.closeMicThread();
        Map<UUID, AudioChannel> map = this.audioChannels;
        synchronized (map) {
            Voicechat.LOGGER.info("Clearing audio channels");
            this.audioChannels.forEach((uuid, audioChannel) -> audioChannel.closeAndKill());
            this.audioChannels.clear();
            try {
                Voicechat.LOGGER.info("Restarting sound manager");
                this.reloadSoundManager();
            }
            catch (SpeakerException e) {
                e.printStackTrace();
            }
        }
        Voicechat.LOGGER.info("Starting microphone thread");
        if (this.connection != null) {
            this.startMicThread(this.connection);
        }
    }

    private void startMicThread(ClientVoicechatConnection connection) {
        if (this.micThread != null) {
            this.micThread.close();
        }
        try {
            this.micThread = new MicThread(this, connection);
            this.micThread.start();
        }
        catch (Exception e) {
            Voicechat.LOGGER.error("Failed to start microphone thread: {}", (Object)e.getMessage());
            ClientManager.sendPlayerError("message.voicechat.microphone_unavailable", e);
        }
    }

    public void closeMicThread() {
        if (this.micThread != null) {
            Voicechat.LOGGER.info("Stopping microphone thread");
            this.micThread.close();
            this.micThread = null;
        }
    }

    public void toggleRecording() {
        this.setRecording(this.recorder == null);
    }

    public void setRecording(boolean recording) {
        if (recording == (this.recorder != null)) {
            return;
        }
        class_746 player = class_310.method_1551().field_1724;
        if (recording) {
            if (this.connection == null || !this.connection.getData().allowRecording()) {
                if (player != null) {
                    player.method_7353((class_2561)class_2561.method_43471((String)"message.voicechat.recording_disabled"), true);
                }
                return;
            }
            this.recorder = AudioRecorder.create();
            if (player != null) {
                player.method_7353((class_2561)class_2561.method_43471((String)"message.voicechat.recording_started").method_27692(class_124.field_1079), true);
            }
            return;
        }
        AudioRecorder rec = this.recorder;
        this.recorder = null;
        if (player != null) {
            player.method_7353((class_2561)class_2561.method_43471((String)"message.voicechat.recording_stopped").method_27692(class_124.field_1079), true);
        }
        rec.saveAndClose();
    }

    @Nullable
    public MicThread getMicThread() {
        return this.micThread;
    }

    @Nullable
    public ClientVoicechatConnection getConnection() {
        return this.connection;
    }

    @Nullable
    public SoundManager getSoundManager() {
        return this.soundManager;
    }

    public TalkCache getTalkCache() {
        return this.talkCache;
    }

    @Nullable
    public AudioRecorder getRecorder() {
        return this.recorder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Map<UUID, AudioChannel> map = this.audioChannels;
        synchronized (map) {
            Voicechat.LOGGER.info("Clearing audio channels");
            this.audioChannels.forEach((uuid, audioChannel) -> audioChannel.closeAndKill());
            this.audioChannels.clear();
        }
        if (this.soundManager != null) {
            this.soundManager.close();
        }
        this.closeMicThread();
        if (this.connection != null) {
            this.connection.close();
        }
        if (this.recorder != null) {
            AudioRecorder rec = this.recorder;
            this.recorder = null;
            rec.saveAndClose();
        }
    }
}

