/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.plugins.impl.opus;

import com.sun.jna.ptr.PointerByReference;
import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.api.opus.OpusEncoder;
import de.maxhenkel.voicechat.opus4j.Opus;
import de.maxhenkel.voicechat.voice.common.Utils;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import javax.annotation.Nullable;

public class NativeOpusEncoderImpl
implements OpusEncoder {
    protected PointerByReference opusEncoder;
    protected int sampleRate;
    protected int frameSize;
    protected int maxPayloadSize;
    protected int application;

    private NativeOpusEncoderImpl(int sampleRate, int frameSize, int maxPayloadSize, int application) {
        this.sampleRate = sampleRate;
        this.frameSize = frameSize;
        this.maxPayloadSize = maxPayloadSize;
        this.application = application;
        this.open();
    }

    private void open() {
        if (this.opusEncoder != null) {
            return;
        }
        IntBuffer error = IntBuffer.allocate(1);
        this.opusEncoder = Opus.INSTANCE.opus_encoder_create(this.sampleRate, 1, this.application, error);
        if (error.get() != 0 && this.opusEncoder == null) {
            throw new IllegalStateException("Opus encoder error " + error.get());
        }
    }

    @Override
    public byte[] encode(short[] rawAudio) {
        ByteBuffer encoded;
        if (this.isClosed()) {
            throw new IllegalStateException("Encoder is closed");
        }
        ShortBuffer nonEncodedBuffer = ShortBuffer.wrap(rawAudio);
        int result = Opus.INSTANCE.opus_encode(this.opusEncoder, nonEncodedBuffer, this.frameSize, encoded = ByteBuffer.allocate(this.maxPayloadSize), encoded.capacity());
        if (result < 0) {
            throw new RuntimeException("Failed to encode audio data");
        }
        byte[] audio = new byte[result];
        encoded.get(audio);
        return audio;
    }

    @Override
    public void resetState() {
        if (this.isClosed()) {
            throw new IllegalStateException("Encoder is closed");
        }
        Opus.INSTANCE.opus_encoder_ctl(this.opusEncoder, 4028, new Object[0]);
    }

    @Override
    public boolean isClosed() {
        return this.opusEncoder == null;
    }

    @Override
    public void close() {
        if (this.isClosed()) {
            return;
        }
        Opus.INSTANCE.opus_encoder_destroy(this.opusEncoder);
        this.opusEncoder = null;
    }

    @Nullable
    public static NativeOpusEncoderImpl createEncoder(int sampleRate, int frameSize, int maxPayloadSize, int application) {
        return Utils.createSafe(() -> new NativeOpusEncoderImpl(sampleRate, frameSize, maxPayloadSize, application), e -> Voicechat.LOGGER.warn("Failed to load native Opus encoder: {}", (Object)e.getMessage()));
    }
}

