/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.plugins.impl.opus;

import de.maxhenkel.voicechat.concentus.OpusApplication;
import de.maxhenkel.voicechat.concentus.OpusEncoder;

public class JavaOpusEncoderImpl
implements de.maxhenkel.voicechat.api.opus.OpusEncoder {
    protected OpusEncoder opusEncoder;
    protected byte[] buffer;
    protected int sampleRate;
    protected int frameSize;
    protected int maxPayloadSize;
    protected int application;

    public JavaOpusEncoderImpl(int sampleRate, int frameSize, int maxPayloadSize, int application) {
        this.sampleRate = sampleRate;
        this.frameSize = frameSize;
        this.maxPayloadSize = maxPayloadSize;
        this.application = application;
        this.buffer = new byte[maxPayloadSize];
        this.open();
    }

    private void open() {
        if (this.opusEncoder != null) {
            return;
        }
        try {
            this.opusEncoder = new OpusEncoder(this.sampleRate, 1, JavaOpusEncoderImpl.getApplication(this.application));
        }
        catch (Exception e) {
            throw new IllegalStateException("Opus encoder error " + e.getMessage());
        }
    }

    @Override
    public byte[] encode(short[] rawAudio) {
        int result;
        if (this.isClosed()) {
            throw new IllegalStateException("Encoder is closed");
        }
        try {
            result = this.opusEncoder.encode(rawAudio, 0, this.frameSize, this.buffer, 0, this.buffer.length);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to encode audio data: " + e.getMessage());
        }
        if (result < 0) {
            throw new RuntimeException("Failed to encode audio data");
        }
        byte[] audio = new byte[result];
        System.arraycopy(this.buffer, 0, audio, 0, result);
        return audio;
    }

    @Override
    public void resetState() {
        if (this.isClosed()) {
            throw new IllegalStateException("Encoder is closed");
        }
        this.opusEncoder.resetState();
    }

    @Override
    public boolean isClosed() {
        return this.opusEncoder == null;
    }

    @Override
    public void close() {
        if (this.isClosed()) {
            return;
        }
        this.opusEncoder = null;
    }

    public static OpusApplication getApplication(int application) {
        switch (application) {
            default: {
                return OpusApplication.OPUS_APPLICATION_VOIP;
            }
            case 2049: {
                return OpusApplication.OPUS_APPLICATION_AUDIO;
            }
            case 2051: 
        }
        return OpusApplication.OPUS_APPLICATION_RESTRICTED_LOWDELAY;
    }
}

