/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunky.util;

import java.util.Optional;

public class Parameter {
    private final String type;
    private final String value;

    public Parameter(String type, String value) {
        this.type = type;
        this.value = value;
    }

    public Parameter(String expression) {
        String[] parts = expression.split("=");
        this.type = parts[0];
        this.value = parts.length > 1 ? parts[1] : null;
    }

    public static Parameter of(String expression) {
        return new Parameter(expression);
    }

    public static Parameter of(String type, String value) {
        return new Parameter(type, value);
    }

    public String getType() {
        return this.type;
    }

    public Optional<String> getValue() {
        return Optional.ofNullable(this.value);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.type);
        if (this.value != null) {
            builder.append("=").append(this.value);
        }
        return builder.toString();
    }
}

