/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.betterfabricconsole.console;

import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.context.ParsedCommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.Iterator;
import java.util.regex.Pattern;
import net.minecraft.server.MinecraftServer;
import org.jline.reader.Highlighter;
import org.jline.reader.LineReader;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;
import xyz.jpenilla.betterfabricconsole.configuration.Config;
import xyz.jpenilla.betterfabricconsole.util.Util;

public record MinecraftCommandHighlighter(MinecraftServer server, Config.StyleColor[] colors) implements Highlighter
{
    public AttributedString highlight(LineReader reader, String buffer) {
        ParsedCommandNode node;
        AttributedStringBuilder builder = new AttributedStringBuilder();
        StringReader stringReader = Util.prepareStringReader(buffer);
        ParseResults results = this.server.method_3734().method_9235().parse(stringReader, (Object)this.server.method_3739());
        int pos = 0;
        if (buffer.startsWith("/")) {
            builder.append((CharSequence)"/", AttributedStyle.DEFAULT);
            pos = 1;
        }
        int colorIndex = -1;
        Iterator iterator = results.getContext().getLastChild().getNodes().iterator();
        while (iterator.hasNext() && (node = (ParsedCommandNode)iterator.next()).getRange().getStart() < buffer.length()) {
            int start = node.getRange().getStart();
            int end = Math.min(node.getRange().getEnd(), buffer.length());
            if (node.getNode() instanceof LiteralCommandNode) {
                builder.append((CharSequence)buffer.substring(pos, start), AttributedStyle.DEFAULT);
                builder.append((CharSequence)buffer.substring(start, end), AttributedStyle.DEFAULT);
            } else {
                if (++colorIndex >= this.colors.length) {
                    colorIndex = 0;
                }
                builder.append((CharSequence)buffer.substring(pos, start), AttributedStyle.DEFAULT);
                builder.append((CharSequence)buffer.substring(start, end), AttributedStyle.DEFAULT.foreground(this.colors[colorIndex].index()));
            }
            pos = end;
        }
        if (pos < buffer.length()) {
            builder.append((CharSequence)buffer.substring(pos), AttributedStyle.DEFAULT.foreground(1));
        }
        return builder.toAttributedString();
    }

    public void setErrorPattern(Pattern errorPattern) {
    }

    public void setErrorIndex(int errorIndex) {
    }
}

