/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.betterfabricconsole;

import com.mojang.logging.LogUtils;
import io.papermc.paper.console.HexFormattingConverter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.entrypoint.PreLaunchEntrypoint;
import org.apache.logging.log4j.core.config.plugins.util.PluginRegistry;
import org.apache.logging.log4j.core.config.plugins.util.PluginType;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.spongepowered.configurate.CommentedConfigurationNode;
import org.spongepowered.configurate.hocon.HoconConfigurationLoader;
import xyz.jpenilla.betterfabricconsole.configuration.Config;
import xyz.jpenilla.betterfabricconsole.console.ConsoleSetup;
import xyz.jpenilla.betterfabricconsole.console.ConsoleState;
import xyz.jpenilla.betterfabricconsole.remap.MappingsCache;
import xyz.jpenilla.betterfabricconsole.remap.RemapMode;
import xyz.jpenilla.betterfabricconsole.remap.Remapper;

public final class BetterFabricConsolePreLaunch
implements PreLaunchEntrypoint {
    private static final Logger LOGGER = LogUtils.getLogger();
    static @MonotonicNonNull BetterFabricConsolePreLaunch INSTANCE;
    @MonotonicNonNull ModContainer modContainer;
    @MonotonicNonNull Config config;
    @MonotonicNonNull ConsoleState consoleState;

    public void onPreLaunch() {
        INSTANCE = this;
        try {
            BetterFabricConsolePreLaunch.loadPluginsFromClassLoader(HexFormattingConverter.class.getClassLoader());
        }
        catch (ReflectiveOperationException e) {
            LOGGER.error("Failed to load extra Log4j2 plugins", (Throwable)e);
        }
        this.modContainer = (ModContainer)FabricLoader.getInstance().getModContainer("better-fabric-console").orElseThrow(() -> new IllegalStateException("Could not find mod container for better-fabric-console"));
        this.loadModConfig();
        this.initConsole();
    }

    private void loadModConfig() {
        Path configFile = FabricLoader.getInstance().getConfigDir().resolve(this.modContainer.getMetadata().getId() + ".conf");
        HoconConfigurationLoader loader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().path(configFile)).build();
        try {
            if (!Files.exists(configFile.getParent(), new LinkOption[0])) {
                Files.createDirectories(configFile.getParent(), new FileAttribute[0]);
            }
            CommentedConfigurationNode load = (CommentedConfigurationNode)loader.load();
            this.config = (Config)load.get(Config.class);
            loader.save(loader.createNode(node -> node.set((Object)this.config)));
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to load config", ex);
        }
    }

    private void initConsole() {
        LOGGER.info("Initializing Better Fabric Console...");
        @Nullable Remapper remapper = this.createRemapper();
        this.consoleState = ConsoleSetup.init(remapper, this.config);
    }

    private @Nullable Remapper createRemapper() {
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            LOGGER.info("Skipping Better Fabric Console mappings initialization, we are in a development environment (already mapped).");
            return null;
        }
        if (this.config.remapMode() == RemapMode.NONE) {
            return null;
        }
        LOGGER.info("Initializing Better Fabric Console mappings...");
        MappingsCache mappingsCache = new MappingsCache(FabricLoader.getInstance().getGameDir().resolve("better-fabric-console/mappings-cache"));
        return this.config.remapMode().createRemapper(mappingsCache);
    }

    private static void loadPluginsFromClassLoader(ClassLoader loader) throws ReflectiveOperationException {
        PluginRegistry registry = PluginRegistry.getInstance();
        Method decodeCacheFiles = PluginRegistry.class.getDeclaredMethod("decodeCacheFiles", ClassLoader.class);
        decodeCacheFiles.setAccessible(true);
        Map newPlugins = (Map)decodeCacheFiles.invoke((Object)registry, loader);
        Map pluginsByCategory = registry.loadFromMainClassLoader();
        newPlugins.forEach((category, discoveredPlugins) -> {
            List forCategory = pluginsByCategory.computeIfAbsent(category, c -> discoveredPlugins);
            if (forCategory == discoveredPlugins) {
                return;
            }
            for (PluginType pluginType : discoveredPlugins) {
                if (forCategory.contains(pluginType)) continue;
                forCategory.add(pluginType);
            }
        });
    }
}

