/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunky.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.popcraft.chunky.Chunky;
import org.popcraft.chunky.GenerationTask;
import org.popcraft.chunky.command.ChunkyCommand;
import org.popcraft.chunky.platform.Sender;
import org.popcraft.chunky.platform.World;
import org.popcraft.chunky.util.Input;

public class CancelCommand
extends ChunkyCommand {
    public CancelCommand(Chunky chunky) {
        super(chunky);
    }

    @Override
    public void execute(Sender sender, String[] args) {
        Runnable cancelAction;
        Map<String, GenerationTask> generationTasks = this.chunky.getGenerationTasks();
        if (generationTasks.isEmpty() && this.chunky.getConfig().loadTasks().stream().allMatch(GenerationTask::isCancelled)) {
            sender.sendMessagePrefixed("format_cancel_no_tasks", new Object[0]);
            return;
        }
        if (args.length > 1) {
            Optional<World> world = Input.tryWorld(this.chunky, String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length)));
            if (!world.isPresent()) {
                sender.sendMessage("help_cancel", new Object[0]);
                return;
            }
            cancelAction = () -> {
                sender.sendMessagePrefixed("format_cancel", ((World)world.get()).getName());
                this.chunky.getConfig().cancelTask((World)world.get());
                if (this.chunky.getGenerationTasks().containsKey(((World)world.get()).getName())) {
                    this.chunky.getGenerationTasks().remove(((World)world.get()).getName()).stop(true);
                }
            };
        } else {
            cancelAction = () -> {
                sender.sendMessagePrefixed("format_cancel_all", new Object[0]);
                this.chunky.getConfig().cancelTasks();
                this.chunky.getGenerationTasks().values().forEach(generationTask -> generationTask.stop(true));
                this.chunky.getGenerationTasks().clear();
                this.chunky.getScheduler().cancelTasks();
            };
        }
        this.chunky.setPendingAction(sender, cancelAction);
        sender.sendMessagePrefixed("format_cancel_confirm", "/chunky confirm");
    }

    @Override
    public List<String> tabSuggestions(String[] args) {
        if (args.length == 2) {
            ArrayList<String> suggestions = new ArrayList<String>();
            this.chunky.getServer().getWorlds().forEach(world -> suggestions.add(world.getName()));
            return suggestions;
        }
        return Collections.emptyList();
    }
}

