/*
 * Decompiled with CFR 0.152.
 */
package me.wesley1808.servercore.mixin.features.activation_range;

import me.wesley1808.servercore.common.ServerCore;
import me.wesley1808.servercore.common.interfaces.activation_range.ActivationEntity;
import me.wesley1808.servercore.common.interfaces.activation_range.InactiveEntity;
import me.wesley1808.servercore.common.utils.ActivationRange;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1313;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1297.class})
public abstract class EntityMixin
implements ActivationEntity,
InactiveEntity {
    @Shadow
    public class_1937 field_6002;
    @Unique
    private int activatedTick = Integer.MIN_VALUE;
    @Unique
    private int activatedImmunityTick = Integer.MIN_VALUE;
    @Unique
    private boolean isInactive = false;
    @Unique
    private ActivationRange.ActivationType activationType;
    @Unique
    private boolean excluded = false;
    @Unique
    private int fullTickCount;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    public void servercore$setupActivationStates(class_1299<?> type, class_1937 level, CallbackInfo ci) {
        class_1297 entity = (class_1297)this;
        this.activationType = ActivationRange.initializeEntityActivationType(entity);
        this.excluded = level == null || ActivationRange.isExcluded(entity);
    }

    @Inject(method={"move"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;limitPistonMovement(Lnet/minecraft/world/phys/Vec3;)Lnet/minecraft/world/phys/Vec3;", shift=At.Shift.BEFORE)})
    public void servercore$onPistonMove(class_1313 moverType, class_243 vec3, CallbackInfo ci) {
        if (!this.field_6002.field_9236) {
            int ticks = ServerCore.getServer().method_3780() + 20;
            this.activatedTick = Math.max(this.activatedTick, ticks);
            this.activatedImmunityTick = Math.max(this.activatedImmunityTick, ticks);
        }
    }

    @Inject(method={"push(DDD)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void servercore$ignorePushingWhileInactive(double x, double y, double z, CallbackInfo ci) {
        if (this.isInactive && !this.field_6002.field_9236) {
            ci.cancel();
        }
    }

    @Override
    public ActivationRange.ActivationType getActivationType() {
        return this.activationType;
    }

    @Override
    public boolean isExcluded() {
        return this.excluded;
    }

    @Override
    public int getActivatedTick() {
        return this.activatedTick;
    }

    @Override
    public void setActivatedTick(int tick) {
        this.activatedTick = tick;
    }

    @Override
    public int getActivatedImmunityTick() {
        return this.activatedImmunityTick;
    }

    @Override
    public void setActivatedImmunityTick(int tick) {
        this.activatedImmunityTick = tick;
    }

    @Override
    public void setInactive(boolean inactive) {
        this.isInactive = inactive;
    }

    @Override
    public int getFullTickCount() {
        return this.fullTickCount;
    }

    @Override
    public void incFullTickCount() {
        ++this.fullTickCount;
    }

    @Override
    public void inactiveTick() {
    }
}

