/*
 * Decompiled with CFR 0.152.
 */
package me.wesley1808.servercore.common.collections;

import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.List;
import me.wesley1808.servercore.common.collections.PooledHashSets;
import me.wesley1808.servercore.common.interfaces.IServerPlayer;
import net.minecraft.class_1923;
import net.minecraft.class_3222;
import net.minecraft.class_4076;

public final class PlayerMobDistanceMap {
    private static final PooledHashSets.PooledObjectLinkedOpenHashSet<class_3222> EMPTY_SET = new PooledHashSets.PooledObjectLinkedOpenHashSet();
    private final Object2ObjectOpenHashMap<class_3222, class_4076> players = new Object2ObjectOpenHashMap();
    private final Long2ObjectOpenHashMap<PooledHashSets.PooledObjectLinkedOpenHashSet<class_3222>> playerMap = new Long2ObjectOpenHashMap(32, 0.5f);
    private final PooledHashSets<class_3222> pooledHashSets = new PooledHashSets();
    private int viewDistance;

    public PooledHashSets.PooledObjectLinkedOpenHashSet<class_3222> getPlayersInRange(class_1923 chunkPos) {
        return this.getPlayersInRange(chunkPos.field_9181, chunkPos.field_9180);
    }

    public PooledHashSets.PooledObjectLinkedOpenHashSet<class_3222> getPlayersInRange(int chunkX, int chunkZ) {
        return (PooledHashSets.PooledObjectLinkedOpenHashSet)this.playerMap.getOrDefault(class_1923.method_8331((int)chunkX, (int)chunkZ), EMPTY_SET);
    }

    public void update(List<class_3222> currentPlayers, int newViewDistance) {
        ObjectLinkedOpenHashSet gone = new ObjectLinkedOpenHashSet((ObjectCollection)this.players.keySet());
        int oldViewDistance = this.viewDistance;
        this.viewDistance = newViewDistance;
        for (class_3222 player : currentPlayers) {
            if (player.method_7325()) continue;
            gone.remove((Object)player);
            class_4076 newPosition = player.method_14232();
            class_4076 oldPosition = (class_4076)this.players.put((Object)player, (Object)newPosition);
            if (oldPosition == null) {
                this.addNewPlayer(player, newPosition, newViewDistance);
                continue;
            }
            this.updatePlayer(player, oldPosition, newPosition, oldViewDistance, newViewDistance);
        }
        for (class_3222 player : gone) {
            class_4076 oldPosition = (class_4076)this.players.remove((Object)player);
            if (oldPosition == null) continue;
            this.removePlayer(player, oldPosition, oldViewDistance);
        }
    }

    private void addPlayerTo(class_3222 player, int chunkX, int chunkZ) {
        this.playerMap.compute(class_1923.method_8331((int)chunkX, (int)chunkZ), (key, players) -> {
            if (players == null) {
                return ((IServerPlayer)player).getCachedSingleMobDistanceMap();
            }
            return this.pooledHashSets.findMapWith((PooledHashSets.PooledObjectLinkedOpenHashSet<class_3222>)players, player);
        });
    }

    private void removePlayerFrom(class_3222 player, int chunkX, int chunkZ) {
        this.playerMap.compute(class_1923.method_8331((int)chunkX, (int)chunkZ), (keyInMap, players) -> {
            if (players == null) {
                return ((IServerPlayer)player).getCachedSingleMobDistanceMap();
            }
            return this.pooledHashSets.findMapWithout((PooledHashSets.PooledObjectLinkedOpenHashSet<class_3222>)players, player);
        });
    }

    private void updatePlayer(class_3222 player, class_4076 oldPosition, class_4076 newPosition, int oldViewDistance, int newViewDistance) {
        int totalZ;
        int toX = newPosition.method_10263();
        int toZ = newPosition.method_10260();
        int fromX = oldPosition.method_10263();
        int fromZ = oldPosition.method_10260();
        int dx = toX - fromX;
        int dz = toZ - fromZ;
        int totalX = Math.abs(fromX - toX);
        if (Math.max(totalX, totalZ = Math.abs(fromZ - toZ)) > 2 * oldViewDistance) {
            this.removePlayer(player, oldPosition, oldViewDistance);
            this.addNewPlayer(player, newPosition, newViewDistance);
            return;
        }
        if (oldViewDistance == newViewDistance) {
            int currZ;
            int currX;
            int minZ;
            int maxZ;
            int minX;
            int maxX;
            int up = 1 | dz >> 31;
            int right = 1 | dx >> 31;
            if (dx != 0) {
                maxX = toX + oldViewDistance * right + right;
                minX = fromX + oldViewDistance * right + right;
                maxZ = fromZ + oldViewDistance * up + up;
                minZ = toZ - oldViewDistance * up;
                for (currX = minX; currX != maxX; currX += right) {
                    for (currZ = minZ; currZ != maxZ; currZ += up) {
                        this.addPlayerTo(player, currX, currZ);
                    }
                }
            }
            if (dz != 0) {
                maxX = toX + oldViewDistance * right + right;
                minX = toX - oldViewDistance * right;
                maxZ = toZ + oldViewDistance * up + up;
                minZ = fromZ + oldViewDistance * up + up;
                for (currX = minX; currX != maxX; currX += right) {
                    for (currZ = minZ; currZ != maxZ; currZ += up) {
                        this.addPlayerTo(player, currX, currZ);
                    }
                }
            }
            if (dx != 0) {
                maxX = toX - oldViewDistance * right;
                minX = fromX - oldViewDistance * right;
                maxZ = fromZ + oldViewDistance * up + up;
                minZ = toZ - oldViewDistance * up;
                for (currX = minX; currX != maxX; currX += right) {
                    for (currZ = minZ; currZ != maxZ; currZ += up) {
                        this.removePlayerFrom(player, currX, currZ);
                    }
                }
            }
            if (dz != 0) {
                maxX = fromX + oldViewDistance * right + right;
                minX = fromX - oldViewDistance * right;
                maxZ = toZ - oldViewDistance * up;
                minZ = fromZ - oldViewDistance * up;
                for (currX = minX; currX != maxX; currX += right) {
                    for (currZ = minZ; currZ != maxZ; currZ += up) {
                        this.removePlayerFrom(player, currX, currZ);
                    }
                }
            }
        } else {
            this.removePlayer(player, oldPosition, oldViewDistance);
            this.addNewPlayer(player, newPosition, newViewDistance);
        }
    }

    private void removePlayer(class_3222 player, class_4076 position, int viewDistance) {
        int x = position.method_10263();
        int z = position.method_10260();
        for (int xoff = -viewDistance; xoff <= viewDistance; ++xoff) {
            for (int zoff = -viewDistance; zoff <= viewDistance; ++zoff) {
                this.removePlayerFrom(player, x + xoff, z + zoff);
            }
        }
    }

    private void addNewPlayer(class_3222 player, class_4076 position, int viewDistance) {
        int x = position.method_10263();
        int z = position.method_10260();
        for (int xoff = -viewDistance; xoff <= viewDistance; ++xoff) {
            for (int zoff = -viewDistance; zoff <= viewDistance; ++zoff) {
                this.addPlayerTo(player, x + xoff, z + zoff);
            }
        }
    }
}

