/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me;

import com.ibm.asyncutil.util.Combinators;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.fabricmc.api.ModInitializer;
import net.minecraft.class_2919;
import net.minecraft.class_4486;
import net.minecraft.class_5819;
import net.minecraft.class_6575;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.MixinEnvironment;

public class C2MEMod
implements ModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"C2ME");

    public void onInitialize() {
        if (Boolean.getBoolean("com.ishland.c2me.mixin.doAudit")) {
            MixinEnvironment.getCurrentEnvironment().audit();
        }
        if (Boolean.getBoolean("com.ishland.c2me.runCompressionBenchmark")) {
            LOGGER.info("Benchmarking chunk stream speed");
            LOGGER.info("Warming up");
            for (int i = 0; i < 3; ++i) {
                this.runBenchmark("GZIP", class_4486.field_20442, true);
                this.runBenchmark("DEFLATE", class_4486.field_20443, true);
                this.runBenchmark("UNCOMPRESSED", class_4486.field_20444, true);
            }
            this.runBenchmark("GZIP", class_4486.field_20442, false);
            this.runBenchmark("DEFLATE", class_4486.field_20443, false);
            this.runBenchmark("UNCOMPRESSED", class_4486.field_20444, false);
        }
        this.consistencyTest();
    }

    private void runBenchmark(String name, class_4486 version, boolean suppressLog) {
        try {
            DecimalFormat decimalFormat = new DecimalFormat("0.###");
            if (!suppressLog) {
                LOGGER.info("Generating 128MB random data");
            }
            byte[] bytes = new byte[0x8000000];
            new Random().nextBytes(bytes);
            if (!suppressLog) {
                LOGGER.info("Starting benchmark for {}", (Object)name);
            }
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            OutputStream wrappedOutputStream = version.method_21886((OutputStream)outputStream);
            long startTime = System.nanoTime();
            wrappedOutputStream.write(bytes);
            wrappedOutputStream.close();
            long endTime = System.nanoTime();
            if (!suppressLog) {
                LOGGER.info("{} write speed: {} MB/s ({} MB/s compressed)", new Object[]{name, decimalFormat.format((double)bytes.length / 1024.0 / 1024.0 / ((double)(endTime - startTime) / 1.0E9)), decimalFormat.format((double)outputStream.size() / 1024.0 / 1024.0 / ((double)(endTime - startTime) / 1.0E9))});
            }
            if (!suppressLog) {
                LOGGER.info("{} compression ratio: {} %", (Object)name, (Object)decimalFormat.format((double)outputStream.size() / (double)bytes.length * 100.0));
            }
            ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
            InputStream wrappedInputStream = version.method_21885((InputStream)inputStream);
            long startTime2 = System.nanoTime();
            byte[] readAllBytes = wrappedInputStream.readAllBytes();
            wrappedInputStream.close();
            long endTime2 = System.nanoTime();
            if (!suppressLog) {
                LOGGER.info("{} read speed: {} MB/s ({} MB/s compressed)", new Object[]{name, decimalFormat.format((double)readAllBytes.length / 1024.0 / 1024.0 / ((double)(endTime2 - startTime2) / 1.0E9)), decimalFormat.format((double)outputStream.size() / 1024.0 / 1024.0 / ((double)(endTime2 - startTime2) / 1.0E9))});
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void consistencyTest() {
        int taskSize = 512;
        AtomicIntegerArray array = new AtomicIntegerArray(taskSize);
        List<CompletableFuture> futures = IntStream.range(0, taskSize).mapToObj(value -> CompletableFuture.supplyAsync(() -> {
            class_2919 chunkRandom = new class_2919((class_5819)new class_6575(System.nanoTime()));
            chunkRandom.method_33650(4096);
            int i = chunkRandom.method_43054();
            array.set(value, i);
            return i;
        })).toList();
        List join = (List)Combinators.collect(futures, Collectors.toList()).toCompletableFuture().join();
        for (int i = 0; i < taskSize; ++i) {
            if (array.get(i) == ((Integer)join.get(i)).intValue()) continue;
            throw new IllegalArgumentException("Mismatch at index " + i);
        }
    }
}

