/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.pluginmessage.channel;

import com.google.inject.Inject;
import java.util.UUID;
import org.geysermc.floodgate.api.UnsafeFloodgateApi;
import org.geysermc.floodgate.platform.pluginmessage.PluginMessageUtils;
import org.geysermc.floodgate.pluginmessage.PluginMessageChannel;

public final class PacketChannel
implements PluginMessageChannel {
    @Inject
    private PluginMessageUtils pluginMessageUtils;

    @Override
    public String getIdentifier() {
        return "floodgate:packet";
    }

    @Override
    public PluginMessageChannel.Result handleProxyCall(byte[] data, UUID targetUuid, String targetUsername, PluginMessageChannel.Identity targetIdentity, UUID sourceUuid, String sourceUsername, PluginMessageChannel.Identity sourceIdentity) {
        if (sourceIdentity == PluginMessageChannel.Identity.SERVER) {
            return PluginMessageChannel.Result.forward();
        }
        if (sourceIdentity == PluginMessageChannel.Identity.PLAYER) {
            return this.handleServerCall(data, targetUuid, targetUsername);
        }
        return PluginMessageChannel.Result.handled();
    }

    @Override
    public PluginMessageChannel.Result handleServerCall(byte[] data, UUID targetUuid, String targetUsername) {
        return PluginMessageChannel.Result.kick("Cannot send packets from Geyser/Floodgate to Floodgate");
    }

    public boolean sendPacket(UUID player, byte[] packet, UnsafeFloodgateApi api) {
        if (api == null) {
            throw new IllegalArgumentException("Can only send a packet using the unsafe api");
        }
        return this.pluginMessageUtils.sendMessage(player, this.getIdentifier(), packet);
    }
}

