/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.player;

import com.google.common.base.Charsets;
import io.netty.channel.Channel;
import io.netty.util.AttributeKey;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.ObjectObjectImmutablePair;
import java.net.InetSocketAddress;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import lombok.NonNull;
import org.geysermc.floodgate.addon.data.HandshakeDataImpl;
import org.geysermc.floodgate.addon.data.HandshakeHandlersImpl;
import org.geysermc.floodgate.api.SimpleFloodgateApi;
import org.geysermc.floodgate.api.handshake.HandshakeData;
import org.geysermc.floodgate.api.logger.FloodgateLogger;
import org.geysermc.floodgate.api.player.FloodgatePlayer;
import org.geysermc.floodgate.api.player.PropertyKey;
import org.geysermc.floodgate.config.FloodgateConfigHolder;
import org.geysermc.floodgate.crypto.FloodgateCipher;
import org.geysermc.floodgate.player.FloodgatePlayerImpl;
import org.geysermc.floodgate.player.HostnameSeparationResult;
import org.geysermc.floodgate.skin.SkinUploadManager;
import org.geysermc.floodgate.util.BedrockData;
import org.geysermc.floodgate.util.InvalidFormatException;
import org.geysermc.floodgate.util.LinkedPlayer;
import org.geysermc.floodgate.util.Utils;

public final class FloodgateHandshakeHandler {
    private final HandshakeHandlersImpl handshakeHandlers;
    private final SimpleFloodgateApi api;
    private final FloodgateCipher cipher;
    private final FloodgateConfigHolder configHolder;
    private final SkinUploadManager skinUploadManager;
    private final AttributeKey<FloodgatePlayer> playerAttribute;
    private final FloodgateLogger logger;

    public FloodgateHandshakeHandler(HandshakeHandlersImpl handshakeHandlers, SimpleFloodgateApi api, FloodgateCipher cipher, FloodgateConfigHolder configHolder, SkinUploadManager skinUploadManager, AttributeKey<FloodgatePlayer> playerAttribute, FloodgateLogger logger) {
        this.handshakeHandlers = handshakeHandlers;
        this.api = api;
        this.cipher = cipher;
        this.configHolder = configHolder;
        this.skinUploadManager = skinUploadManager;
        this.playerAttribute = playerAttribute;
        this.logger = logger;
    }

    public HostnameSeparationResult separateHostname(@NonNull String hostname) {
        if (hostname == null) {
            throw new NullPointerException("hostname is marked non-null but is null");
        }
        String[] hostnameItems = hostname.split("\u0000");
        String floodgateData = null;
        int dataVersion = -1;
        StringBuilder builder = new StringBuilder();
        for (String value : hostnameItems) {
            int version = FloodgateCipher.version(value);
            if (floodgateData == null && version != -1) {
                floodgateData = value;
                dataVersion = version;
                continue;
            }
            if (builder.length() > 0) {
                builder.append('\u0000');
            }
            builder.append(value);
        }
        return new HostnameSeparationResult(floodgateData, dataVersion, builder.toString());
    }

    public CompletableFuture<HandshakeResult> handle(@NonNull Channel channel, @NonNull String floodgateDataString, @NonNull String hostname) {
        if (channel == null) {
            throw new NullPointerException("channel is marked non-null but is null");
        }
        if (floodgateDataString == null) {
            throw new NullPointerException("floodgateDataString is marked non-null but is null");
        }
        if (hostname == null) {
            throw new NullPointerException("hostname is marked non-null but is null");
        }
        byte[] floodgateData = floodgateDataString.getBytes(Charsets.UTF_8);
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            String decrypted;
            try {
                decrypted = this.cipher.decryptToString(floodgateData);
            }
            catch (InvalidFormatException e) {
                throw this.callHandlerAndReturnResult(ResultType.NOT_FLOODGATE_DATA, channel, null, hostname);
            }
            catch (Exception e) {
                if (this.configHolder.get().isDebug()) {
                    e.printStackTrace();
                }
                throw this.callHandlerAndReturnResult(ResultType.DECRYPT_ERROR, channel, null, hostname);
            }
            try {
                BedrockData bedrockData = BedrockData.fromString(decrypted);
                if (bedrockData.getDataLength() != 12) {
                    throw this.callHandlerAndReturnResult(ResultType.INVALID_DATA_LENGTH, channel, bedrockData, hostname);
                }
                if (bedrockData.hasPlayerLink()) {
                    throw this.handlePart2(channel, hostname, bedrockData, bedrockData.getLinkedPlayer());
                }
                return bedrockData;
            }
            catch (Exception exception) {
                if (exception instanceof HandshakeResult) {
                    throw (HandshakeResult)exception;
                }
                exception.printStackTrace();
                throw this.callHandlerAndReturnResult(ResultType.EXCEPTION, channel, null, hostname);
            }
        }).thenCompose(this::fetchLinkedPlayer)).handle((result, error) -> {
            if (error == null) {
                return this.handlePart2(channel, hostname, (BedrockData)result.left(), (LinkedPlayer)result.right());
            }
            if (error instanceof CompletionException) {
                if (error.getCause() == null) {
                    error.printStackTrace();
                }
                error = error.getCause();
            }
            if (error instanceof HandshakeResult) {
                return (HandshakeResult)error;
            }
            error.printStackTrace();
            return this.callHandlerAndReturnResult(ResultType.EXCEPTION, channel, null, hostname);
        });
    }

    private HandshakeResult handlePart2(Channel channel, String hostname, BedrockData bedrockData, LinkedPlayer linkedPlayer) {
        try {
            HandshakeDataImpl handshakeData = new HandshakeDataImpl(channel, true, bedrockData.clone(), this.configHolder.get(), linkedPlayer != null ? linkedPlayer.clone() : null, hostname);
            if (this.configHolder.get().getPlayerLink().isRequireLink() && linkedPlayer == null) {
                handshakeData.setDisconnectReason("floodgate.core.not_linked");
            }
            this.handshakeHandlers.callHandshakeHandlers(handshakeData);
            if (!handshakeData.shouldDisconnect()) {
                this.skinUploadManager.addConnectionIfNeeded(bedrockData.getSubscribeId(), bedrockData.getVerifyCode());
            }
            FloodgatePlayerImpl player = FloodgatePlayerImpl.from(bedrockData, handshakeData);
            this.api.addPlayer(player);
            channel.attr(this.playerAttribute).set((Object)player);
            int port = ((InetSocketAddress)channel.remoteAddress()).getPort();
            InetSocketAddress socketAddress = new InetSocketAddress(handshakeData.getIp(), port);
            player.addProperty(PropertyKey.SOCKET_ADDRESS, (Object)socketAddress);
            return new HandshakeResult(ResultType.SUCCESS, handshakeData, bedrockData, player);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return this.callHandlerAndReturnResult(ResultType.EXCEPTION, channel, null, hostname);
        }
    }

    private HandshakeResult callHandlerAndReturnResult(ResultType resultType, Channel channel, BedrockData bedrockData, String hostname) {
        HandshakeDataImpl handshakeData = new HandshakeDataImpl(channel, bedrockData != null, bedrockData, this.configHolder.get(), null, hostname);
        this.handshakeHandlers.callHandshakeHandlers(handshakeData);
        return new HandshakeResult(resultType, handshakeData, bedrockData, null);
    }

    private CompletableFuture<Pair<BedrockData, LinkedPlayer>> fetchLinkedPlayer(BedrockData data) {
        if (!this.api.getPlayerLink().isEnabled()) {
            return CompletableFuture.completedFuture(new ObjectObjectImmutablePair<BedrockData, Object>(data, null));
        }
        return ((CompletableFuture)this.api.getPlayerLink().getLinkedPlayer(Utils.getJavaUuid(data.getXuid())).thenApply(link -> new ObjectObjectImmutablePair<BedrockData, LinkedPlayer>(data, (LinkedPlayer)link))).handle((result, error) -> {
            if (error != null) {
                this.logger.error("The player linking implementation returned an error", error.getCause(), new Object[0]);
                return new ObjectObjectImmutablePair<BedrockData, Object>(data, null);
            }
            return result;
        });
    }

    public static class HandshakeResult
    extends IllegalStateException {
        private final ResultType resultType;
        private final HandshakeData handshakeData;
        private final BedrockData bedrockData;
        private final FloodgatePlayer floodgatePlayer;

        public InetSocketAddress getNewIp(Channel channel) {
            if (this.floodgatePlayer != null) {
                return (InetSocketAddress)this.floodgatePlayer.getProperty(PropertyKey.SOCKET_ADDRESS);
            }
            if (this.handshakeData.getIp() != null) {
                int port = ((InetSocketAddress)channel.remoteAddress()).getPort();
                return new InetSocketAddress(this.handshakeData.getIp(), port);
            }
            return null;
        }

        protected HandshakeResult(ResultType resultType, HandshakeData handshakeData, BedrockData bedrockData, FloodgatePlayer floodgatePlayer) {
            this.resultType = resultType;
            this.handshakeData = handshakeData;
            this.bedrockData = bedrockData;
            this.floodgatePlayer = floodgatePlayer;
        }

        public ResultType getResultType() {
            return this.resultType;
        }

        public HandshakeData getHandshakeData() {
            return this.handshakeData;
        }

        public BedrockData getBedrockData() {
            return this.bedrockData;
        }

        public FloodgatePlayer getFloodgatePlayer() {
            return this.floodgatePlayer;
        }
    }

    public static enum ResultType {
        EXCEPTION,
        NOT_FLOODGATE_DATA,
        DECRYPT_ERROR,
        INVALID_DATA_LENGTH,
        SUCCESS;

    }
}

