/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.addon.data;

import com.mojang.authlib.GameProfile;
import com.mojang.logging.LogUtils;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.AttributeKey;
import java.net.InetSocketAddress;
import net.minecraft.class_140;
import net.minecraft.class_2535;
import net.minecraft.class_2561;
import net.minecraft.class_2889;
import net.minecraft.class_2915;
import net.minecraft.class_3248;
import org.geysermc.floodgate.MinecraftServerHolder;
import org.geysermc.floodgate.addon.data.CommonDataHandler;
import org.geysermc.floodgate.addon.data.PacketBlocker;
import org.geysermc.floodgate.api.logger.FloodgateLogger;
import org.geysermc.floodgate.api.player.FloodgatePlayer;
import org.geysermc.floodgate.config.FloodgateConfig;
import org.geysermc.floodgate.mixin.ClientIntentionPacketMixin;
import org.geysermc.floodgate.mixin.ConnectionMixin;
import org.geysermc.floodgate.mixin_interface.ServerLoginPacketListenerSetter;
import org.geysermc.floodgate.player.FloodgateHandshakeHandler;
import org.slf4j.Logger;

public final class FabricDataHandler
extends CommonDataHandler {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final FloodgateLogger logger;
    private class_2535 networkManager;
    private FloodgatePlayer player;

    public FabricDataHandler(FloodgateHandshakeHandler handshakeHandler, FloodgateConfig config, AttributeKey<String> kickMessageAttribute, FloodgateLogger logger) {
        super(handshakeHandler, config, kickMessageAttribute, new PacketBlocker());
        this.logger = logger;
    }

    @Override
    protected void setNewIp(Channel channel, InetSocketAddress newIp) {
        ((ConnectionMixin)this.networkManager).setAddress(newIp);
    }

    @Override
    protected Object setHostname(Object handshakePacket, String hostname) {
        ((ClientIntentionPacketMixin)handshakePacket).setAddress(hostname);
        return handshakePacket;
    }

    @Override
    protected boolean shouldRemoveHandler(FloodgateHandshakeHandler.HandshakeResult result) {
        this.player = result.getFloodgatePlayer();
        if (this.getKickMessage() != null) {
            return false;
        }
        if (this.player == null) {
            return true;
        }
        if (result.getResultType() == FloodgateHandshakeHandler.ResultType.SUCCESS) {
            this.logger.info("Floodgate player who is logged in as {} {} joined", this.player.getCorrectUsername(), this.player.getCorrectUniqueId());
        }
        return false;
    }

    @Override
    protected boolean channelRead(Object packet) {
        if (packet instanceof class_2889) {
            class_2889 intentionPacket = (class_2889)packet;
            this.ctx.pipeline().addAfter("splitter", "floodgate_packet_blocker", (ChannelHandler)this.blocker);
            this.networkManager = (class_2535)this.ctx.channel().pipeline().get("packet_handler");
            this.handle(packet, intentionPacket.method_36174());
            return false;
        }
        return !this.checkAndHandleLogin(packet);
    }

    private boolean checkAndHandleLogin(Object packet) {
        if (packet instanceof class_2915) {
            String kickMessage = this.getKickMessage();
            if (kickMessage != null) {
                this.networkManager.method_10747(class_2561.method_30163((String)kickMessage));
                return true;
            }
            if (!(this.networkManager.method_10744() instanceof class_3248)) {
                this.ctx.pipeline().remove((ChannelHandler)this);
                return true;
            }
            final GameProfile gameProfile = new GameProfile(this.player.getCorrectUniqueId(), this.player.getCorrectUsername());
            if (this.player.isLinked() && this.player.getCorrectUniqueId().version() == 4) {
                Thread texturesThread = new Thread("Bedrock Linked Player Texture Download"){

                    @Override
                    public void run() {
                        try {
                            MinecraftServerHolder.get().method_3844().fillProfileProperties(gameProfile, true);
                        }
                        catch (Exception e) {
                            LOGGER.error("Unable to get Bedrock linked player textures for " + gameProfile.getName(), e);
                        }
                        ((ServerLoginPacketListenerSetter)FabricDataHandler.this.networkManager.method_10744()).setGameProfile(gameProfile);
                        ((ServerLoginPacketListenerSetter)FabricDataHandler.this.networkManager.method_10744()).setLoginState();
                    }
                };
                texturesThread.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new class_140(LOGGER));
                texturesThread.start();
            } else {
                ((ServerLoginPacketListenerSetter)this.networkManager.method_10744()).setGameProfile(gameProfile);
                ((ServerLoginPacketListenerSetter)this.networkManager.method_10744()).setLoginState();
            }
            this.ctx.pipeline().remove((ChannelHandler)this);
            return true;
        }
        return false;
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        super.exceptionCaught(ctx, cause);
        if (this.config.isDebug()) {
            cause.printStackTrace();
        }
    }
}

